/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.sharding.strategy;

import com.dangdang.ddframe.job.exception.JobShardingStrategyClassConfigurationException;
import com.dangdang.ddframe.job.internal.sharding.strategy.JobShardingStrategy;
import com.dangdang.ddframe.job.plugin.sharding.strategy.AverageAllocationJobShardingStrategy;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public final class JobShardingStrategyFactory {
    public static JobShardingStrategy getStrategy(String jobShardingStrategyClassName) {
        if (Strings.isNullOrEmpty((String)jobShardingStrategyClassName)) {
            return new AverageAllocationJobShardingStrategy();
        }
        try {
            Class<?> jobShardingStrategyClass = Class.forName(jobShardingStrategyClassName);
            Preconditions.checkState((boolean)JobShardingStrategy.class.isAssignableFrom(jobShardingStrategyClass), (Object)String.format("Class [%s] is not job strategy class", jobShardingStrategyClassName));
            return (JobShardingStrategy)jobShardingStrategyClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new JobShardingStrategyClassConfigurationException(ex);
        }
    }

    private JobShardingStrategyFactory() {
    }
}

