/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.listener;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.internal.config.ConfigurationListenerManager;
import com.dangdang.ddframe.job.internal.election.ElectionListenerManager;
import com.dangdang.ddframe.job.internal.execution.ExecutionListenerManager;
import com.dangdang.ddframe.job.internal.failover.FailoverListenerManager;
import com.dangdang.ddframe.job.internal.guarantee.GuaranteeListenerManager;
import com.dangdang.ddframe.job.internal.server.JobOperationListenerManager;
import com.dangdang.ddframe.job.internal.sharding.ShardingListenerManager;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.List;

public class ListenerManager {
    private final ElectionListenerManager electionListenerManager;
    private final ShardingListenerManager shardingListenerManager;
    private final ExecutionListenerManager executionListenerManager;
    private final FailoverListenerManager failoverListenerManager;
    private final JobOperationListenerManager jobOperationListenerManager;
    private final ConfigurationListenerManager configurationListenerManager;
    private final GuaranteeListenerManager guaranteeListenerManager;

    public ListenerManager(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration, List<ElasticJobListener> elasticJobListeners) {
        this.electionListenerManager = new ElectionListenerManager(coordinatorRegistryCenter, jobConfiguration);
        this.shardingListenerManager = new ShardingListenerManager(coordinatorRegistryCenter, jobConfiguration);
        this.executionListenerManager = new ExecutionListenerManager(coordinatorRegistryCenter, jobConfiguration);
        this.failoverListenerManager = new FailoverListenerManager(coordinatorRegistryCenter, jobConfiguration);
        this.jobOperationListenerManager = new JobOperationListenerManager(coordinatorRegistryCenter, jobConfiguration);
        this.configurationListenerManager = new ConfigurationListenerManager(coordinatorRegistryCenter, jobConfiguration);
        this.guaranteeListenerManager = new GuaranteeListenerManager(coordinatorRegistryCenter, jobConfiguration, elasticJobListeners);
    }

    public void startAllListeners() {
        this.electionListenerManager.start();
        this.shardingListenerManager.start();
        this.executionListenerManager.start();
        this.failoverListenerManager.start();
        this.jobOperationListenerManager.start();
        this.configurationListenerManager.start();
        this.guaranteeListenerManager.start();
    }
}

