/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.election;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.internal.env.LocalHostService;
import com.dangdang.ddframe.job.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.internal.storage.LeaderExecutionCallback;
import com.dangdang.ddframe.job.internal.util.BlockUtils;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectionService {
    private static final Logger log = LoggerFactory.getLogger(LeaderElectionService.class);
    private final LocalHostService localHostService = new LocalHostService();
    private final JobNodeStorage jobNodeStorage;

    public LeaderElectionService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.jobNodeStorage = new JobNodeStorage(coordinatorRegistryCenter, jobConfiguration);
    }

    public void leaderElection() {
        this.jobNodeStorage.executeInLeader("leader/election/latch", new LeaderElectionExecutionCallback());
    }

    public Boolean isLeader() {
        String localHostIp = this.localHostService.getIp();
        while (!this.hasLeader()) {
            log.info("Elastic job: leader node is electing, waiting for 100 ms at server '{}'", (Object)localHostIp);
            BlockUtils.waitingShortTime();
        }
        return localHostIp.equals(this.jobNodeStorage.getJobNodeData("leader/election/host"));
    }

    public boolean hasLeader() {
        return this.jobNodeStorage.isJobNodeExisted("leader/election/host");
    }

    class LeaderElectionExecutionCallback
    implements LeaderExecutionCallback {
        LeaderElectionExecutionCallback() {
        }

        @Override
        public void execute() {
            if (!LeaderElectionService.this.jobNodeStorage.isJobNodeExisted("leader/election/host")) {
                LeaderElectionService.this.jobNodeStorage.fillEphemeralJobNode("leader/election/host", LeaderElectionService.this.localHostService.getIp());
            }
        }
    }
}

