/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.client.service;

import com.ctrip.framework.apollo.openapi.client.service.AbstractOpenApiService;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class ItemOpenApiService
extends AbstractOpenApiService {
    public ItemOpenApiService(CloseableHttpClient client, String baseUrl, Gson gson) {
        super(client, baseUrl, gson);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpenItemDTO createItem(String appId, String env, String clusterName, String namespaceName, OpenItemDTO itemDTO) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(itemDTO.getKey(), "Item key");
        this.checkNotEmpty(itemDTO.getValue(), "Item value");
        this.checkNotEmpty(itemDTO.getDataChangeCreatedBy(), "Item created by");
        String path = String.format("envs/%s/apps/%s/clusters/%s/namespaces/%s/items", this.escapePath(env), this.escapePath(appId), this.escapePath(clusterName), this.escapePath(namespaceName));
        try (CloseableHttpResponse response = this.post(path, itemDTO);){
            OpenItemDTO openItemDTO = (OpenItemDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenItemDTO.class);
            return openItemDTO;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Create item: %s for appId: %s, cluster: %s, namespace: %s in env: %s failed", itemDTO.getKey(), appId, clusterName, namespaceName, env), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateItem(String appId, String env, String clusterName, String namespaceName, OpenItemDTO itemDTO) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(itemDTO.getKey(), "Item key");
        this.checkNotEmpty(itemDTO.getValue(), "Item value");
        this.checkNotEmpty(itemDTO.getDataChangeLastModifiedBy(), "Item modified by");
        String path = String.format("envs/%s/apps/%s/clusters/%s/namespaces/%s/items/%s", this.escapePath(env), this.escapePath(appId), this.escapePath(clusterName), this.escapePath(namespaceName), this.escapePath(itemDTO.getKey()));
        try {
            CloseableHttpResponse ignored = this.put(path, itemDTO);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Update item: %s for appId: %s, cluster: %s, namespace: %s in env: %s failed", itemDTO.getKey(), appId, clusterName, namespaceName, env), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdateItem(String appId, String env, String clusterName, String namespaceName, OpenItemDTO itemDTO) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(itemDTO.getKey(), "Item key");
        this.checkNotEmpty(itemDTO.getValue(), "Item value");
        this.checkNotEmpty(itemDTO.getDataChangeCreatedBy(), "Item created by");
        if (Strings.isNullOrEmpty((String)itemDTO.getDataChangeLastModifiedBy())) {
            itemDTO.setDataChangeLastModifiedBy(itemDTO.getDataChangeCreatedBy());
        }
        String path = String.format("envs/%s/apps/%s/clusters/%s/namespaces/%s/items/%s?createIfNotExists=true", this.escapePath(env), this.escapePath(appId), this.escapePath(clusterName), this.escapePath(namespaceName), this.escapePath(itemDTO.getKey()));
        try {
            CloseableHttpResponse ignored = this.put(path, itemDTO);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("CreateOrUpdate item: %s for appId: %s, cluster: %s, namespace: %s in env: %s failed", itemDTO.getKey(), appId, clusterName, namespaceName, env), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(String appId, String env, String clusterName, String namespaceName, String key, String operator) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        if (Strings.isNullOrEmpty((String)namespaceName)) {
            namespaceName = "application";
        }
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(key, "Item key");
        this.checkNotEmpty(operator, "Operator");
        String path = String.format("envs/%s/apps/%s/clusters/%s/namespaces/%s/items/%s?operator=%s", this.escapePath(env), this.escapePath(appId), this.escapePath(clusterName), this.escapePath(namespaceName), this.escapePath(key), this.escapeParam(operator));
        try {
            CloseableHttpResponse ignored = this.delete(path);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Remove item: %s for appId: %s, cluster: %s, namespace: %s in env: %s failed", key, appId, clusterName, namespaceName, env), ex);
        }
    }
}

