/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.client;

import com.ctrip.framework.apollo.openapi.client.service.AppOpenApiService;
import com.ctrip.framework.apollo.openapi.client.service.ItemOpenApiService;
import com.ctrip.framework.apollo.openapi.client.service.NamespaceOpenApiService;
import com.ctrip.framework.apollo.openapi.client.service.ReleaseOpenApiService;
import com.ctrip.framework.apollo.openapi.dto.NamespaceReleaseDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenAppNamespaceDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenEnvClusterDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenNamespaceDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenNamespaceLockDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenReleaseDTO;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.List;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

public class ApolloOpenApiClient {
    private final String portalUrl;
    private final String token;
    private final AppOpenApiService appService;
    private final ItemOpenApiService itemService;
    private final ReleaseOpenApiService releaseService;
    private final NamespaceOpenApiService namespaceService;

    private ApolloOpenApiClient(String portalUrl, String token, RequestConfig requestConfig) {
        this.portalUrl = portalUrl;
        this.token = token;
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(requestConfig).setDefaultHeaders((Collection)Lists.newArrayList((Object[])new BasicHeader[]{new BasicHeader("Authorization", token)})).build();
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
        String baseUrl = this.portalUrl + "/openapi/v1";
        this.appService = new AppOpenApiService(client, baseUrl, gson);
        this.namespaceService = new NamespaceOpenApiService(client, baseUrl, gson);
        this.itemService = new ItemOpenApiService(client, baseUrl, gson);
        this.releaseService = new ReleaseOpenApiService(client, baseUrl, gson);
    }

    public List<OpenEnvClusterDTO> getEnvClusterInfo(String appId) {
        return this.appService.getEnvClusterInfo(appId);
    }

    public List<OpenNamespaceDTO> getNamespaces(String appId, String env, String clusterName) {
        return this.namespaceService.getNamespaces(appId, env, clusterName);
    }

    public OpenNamespaceDTO getNamespace(String appId, String env, String clusterName, String namespaceName) {
        return this.namespaceService.getNamespace(appId, env, clusterName, namespaceName);
    }

    public OpenAppNamespaceDTO createAppNamespace(OpenAppNamespaceDTO appNamespaceDTO) {
        return this.namespaceService.createAppNamespace(appNamespaceDTO);
    }

    public OpenNamespaceLockDTO getNamespaceLock(String appId, String env, String clusterName, String namespaceName) {
        return this.namespaceService.getNamespaceLock(appId, env, clusterName, namespaceName);
    }

    public OpenItemDTO createItem(String appId, String env, String clusterName, String namespaceName, OpenItemDTO itemDTO) {
        return this.itemService.createItem(appId, env, clusterName, namespaceName, itemDTO);
    }

    public void updateItem(String appId, String env, String clusterName, String namespaceName, OpenItemDTO itemDTO) {
        this.itemService.updateItem(appId, env, clusterName, namespaceName, itemDTO);
    }

    public void createOrUpdateItem(String appId, String env, String clusterName, String namespaceName, OpenItemDTO itemDTO) {
        this.itemService.createOrUpdateItem(appId, env, clusterName, namespaceName, itemDTO);
    }

    public void removeItem(String appId, String env, String clusterName, String namespaceName, String key, String operator) {
        this.itemService.removeItem(appId, env, clusterName, namespaceName, key, operator);
    }

    public OpenReleaseDTO publishNamespace(String appId, String env, String clusterName, String namespaceName, NamespaceReleaseDTO releaseDTO) {
        return this.releaseService.publishNamespace(appId, env, clusterName, namespaceName, releaseDTO);
    }

    public OpenReleaseDTO getLatestActiveRelease(String appId, String env, String clusterName, String namespaceName) {
        return this.releaseService.getLatestActiveRelease(appId, env, clusterName, namespaceName);
    }

    public String getPortalUrl() {
        return this.portalUrl;
    }

    public String getToken() {
        return this.token;
    }

    public static ApolloOpenApiClientBuilder newBuilder() {
        return new ApolloOpenApiClientBuilder();
    }

    public static class ApolloOpenApiClientBuilder {
        private String portalUrl;
        private String token;
        private int connectTimeout = -1;
        private int readTimeout = -1;

        public ApolloOpenApiClientBuilder withPortalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
            return this;
        }

        public ApolloOpenApiClientBuilder withToken(String token) {
            this.token = token;
            return this;
        }

        public ApolloOpenApiClientBuilder withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ApolloOpenApiClientBuilder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ApolloOpenApiClient build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.portalUrl) ? 1 : 0) != 0, (Object)"Portal url should not be null or empty!");
            Preconditions.checkArgument((this.portalUrl.startsWith("http://") || this.portalUrl.startsWith("https://") ? 1 : 0) != 0, (Object)"Portal url should start with http:// or https://");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.token) ? 1 : 0) != 0, (Object)"Token should not be null or empty!");
            if (this.connectTimeout < 0) {
                this.connectTimeout = 1000;
            }
            if (this.readTimeout < 0) {
                this.readTimeout = 5000;
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.readTimeout).build();
            return new ApolloOpenApiClient(this.portalUrl, this.token, requestConfig);
        }
    }
}

