/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.annotation;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.ctrip.framework.apollo.spring.annotation.ApolloJsonValue;
import com.ctrip.framework.apollo.spring.annotation.ApolloProcessor;
import com.ctrip.framework.apollo.spring.property.PlaceholderHelper;
import com.ctrip.framework.apollo.spring.property.SpringValue;
import com.ctrip.framework.apollo.spring.property.SpringValueRegistry;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

public class ApolloAnnotationProcessor
extends ApolloProcessor
implements BeanFactoryAware,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(ApolloAnnotationProcessor.class);
    private static final String NAMESPACE_DELIMITER = ",";
    private static final Splitter NAMESPACE_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private static final Map<String, Gson> DATEPATTERN_GSON_MAP = new ConcurrentHashMap<String, Gson>();
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private final PlaceholderHelper placeholderHelper = SpringInjector.getInstance(PlaceholderHelper.class);
    private final SpringValueRegistry springValueRegistry = SpringInjector.getInstance(SpringValueRegistry.class);
    private ConfigurableBeanFactory configurableBeanFactory;
    private Environment environment;

    @Override
    protected void processField(Object bean, String beanName, Field field) {
        this.processApolloConfig(bean, field);
        this.processApolloJsonValue(bean, beanName, field);
    }

    @Override
    protected void processMethod(Object bean, String beanName, Method method) {
        this.processApolloConfigChangeListener(bean, method);
        this.processApolloJsonValue(bean, beanName, method);
    }

    private void processApolloConfig(Object bean, Field field) {
        ApolloConfig annotation = (ApolloConfig)AnnotationUtils.getAnnotation((AnnotatedElement)field, ApolloConfig.class);
        if (annotation == null) {
            return;
        }
        Preconditions.checkArgument((boolean)Config.class.isAssignableFrom(field.getType()), (String)"Invalid type: %s for field: %s, should be Config", field.getType(), (Object)field);
        String namespace = annotation.value();
        String resolvedNamespace = this.environment.resolveRequiredPlaceholders(namespace);
        Config config = ConfigService.getConfig(resolvedNamespace);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)bean, (Object)config);
    }

    private void processApolloConfigChangeListener(Object bean, Method method) {
        ApolloConfigChangeListener annotation = (ApolloConfigChangeListener)AnnotationUtils.findAnnotation((Method)method, ApolloConfigChangeListener.class);
        if (annotation == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Preconditions.checkArgument((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"Invalid number of parameters: %s for method: %s, should be 1", (int)parameterTypes.length, (Object)method);
        Preconditions.checkArgument((boolean)ConfigChangeEvent.class.isAssignableFrom(parameterTypes[0]), (String)"Invalid parameter type: %s for method: %s, should be ConfigChangeEvent", parameterTypes[0], (Object)method);
        ReflectionUtils.makeAccessible((Method)method);
        String[] namespaces = annotation.value();
        Object[] annotatedInterestedKeys = annotation.interestedKeys();
        Object[] annotatedInterestedKeyPrefixes = annotation.interestedKeyPrefixes();
        ConfigChangeListener configChangeListener = changeEvent -> ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{changeEvent});
        HashSet interestedKeys = annotatedInterestedKeys.length > 0 ? Sets.newHashSet((Object[])annotatedInterestedKeys) : null;
        HashSet interestedKeyPrefixes = annotatedInterestedKeyPrefixes.length > 0 ? Sets.newHashSet((Object[])annotatedInterestedKeyPrefixes) : null;
        Set<String> resolvedNamespaces = this.processResolveNamespaceValue(namespaces);
        for (String namespace : resolvedNamespaces) {
            Config config = ConfigService.getConfig(namespace);
            if (interestedKeys == null && interestedKeyPrefixes == null) {
                config.addChangeListener(configChangeListener);
                continue;
            }
            config.addChangeListener(configChangeListener, interestedKeys, interestedKeyPrefixes);
        }
    }

    private Set<String> processResolveNamespaceValue(String[] namespaces) {
        HashSet<String> resolvedNamespaces = new HashSet<String>();
        for (String namespace : namespaces) {
            String resolvedNamespace = this.environment.resolveRequiredPlaceholders(namespace);
            if (resolvedNamespace.contains(NAMESPACE_DELIMITER)) {
                resolvedNamespaces.addAll(NAMESPACE_SPLITTER.splitToList((CharSequence)resolvedNamespace));
                continue;
            }
            resolvedNamespaces.add(resolvedNamespace);
        }
        return resolvedNamespaces;
    }

    private void processApolloJsonValue(Object bean, String beanName, Field field) {
        ApolloJsonValue apolloJsonValue = (ApolloJsonValue)AnnotationUtils.getAnnotation((AnnotatedElement)field, ApolloJsonValue.class);
        if (apolloJsonValue == null) {
            return;
        }
        String placeholder = apolloJsonValue.value();
        String datePattern = apolloJsonValue.datePattern();
        Object propertyValue = this.resolvePropertyValue(beanName, placeholder);
        if (propertyValue == null) {
            return;
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        ReflectionUtils.setField((Field)field, (Object)bean, (Object)this.parseJsonValue((String)propertyValue, field.getGenericType(), datePattern));
        field.setAccessible(accessible);
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(placeholder);
            for (String key : keys) {
                SpringValue springValue = new SpringValue(key, placeholder, bean, beanName, field, true);
                this.springValueRegistry.register((BeanFactory)this.configurableBeanFactory, key, springValue);
                logger.debug("Monitoring {}", (Object)springValue);
            }
        }
    }

    private void processApolloJsonValue(Object bean, String beanName, Method method) {
        ApolloJsonValue apolloJsonValue = (ApolloJsonValue)AnnotationUtils.getAnnotation((Method)method, ApolloJsonValue.class);
        if (apolloJsonValue == null) {
            return;
        }
        String placeHolder = apolloJsonValue.value();
        String datePattern = apolloJsonValue.datePattern();
        Object propertyValue = this.resolvePropertyValue(beanName, placeHolder);
        if (propertyValue == null) {
            return;
        }
        Type[] types = method.getGenericParameterTypes();
        Preconditions.checkArgument((types.length == 1 ? 1 : 0) != 0, (String)"Ignore @ApolloJsonValue setter {}.{}, expecting 1 parameter, actual {} parameters", (Object)bean.getClass().getName(), (Object)method.getName(), (Object)method.getParameterTypes().length);
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{this.parseJsonValue((String)propertyValue, types[0], datePattern)});
        method.setAccessible(accessible);
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(placeHolder);
            for (String key : keys) {
                SpringValue springValue = new SpringValue(key, placeHolder, bean, beanName, method, true);
                this.springValueRegistry.register((BeanFactory)this.configurableBeanFactory, key, springValue);
                logger.debug("Monitoring {}", (Object)springValue);
            }
        }
    }

    @Nullable
    private Object resolvePropertyValue(String beanName, String placeHolder) {
        Object propertyValue = this.placeholderHelper.resolvePropertyValue(this.configurableBeanFactory, beanName, placeHolder);
        if (!(propertyValue instanceof String)) {
            return null;
        }
        return propertyValue;
    }

    private Object parseJsonValue(String json, Type targetType, String datePattern) {
        try {
            return DATEPATTERN_GSON_MAP.computeIfAbsent(datePattern, this::buildGson).fromJson(json, targetType);
        }
        catch (Throwable ex) {
            logger.error("Parsing json '{}' to type {} failed!", new Object[]{json, targetType, ex});
            throw ex;
        }
    }

    private Gson buildGson(String datePattern) {
        if (StringUtils.isBlank((String)datePattern)) {
            return new Gson();
        }
        return new GsonBuilder().setDateFormat(datePattern).create();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

