/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.cli;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.cli.config.ClickHouseCommandLineOption;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseExternalTable;
import com.clickhouse.data.ClickHouseFile;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;

public class ClickHouseCommandLine
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseCommandLine.class);
    public static final String DEFAULT_CLI_ARG_VERSION = "--version";
    public static final String DEFAULT_CLICKHOUSE_CLI_PATH = "clickhouse";
    public static final String DEFAULT_CLIENT_OPTION = "client";
    public static final String DEFAULT_LOCAL_OPTION = "local";
    public static final String DEFAULT_DOCKER_CLI_PATH = "docker";
    public static final String DEFAULT_DOCKER_IMAGE = "clickhouse/clickhouse-server";
    public static final boolean DEFAULT_CLI_IS_AVAILALBE;
    public static final boolean DEFAULT_DOCKER_IS_AVAILALBE;
    private static final Map<String, Boolean> cache;
    private final ClickHouseRequest<?> request;
    private String error;
    private final Process process;

    static String getCommandLine(ClickHouseConfig config, String option) {
        int timeout = config.getConnectionTimeout();
        String cli = config.getStrOption(ClickHouseCommandLineOption.CLICKHOUSE_CLI_PATH);
        if (ClickHouseChecker.isNullOrBlank(cli)) {
            cli = DEFAULT_CLI_IS_AVAILALBE ? DEFAULT_CLICKHOUSE_CLI_PATH : null;
        } else if (!ClickHouseCommandLine.check(timeout, cli, option, DEFAULT_CLI_ARG_VERSION)) {
            cli = null;
        }
        if (cli == null) {
            cli = config.getStrOption(ClickHouseCommandLineOption.DOCKER_CLI_PATH);
            if (ClickHouseChecker.isNullOrBlank(cli)) {
                cli = DEFAULT_DOCKER_IS_AVAILALBE ? DEFAULT_DOCKER_CLI_PATH : null;
            } else if (!ClickHouseCommandLine.check(timeout, cli, option, DEFAULT_CLI_ARG_VERSION)) {
                cli = null;
            }
        }
        return cli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean check(int timeout, String command, String ... args) {
        if (ClickHouseChecker.isNullOrBlank(command) || args == null) {
            throw new IllegalArgumentException("Non-blank command and non-null arguments are required");
        }
        StringBuilder builder = new StringBuilder(command);
        for (String str : args) {
            builder.append(' ').append(str);
        }
        String commandLine = builder.toString();
        Boolean value = cache.get(commandLine);
        if (value == null) {
            value = Boolean.FALSE;
            ArrayList<String> list = new ArrayList<String>(args.length + 1);
            list.add(command);
            Collections.addAll(list, args);
            Process process = null;
            try {
                process = new ProcessBuilder(list).start();
                process.getOutputStream().close();
                if (process.waitFor(timeout, TimeUnit.MILLISECONDS)) {
                    int exitValue = process.exitValue();
                    if (exitValue != 0) {
                        log.trace((Object)"Command %s exited with value %d", list, exitValue);
                    }
                    value = exitValue == 0;
                } else {
                    log.trace((Object)"Timed out after waiting %d ms for command %s to complete", timeout, list);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.trace((Object)"Failed to check command %s due to: %s", list, e.getMessage());
            }
            finally {
                if (process != null && process.isAlive()) {
                    process.destroyForcibly();
                }
                process = null;
            }
            if (value.booleanValue()) {
                cache.put(commandLine, value);
            }
        }
        return Boolean.TRUE.equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void dockerCommand(ClickHouseConfig config, String hostDir, String containerDir, int timeout, List<String> commands) {
        String str;
        String cli = config.getStrOption(ClickHouseCommandLineOption.DOCKER_CLI_PATH);
        boolean useDocker = false;
        if (ClickHouseChecker.isNullOrBlank(cli)) {
            if (DEFAULT_DOCKER_IS_AVAILALBE) {
                cli = DEFAULT_DOCKER_CLI_PATH;
                useDocker = true;
            }
        } else if (ClickHouseCommandLine.check(timeout, cli, DEFAULT_CLI_ARG_VERSION)) {
            useDocker = true;
        }
        if (!useDocker) throw new UncheckedIOException(new ConnectException("Docker command-line is not available: " + cli));
        commands.add(cli);
        String img = config.getStrOption(ClickHouseCommandLineOption.CLICKHOUSE_DOCKER_IMAGE);
        if (ClickHouseChecker.isNullOrBlank(img)) {
            img = DEFAULT_DOCKER_IMAGE;
        }
        if (!ClickHouseChecker.isNullOrBlank(str = config.getStrOption(ClickHouseCommandLineOption.CLI_CONTAINER_ID))) {
            if (!ClickHouseCommandLine.check(timeout, cli, "exec", str, DEFAULT_CLICKHOUSE_CLI_PATH, DEFAULT_CLIENT_OPTION, DEFAULT_CLI_ARG_VERSION)) {
                Class<ClickHouseCommandLine> clazz = ClickHouseCommandLine.class;
                // MONITORENTER : com.clickhouse.client.cli.ClickHouseCommandLine.class
                if (!ClickHouseCommandLine.check(timeout, cli, "exec", str, DEFAULT_CLICKHOUSE_CLI_PATH, DEFAULT_CLIENT_OPTION, DEFAULT_CLI_ARG_VERSION) && !ClickHouseCommandLine.check(timeout, cli, "run", "--rm", "--name", str, "-v", hostDir + ':' + containerDir, "-d", img, "tail", "-f", "/dev/null")) {
                    throw new UncheckedIOException(new ConnectException("Failed to start new container: " + str));
                }
                // MONITOREXIT : clazz
            }
            commands.add("exec");
            commands.add("-i");
            commands.add(str);
        } else {
            if (!ClickHouseCommandLine.check(timeout, cli, "run", "--rm", img, DEFAULT_CLICKHOUSE_CLI_PATH, DEFAULT_CLIENT_OPTION, DEFAULT_CLI_ARG_VERSION)) {
                throw new UncheckedIOException(new ConnectException("Invalid ClickHouse docker image: " + img));
            }
            commands.add("run");
            commands.add("--rm");
            commands.add("-i");
            commands.add("-v");
            commands.add(hostDir + ':' + containerDir);
            commands.add(img);
        }
        commands.add(DEFAULT_CLICKHOUSE_CLI_PATH);
    }

    static Process startProcess(ClickHouseRequest<?> request) {
        ClickHouseOutputStream chOutput;
        Path p;
        long maxRows;
        LinkedList<String> commands;
        String containerDir;
        String hostDir;
        int timeout;
        ClickHouseNode server;
        ClickHouseConfig config;
        block45: {
            block44: {
                config = request.getConfig();
                server = request.getServer();
                timeout = config.getSocketTimeout();
                hostDir = config.getStrOption(ClickHouseCommandLineOption.CLI_WORK_DIRECTORY);
                hostDir = ClickHouseUtils.normalizeDirectory(ClickHouseChecker.isNullOrBlank(hostDir) ? System.getProperty("java.io.tmpdir") : hostDir);
                containerDir = config.getStrOption(ClickHouseCommandLineOption.CLI_CONTAINER_DIRECTORY);
                containerDir = ClickHouseChecker.isNullOrBlank(containerDir) ? "/tmp/" : ClickHouseUtils.normalizeDirectory(containerDir);
                commands = new LinkedList<String>();
                String cli = config.getStrOption(ClickHouseCommandLineOption.CLICKHOUSE_CLI_PATH);
                boolean useCli = false;
                if (ClickHouseChecker.isNullOrBlank(cli)) {
                    if (DEFAULT_CLI_IS_AVAILALBE) {
                        cli = DEFAULT_CLICKHOUSE_CLI_PATH;
                        useCli = true;
                    }
                } else if (ClickHouseCommandLine.check(timeout, cli, DEFAULT_CLIENT_OPTION, DEFAULT_CLI_ARG_VERSION)) {
                    useCli = true;
                }
                if (useCli) {
                    commands.add(cli);
                    containerDir = hostDir;
                } else {
                    ClickHouseCommandLine.dockerCommand(config, hostDir, containerDir, timeout, commands);
                }
                commands.add(DEFAULT_CLIENT_OPTION);
                if (config.isSsl()) {
                    commands.add("--secure");
                    if (config.getSslMode() == ClickHouseSslMode.NONE) {
                        commands.add("--accept-invalid-certificate");
                    }
                }
                if (!config.isResponseCompressed()) break block44;
                commands.add("--compression=1");
                switch (config.getResponseCompressAlgorithm()) {
                    case LZ4: {
                        commands.add("--network_compression_method=lz4");
                        break;
                    }
                    case ZSTD: {
                        commands.add("--network_compression_method=zstd");
                        if (config.getResponseCompressLevel() >= 0 && config.getResponseCompressLevel() <= 22) {
                            commands.add("----network_zstd_compression_level=" + config.getResponseCompressLevel());
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block45;
            }
            commands.add("--compression=0");
        }
        commands.add("--host=".concat(server.getHost()));
        commands.add("--port=".concat(Integer.toString(server.getPort())));
        String str = server.getDatabase(config);
        if (!ClickHouseChecker.isNullOrBlank(str)) {
            commands.add("--database=".concat(str));
        }
        str = config.getStrOption(ClickHouseCommandLineOption.CLI_CONFIG_FILE);
        if (config.getBoolOption(ClickHouseCommandLineOption.USE_CLI_CONFIG) && !ClickHouseChecker.isNullOrBlank(str) && Files.exists(Paths.get(str, new String[0]), new LinkOption[0])) {
            commands.add("--config-file=".concat(str));
        } else {
            ClickHouseCredentials credentials = server.getCredentials(config);
            str = credentials.getUserName();
            if (!ClickHouseChecker.isNullOrBlank(str)) {
                commands.add("--user=".concat(str));
            }
            if (!ClickHouseChecker.isNullOrBlank(str = credentials.getPassword())) {
                commands.add("--password=".concat(str));
            }
        }
        commands.add("--format=".concat(config.getFormat().name()));
        str = request.getQueryId().orElse("");
        if (!ClickHouseChecker.isNullOrBlank(str)) {
            commands.add("--query_id=".concat(str));
        }
        str = request.getStatements(false).get(0);
        commands.add("--query=".concat(str));
        for (ClickHouseExternalTable table : request.getExternalTables()) {
            String filePath;
            ClickHouseFile tableFile = ClickHouseFile.of(table.getContent(), table.getCompression(), table.getCompressionLevel(), table.getFormat());
            commands.add("--external");
            if (!tableFile.hasOutput() || !tableFile.getFile().getAbsolutePath().startsWith(hostDir)) {
                File f = ClickHouseInputStream.save(Paths.get(hostDir, "chc_".concat(request.getManager().createUniqueId())).toFile(), table.getContent(), config.getWriteBufferSize(), config.getSocketTimeout(), true);
                filePath = containerDir.concat(f.getName());
            } else {
                filePath = tableFile.getFile().getAbsolutePath();
                if (!hostDir.equals(containerDir)) {
                    filePath = Paths.get(containerDir, filePath.substring(hostDir.length())).toFile().getAbsolutePath();
                }
            }
            commands.add("--file=" + filePath);
            if (!ClickHouseChecker.isNullOrEmpty(table.getName())) {
                commands.add("--name=".concat(table.getName()));
            }
            if (table.getFormat() != null) {
                commands.add("--format=".concat(table.getFormat().name()));
            }
            commands.add("--structure=".concat(table.getStructure()));
        }
        Map<String, Serializable> settings = request.getSettings();
        Serializable value = settings.get("max_result_rows");
        if (value instanceof Number && (maxRows = ((Number)value).longValue()) > 0L) {
            commands.add("--limit=".concat(Long.toString(maxRows)));
        }
        if ((value = settings.get("result_overflow_mode")) != null) {
            commands.add("--result_overflow_mode=".concat(value.toString()));
        }
        if ((value = settings.get("readonly")) != null) {
            commands.add("--readonly=".concat(value.toString()));
        }
        if (config.getBoolOption(ClickHouseCommandLineOption.USE_PROFILE_EVENTS)) {
            commands.add("--print-profile-events");
            commands.add("--profile-events-delay-ms=-1");
        }
        log.debug((Object)"Query: %s", str);
        ProcessBuilder builder = new ProcessBuilder(commands);
        String workDirectory = config.getStrOption(ClickHouseCommandLineOption.CLI_WORK_DIRECTORY);
        if (!ClickHouseChecker.isNullOrBlank(workDirectory) && Files.isDirectory(p = Paths.get(workDirectory, new String[0]), new LinkOption[0])) {
            builder.directory(p.toFile());
        }
        if (request.hasOutputStream() && (chOutput = request.getOutputStream().get()).hasUnderlyingStream()) {
            File f;
            ClickHousePassThruStream customStream = chOutput.getUnderlyingStream();
            File file = f = customStream instanceof ClickHouseFile ? ((ClickHouseFile)customStream).getFile() : null;
            if (f == null) {
                throw new UncheckedIOException(new IOException("Output file not found in " + customStream));
            }
            if (!hostDir.equals(containerDir)) {
                if (f.getAbsolutePath().startsWith(hostDir)) {
                    String relativePath = f.getAbsolutePath().substring(hostDir.length());
                    builder.redirectOutput(new File(containerDir.concat(relativePath)));
                } else {
                    String fileName = f.getName();
                    int len = fileName.length();
                    int index = fileName.indexOf(46, 1);
                    String uuid = request.getManager().createUniqueId();
                    fileName = index > 0 && index + 1 < len ? new StringBuilder(len + uuid.length() + 1).append(fileName.substring(0, index)).append('_').append(uuid).append(fileName.substring(index)).toString() : new StringBuilder(len + uuid.length() + 1).append(fileName).append('_').append(request.getManager().createUniqueId()).toString();
                    Path newPath = Paths.get(hostDir, fileName);
                    try {
                        f = Files.createLink(newPath, f.toPath()).toFile();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    catch (UnsupportedOperationException e) {
                        try {
                            f = ClickHouseInputStream.save(newPath.toFile(), new FileInputStream(f), config.getWriteBufferSize(), timeout, true);
                        }
                        catch (FileNotFoundException exp) {
                            throw new UncheckedIOException(exp);
                        }
                    }
                }
            }
            builder.redirectOutput(f);
        }
        Optional<ClickHouseInputStream> in = request.getInputStream();
        try {
            Process process;
            if (in.isPresent()) {
                ClickHousePassThruStream customStream;
                ClickHouseInputStream chInput = in.get();
                File inputFile = chInput.hasUnderlyingStream() ? ((customStream = chInput.getUnderlyingStream()) instanceof ClickHouseFile ? ((ClickHouseFile)customStream).getFile() : ClickHouseFile.of(customStream.getInputStream(), config.getRequestCompressAlgorithm(), config.getRequestCompressLevel(), config.getFormat()).getFile()) : ClickHouseFile.of(chInput, config.getRequestCompressAlgorithm(), config.getRequestCompressLevel(), config.getFormat()).getFile();
                process = builder.redirectInput(inputFile).start();
            } else {
                process = builder.start();
                process.getOutputStream().close();
            }
            return process;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ClickHouseCommandLine(ClickHouseRequest<?> request) {
        this.request = request;
        this.error = null;
        this.process = ClickHouseCommandLine.startProcess(request);
    }

    public ClickHouseInputStream getInputStream() throws IOException {
        ClickHouseConfig c = this.request.getConfig();
        ClickHouseOutputStream out = this.request.getOutputStream().orElse(null);
        Runnable postCloseAction = () -> {
            IOException exp = this.getError();
            if (exp != null) {
                throw new UncheckedIOException(exp);
            }
        };
        if (out != null && !out.hasUnderlyingStream()) {
            try (ClickHouseOutputStream o = out;){
                ClickHouseInputStream.pipe(this.process.getInputStream(), (OutputStream)o, c.getWriteBufferSize());
            }
            return ClickHouseInputStream.wrap(null, ClickHouseInputStream.empty(), c.getReadBufferSize(), ClickHouseCompression.NONE, -1, postCloseAction);
        }
        return ClickHouseInputStream.of(this.process.getInputStream(), c.getReadBufferSize(), postCloseAction);
    }

    IOException getError() {
        if (this.error == null) {
            int bufferSize = (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue();
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(bufferSize);){
                ClickHouseInputStream.pipe(this.process.getErrorStream(), (OutputStream)output, bufferSize);
                this.error = new String(output.toByteArray(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.error = "";
            }
            try {
                int exitValue = this.process.waitFor();
                if (exitValue != 0) {
                    int index;
                    this.error = this.error.isEmpty() ? ClickHouseUtils.format("Command exited with value %d", exitValue) : ((index = this.error.trim().indexOf(10)) > 0 ? this.error.substring(index + 1) : this.error);
                } else {
                    if (!this.error.isEmpty()) {
                        log.trace(() -> {
                            for (String line : this.error.split("\n")) {
                                log.trace((Object)line, new Object[0]);
                            }
                            return "";
                        });
                    }
                    this.error = "";
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.process.destroyForcibly();
                throw new CompletionException(e);
            }
        }
        return !ClickHouseChecker.isNullOrBlank(this.error) ? new IOException(this.error) : null;
    }

    @Override
    public void close() {
        if (this.process.isAlive()) {
            this.process.destroyForcibly();
        }
    }

    static {
        cache = Collections.synchronizedMap(new WeakHashMap(8));
        String option = DEFAULT_CLIENT_OPTION;
        int timeout = (Integer)ClickHouseClientOption.CONNECTION_TIMEOUT.getEffectiveDefaultValue();
        DEFAULT_CLI_IS_AVAILALBE = ClickHouseCommandLine.check(timeout, DEFAULT_CLICKHOUSE_CLI_PATH, option, DEFAULT_CLI_ARG_VERSION);
        DEFAULT_DOCKER_IS_AVAILALBE = ClickHouseCommandLine.check(timeout, DEFAULT_DOCKER_CLI_PATH, option, DEFAULT_CLI_ARG_VERSION);
    }
}

