/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.okhttp;

import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.google.common.io.BaseEncoding;
import com.clickhouse.client.internal.grpc.Attributes;
import com.clickhouse.client.internal.grpc.CallOptions;
import com.clickhouse.client.internal.grpc.Metadata;
import com.clickhouse.client.internal.grpc.MethodDescriptor;
import com.clickhouse.client.internal.grpc.Status;
import com.clickhouse.client.internal.grpc.internal.AbstractClientStream;
import com.clickhouse.client.internal.grpc.internal.ClientStreamListener;
import com.clickhouse.client.internal.grpc.internal.Http2ClientStreamTransportState;
import com.clickhouse.client.internal.grpc.internal.StatsTraceContext;
import com.clickhouse.client.internal.grpc.internal.TransportTracer;
import com.clickhouse.client.internal.grpc.internal.WritableBuffer;
import com.clickhouse.client.internal.grpc.okhttp.ExceptionHandlingFrameWriter;
import com.clickhouse.client.internal.grpc.okhttp.Headers;
import com.clickhouse.client.internal.grpc.okhttp.OkHttpClientTransport;
import com.clickhouse.client.internal.grpc.okhttp.OkHttpReadableBuffer;
import com.clickhouse.client.internal.grpc.okhttp.OkHttpWritableBuffer;
import com.clickhouse.client.internal.grpc.okhttp.OkHttpWritableBufferAllocator;
import com.clickhouse.client.internal.grpc.okhttp.OutboundFlowController;
import com.clickhouse.client.internal.grpc.okhttp.Utils;
import com.clickhouse.client.internal.grpc.okhttp.internal.framed.ErrorCode;
import com.clickhouse.client.internal.grpc.okhttp.internal.framed.Header;
import com.clickhouse.client.internal.okio.Buffer;
import com.clickhouse.client.internal.perfmark.PerfMark;
import com.clickhouse.client.internal.perfmark.Tag;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

class OkHttpClientStream
extends AbstractClientStream {
    private static final Buffer EMPTY_BUFFER = new Buffer();
    public static final int ABSENT_ID = -1;
    private final MethodDescriptor<?, ?> method;
    private final String userAgent;
    private final StatsTraceContext statsTraceCtx;
    private String authority;
    private Object outboundFlowState;
    private volatile int id = -1;
    private final TransportState state;
    private final Sink sink = new Sink();
    private final Attributes attributes;
    private boolean useGet = false;

    OkHttpClientStream(MethodDescriptor<?, ?> method, Metadata headers, ExceptionHandlingFrameWriter frameWriter, OkHttpClientTransport transport, OutboundFlowController outboundFlow, Object lock, int maxMessageSize, int initialWindowSize, String authority, String userAgent, StatsTraceContext statsTraceCtx, TransportTracer transportTracer, CallOptions callOptions, boolean useGetForSafeMethods) {
        super(new OkHttpWritableBufferAllocator(), statsTraceCtx, transportTracer, headers, callOptions, useGetForSafeMethods && method.isSafe());
        this.statsTraceCtx = Preconditions.checkNotNull(statsTraceCtx, "statsTraceCtx");
        this.method = method;
        this.authority = authority;
        this.userAgent = userAgent;
        this.attributes = transport.getAttributes();
        this.state = new TransportState(maxMessageSize, statsTraceCtx, lock, frameWriter, outboundFlow, transport, initialWindowSize, method.getFullMethodName());
    }

    @Override
    protected TransportState transportState() {
        return this.state;
    }

    @Override
    protected Sink abstractClientStreamSink() {
        return this.sink;
    }

    public MethodDescriptor.MethodType getType() {
        return this.method.getType();
    }

    public int id() {
        return this.id;
    }

    boolean useGet() {
        return this.useGet;
    }

    @Override
    public void setAuthority(String authority) {
        this.authority = Preconditions.checkNotNull(authority, "authority");
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    void setOutboundFlowState(Object outboundFlowState) {
        this.outboundFlowState = outboundFlowState;
    }

    Object getOutboundFlowState() {
        return this.outboundFlowState;
    }

    class TransportState
    extends Http2ClientStreamTransportState {
        private final int initialWindowSize;
        private final Object lock;
        @GuardedBy(value="lock")
        private List<Header> requestHeaders;
        @GuardedBy(value="lock")
        private Buffer pendingData;
        private boolean pendingDataHasEndOfStream;
        private boolean flushPendingData;
        @GuardedBy(value="lock")
        private boolean cancelSent;
        @GuardedBy(value="lock")
        private int window;
        @GuardedBy(value="lock")
        private int processedWindow;
        @GuardedBy(value="lock")
        private final ExceptionHandlingFrameWriter frameWriter;
        @GuardedBy(value="lock")
        private final OutboundFlowController outboundFlow;
        @GuardedBy(value="lock")
        private final OkHttpClientTransport transport;
        @GuardedBy(value="lock")
        private boolean canStart;
        private final Tag tag;

        public TransportState(int maxMessageSize, StatsTraceContext statsTraceCtx, Object lock, ExceptionHandlingFrameWriter frameWriter, OutboundFlowController outboundFlow, OkHttpClientTransport transport, int initialWindowSize, String methodName) {
            super(maxMessageSize, statsTraceCtx, OkHttpClientStream.this.getTransportTracer());
            this.pendingData = new Buffer();
            this.pendingDataHasEndOfStream = false;
            this.flushPendingData = false;
            this.cancelSent = false;
            this.canStart = true;
            this.lock = Preconditions.checkNotNull(lock, "lock");
            this.frameWriter = frameWriter;
            this.outboundFlow = outboundFlow;
            this.transport = transport;
            this.window = initialWindowSize;
            this.processedWindow = initialWindowSize;
            this.initialWindowSize = initialWindowSize;
            this.tag = PerfMark.createTag(methodName);
        }

        @GuardedBy(value="lock")
        public void start(int streamId) {
            Preconditions.checkState(OkHttpClientStream.this.id == -1, "the stream has been started with id %s", streamId);
            OkHttpClientStream.this.id = streamId;
            OkHttpClientStream.this.state.onStreamAllocated();
            if (this.canStart) {
                this.frameWriter.synStream(OkHttpClientStream.this.useGet, false, OkHttpClientStream.this.id, 0, this.requestHeaders);
                OkHttpClientStream.this.statsTraceCtx.clientOutboundHeaders();
                this.requestHeaders = null;
                if (this.pendingData.size() > 0L) {
                    this.outboundFlow.data(this.pendingDataHasEndOfStream, OkHttpClientStream.this.id, this.pendingData, this.flushPendingData);
                }
                this.canStart = false;
            }
        }

        @Override
        @GuardedBy(value="lock")
        protected void onStreamAllocated() {
            super.onStreamAllocated();
            this.getTransportTracer().reportLocalStreamStarted();
        }

        @Override
        @GuardedBy(value="lock")
        protected void http2ProcessingFailed(Status status, boolean stopDelivery, Metadata trailers) {
            this.cancel(status, stopDelivery, trailers);
        }

        @Override
        @GuardedBy(value="lock")
        public void deframeFailed(Throwable cause) {
            this.http2ProcessingFailed(Status.fromThrowable(cause), true, new Metadata());
        }

        @Override
        @GuardedBy(value="lock")
        public void bytesRead(int processedBytes) {
            this.processedWindow -= processedBytes;
            if ((float)this.processedWindow <= (float)this.initialWindowSize * 0.5f) {
                int delta = this.initialWindowSize - this.processedWindow;
                this.window += delta;
                this.processedWindow += delta;
                this.frameWriter.windowUpdate(OkHttpClientStream.this.id(), delta);
            }
        }

        @Override
        @GuardedBy(value="lock")
        public void deframerClosed(boolean hasPartialMessage) {
            this.onEndOfStream();
            super.deframerClosed(hasPartialMessage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @GuardedBy(value="lock")
        public void runOnTransportThread(Runnable r) {
            Object object = this.lock;
            synchronized (object) {
                r.run();
            }
        }

        @GuardedBy(value="lock")
        public void transportHeadersReceived(List<Header> headers, boolean endOfStream) {
            if (endOfStream) {
                this.transportTrailersReceived(Utils.convertTrailers(headers));
            } else {
                this.transportHeadersReceived(Utils.convertHeaders(headers));
            }
        }

        @GuardedBy(value="lock")
        public void transportDataReceived(Buffer frame, boolean endOfStream) {
            int length = (int)frame.size();
            this.window -= length;
            if (this.window < 0) {
                this.frameWriter.rstStream(OkHttpClientStream.this.id(), ErrorCode.FLOW_CONTROL_ERROR);
                this.transport.finishStream(OkHttpClientStream.this.id(), Status.INTERNAL.withDescription("Received data size exceeded our receiving window size"), ClientStreamListener.RpcProgress.PROCESSED, false, null, null);
                return;
            }
            super.transportDataReceived(new OkHttpReadableBuffer(frame), endOfStream);
        }

        @GuardedBy(value="lock")
        private void onEndOfStream() {
            if (!this.isOutboundClosed()) {
                this.transport.finishStream(OkHttpClientStream.this.id(), null, ClientStreamListener.RpcProgress.PROCESSED, false, ErrorCode.CANCEL, null);
            } else {
                this.transport.finishStream(OkHttpClientStream.this.id(), null, ClientStreamListener.RpcProgress.PROCESSED, false, null, null);
            }
        }

        @GuardedBy(value="lock")
        private void cancel(Status reason, boolean stopDelivery, Metadata trailers) {
            if (this.cancelSent) {
                return;
            }
            this.cancelSent = true;
            if (this.canStart) {
                this.transport.removePendingStream(OkHttpClientStream.this);
                this.requestHeaders = null;
                this.pendingData.clear();
                this.canStart = false;
                this.transportReportStatus(reason, true, trailers != null ? trailers : new Metadata());
            } else {
                this.transport.finishStream(OkHttpClientStream.this.id(), reason, ClientStreamListener.RpcProgress.PROCESSED, stopDelivery, ErrorCode.CANCEL, trailers);
            }
        }

        @GuardedBy(value="lock")
        private void sendBuffer(Buffer buffer, boolean endOfStream, boolean flush) {
            if (this.cancelSent) {
                return;
            }
            if (this.canStart) {
                int dataSize = (int)buffer.size();
                this.pendingData.write(buffer, (long)dataSize);
                this.pendingDataHasEndOfStream |= endOfStream;
                this.flushPendingData |= flush;
            } else {
                Preconditions.checkState(OkHttpClientStream.this.id() != -1, "streamId should be set");
                this.outboundFlow.data(endOfStream, OkHttpClientStream.this.id(), buffer, flush);
            }
        }

        @GuardedBy(value="lock")
        private void streamReady(Metadata metadata, String path) {
            this.requestHeaders = Headers.createRequestHeaders(metadata, path, OkHttpClientStream.this.authority, OkHttpClientStream.this.userAgent, OkHttpClientStream.this.useGet, this.transport.isUsingPlaintext());
            this.transport.streamReadyToStart(OkHttpClientStream.this);
        }

        Tag tag() {
            return this.tag;
        }
    }

    class Sink
    implements AbstractClientStream.Sink {
        Sink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeHeaders(Metadata metadata, byte[] payload) {
            PerfMark.startTask("OkHttpClientStream$Sink.writeHeaders");
            String defaultPath = "/" + OkHttpClientStream.this.method.getFullMethodName();
            if (payload != null) {
                OkHttpClientStream.this.useGet = true;
                defaultPath = defaultPath + "?" + BaseEncoding.base64().encode(payload);
            }
            try {
                Object object = OkHttpClientStream.this.state.lock;
                synchronized (object) {
                    OkHttpClientStream.this.state.streamReady(metadata, defaultPath);
                }
            }
            finally {
                PerfMark.stopTask("OkHttpClientStream$Sink.writeHeaders");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeFrame(WritableBuffer frame, boolean endOfStream, boolean flush, int numMessages) {
            Buffer buffer;
            PerfMark.startTask("OkHttpClientStream$Sink.writeFrame");
            if (frame == null) {
                buffer = EMPTY_BUFFER;
            } else {
                buffer = ((OkHttpWritableBuffer)frame).buffer();
                int size = (int)buffer.size();
                if (size > 0) {
                    OkHttpClientStream.this.onSendingBytes(size);
                }
            }
            try {
                Object object = OkHttpClientStream.this.state.lock;
                synchronized (object) {
                    OkHttpClientStream.this.state.sendBuffer(buffer, endOfStream, flush);
                    OkHttpClientStream.this.getTransportTracer().reportMessageSent(numMessages);
                }
            }
            finally {
                PerfMark.stopTask("OkHttpClientStream$Sink.writeFrame");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(Status reason) {
            PerfMark.startTask("OkHttpClientStream$Sink.cancel");
            try {
                Object object = OkHttpClientStream.this.state.lock;
                synchronized (object) {
                    OkHttpClientStream.this.state.cancel(reason, true, null);
                }
            }
            finally {
                PerfMark.stopTask("OkHttpClientStream$Sink.cancel");
            }
        }
    }
}

