/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import com.ceilfors.enforcer.rules.EnforcerRuleUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugins.enforcer.AbstractStandardEnforcerRule;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequireDepMgt
extends AbstractStandardEnforcerRule {
    public boolean checkVersion;
    public List<String> ignoreArtifacts = Lists.newArrayList();
    public List<String> ignoreScopes = Lists.newArrayList((Object[])new String[]{"test"});
    public boolean ignoreNonManaged;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        String newLine = System.getProperty("line.separator");
        MavenProject project = EnforcerRuleUtils.getMavenProject(helper);
        DependencyManagement depMgt = project.getDependencyManagement();
        Map<Object, Object> depMgtMap = depMgt == null ? new HashMap() : this.getDependencyMap(depMgt.getDependencies());
        StringBuilder sb = new StringBuilder();
        List dependencies = project.getDependencies();
        for (Dependency dependency : dependencies) {
            if (this.ignoreScopes.contains(dependency.getScope()) || this.ignoreArtifacts.contains(dependency.getManagementKey())) continue;
            Dependency depMgtDependency = (Dependency)depMgtMap.get(dependency.getManagementKey());
            if (depMgtDependency == null && !this.ignoreNonManaged) {
                sb.append(String.format("%s is not managed by dependency management", dependency.getManagementKey()));
                sb.append(newLine);
                continue;
            }
            if (!this.checkVersion || depMgtDependency.getVersion() == null || depMgtDependency.getVersion().equals(dependency.getVersion())) continue;
            sb.append(String.format("%s version is with %s. Managed version is %s", dependency.getManagementKey(), dependency.getVersion(), depMgtDependency.getVersion()));
            sb.append(newLine);
        }
        if (sb.length() != 0) {
            throw new EnforcerRuleException(sb.toString() + (this.getMessage() == null ? "Please update the dependency management." : this.getMessage()));
        }
    }

    private Map<String, Dependency> getDependencyMap(List<Dependency> dependencies) {
        HashMap dependencyMap = Maps.newHashMap();
        for (Dependency dependency : dependencies) {
            dependencyMap.put(dependency.getManagementKey(), dependency);
        }
        return dependencyMap;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return String.valueOf(this.checkVersion ? 0 : 1);
    }
}

