/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import com.ceilfors.enforcer.rules.EnforcerRuleUtils;
import java.io.File;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractStandardEnforcerRule;
import org.apache.maven.project.MavenProject;

public class MatchGroupIdAndPackage
extends AbstractStandardEnforcerRule {
    public void execute(EnforcerRuleHelper enforcerRuleHelper) throws EnforcerRuleException {
        MavenProject project = EnforcerRuleUtils.getMavenProject(enforcerRuleHelper);
        String groupId = project.getGroupId();
        for (Object src : project.getCompileSourceRoots()) {
            File dir = new File(src + File.separator + groupId.replace('.', File.separatorChar));
            if (!dir.exists()) continue;
            return;
        }
        throw new EnforcerRuleException("No matching Java package for groupId [" + groupId + "]");
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "not-cached";
    }
}

