/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.InternalAssumptionViolatedException;
import com.carrotsearch.randomizedtesting.LifecycleScope;
import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.Rethrow;
import com.carrotsearch.randomizedtesting.TempPathResource;
import com.carrotsearch.randomizedtesting.generators.BiasedNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomBytes;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.junit.Assume;
import org.junit.runner.RunWith;

@RunWith(value=RandomizedRunner.class)
public class RandomizedTest {
    public static final String SYSPROP_MULTIPLIER = "randomized.multiplier";
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected static final Charset UTF16 = Charset.forName("UTF-16");
    protected static final Charset ISO8859_1 = Charset.forName("ISO-8859-1");
    protected static final Charset US_ASCII = Charset.forName("US-ASCII");
    protected static final Charset UTF32 = Charset.forName("UTF-32");
    private static final double DEFAULT_MULTIPLIER = 1.0;
    private static Path globalTempDir;
    private static int tempSubFileNameCount;
    private static final HashMap<String, Boolean> BOOLEANS;

    public static RandomizedContext getContext() {
        return RandomizedContext.current();
    }

    public static boolean isNightly() {
        return RandomizedTest.getContext().isNightly();
    }

    public static Random getRandom() {
        return RandomizedTest.getContext().getRandom();
    }

    public static boolean randomBoolean() {
        return RandomizedTest.getRandom().nextBoolean();
    }

    public static byte randomByte() {
        return (byte)RandomizedTest.getRandom().nextInt();
    }

    public static short randomShort() {
        return (short)RandomizedTest.getRandom().nextInt();
    }

    public static int randomInt() {
        return RandomizedTest.getRandom().nextInt();
    }

    public static float randomFloat() {
        return RandomizedTest.getRandom().nextFloat();
    }

    public static double randomDouble() {
        return RandomizedTest.getRandom().nextDouble();
    }

    public static long randomLong() {
        return RandomizedTest.getRandom().nextLong();
    }

    public static double randomGaussian() {
        return RandomizedTest.getRandom().nextGaussian();
    }

    public static float biasedFloatBetween(float min, float max) {
        return BiasedNumbers.randomFloatBetween(RandomizedTest.getRandom(), min, max);
    }

    public static double biasedDoubleBetween(double min, double max) {
        return BiasedNumbers.randomDoubleBetween(RandomizedTest.getRandom(), min, max);
    }

    public static byte[] randomBytesOfLength(int length) {
        return RandomBytes.randomBytesOfLength(new Random(RandomizedTest.getRandom().nextLong()), length);
    }

    public static byte[] randomBytesOfLength(int minLength, int maxLength) {
        return RandomBytes.randomBytesOfLengthBetween(new Random(RandomizedTest.getRandom().nextLong()), minLength, maxLength);
    }

    public static int randomInt(int max) {
        return RandomNumbers.randomIntBetween(RandomizedTest.getRandom(), 0, max);
    }

    public static long randomLong(long max) {
        return RandomNumbers.randomLongBetween(RandomizedTest.getRandom(), 0L, max);
    }

    public static int randomIntBetween(int min, int max) {
        return RandomNumbers.randomIntBetween(RandomizedTest.getRandom(), min, max);
    }

    public static int between(int min, int max) {
        return RandomizedTest.randomIntBetween(min, max);
    }

    public static long randomLongBetween(long min, long max) {
        return RandomNumbers.randomLongBetween(RandomizedTest.getRandom(), min, max);
    }

    public static long between(long min, long max) {
        return RandomizedTest.randomLongBetween(min, max);
    }

    public static int atLeast(int min) {
        if (min < 0) {
            throw new IllegalArgumentException("atLeast requires non-negative argument: " + min);
        }
        return RandomizedTest.scaledRandomIntBetween(min, Integer.MAX_VALUE);
    }

    public static int atMost(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("atMost requires non-negative argument: " + max);
        }
        return RandomizedTest.scaledRandomIntBetween(0, max);
    }

    public static boolean rarely() {
        return RandomizedTest.randomInt(100) >= 90;
    }

    public static boolean frequently() {
        return !RandomizedTest.rarely();
    }

    public static <T> T randomFrom(T[] array) {
        return RandomPicks.randomFrom(RandomizedTest.getRandom(), array);
    }

    public static <T> T randomFrom(List<T> list) {
        return RandomPicks.randomFrom(RandomizedTest.getRandom(), list);
    }

    public static double multiplier() {
        RandomizedTest.checkContext();
        return RandomizedTest.systemPropertyAsDouble(SYSPROP_MULTIPLIER, 1.0);
    }

    public static int iterations(int min, int max) {
        return RandomizedTest.scaledRandomIntBetween(min, max);
    }

    public static int scaledRandomIntBetween(int min, int max) {
        if (min < 0) {
            throw new IllegalArgumentException("min must be >= 0: " + min);
        }
        if (min > max) {
            throw new IllegalArgumentException("max must be >= min: " + min + ", " + max);
        }
        double point = Math.min(1.0, Math.abs(RandomizedTest.randomGaussian()) * 0.3) * RandomizedTest.multiplier();
        double range = max - min;
        int scaled = (int)Math.round(Math.min(point * range, range));
        if (RandomizedTest.isNightly()) {
            return max - scaled;
        }
        return min + scaled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path globalTempDir() throws IOException {
        RandomizedTest.checkContext();
        Class<RandomizedTest> clazz = RandomizedTest.class;
        synchronized (RandomizedTest.class) {
            if (globalTempDir == null) {
                String tempDirPath = System.getProperty("java.io.tmpdir");
                if (tempDirPath == null) {
                    throw new Error("No property java.io.tmpdir?");
                }
                Path tempDir = Paths.get(tempDirPath, new String[0]);
                if (!Files.isDirectory(tempDir, new LinkOption[0]) || !Files.isWritable(tempDir)) {
                    throw new Error("Temporary folder not accessible: " + tempDir.toAbsolutePath());
                }
                SimpleDateFormat tsFormat = new SimpleDateFormat("'tests-'yyyyMMddHHmmss'-'SSS", Locale.ROOT);
                String dirName = tsFormat.format(new Date());
                Path tmpFolder = tempDir.resolve(dirName);
                Files.createDirectories(tmpFolder, new FileAttribute[0]);
                globalTempDir = tmpFolder;
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            RandomizedTest.rmDir(globalTempDir);
                        }
                        catch (IOException e) {
                            System.err.println("Could not completely delete temporary folder: " + globalTempDir.toAbsolutePath() + ". Cause: ");
                            e.printStackTrace(System.err);
                        }
                    }
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return globalTempDir;
        }
    }

    public Path newTempDir() throws IOException {
        return RandomizedTest.newTempDir(LifecycleScope.TEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path newTempDir(LifecycleScope scope) throws IOException {
        RandomizedTest.checkContext();
        Class<RandomizedTest> clazz = RandomizedTest.class;
        synchronized (RandomizedTest.class) {
            Path tempDir = RandomizedTest.globalTempDir().resolve(RandomizedTest.nextTempName());
            Files.createDirectories(tempDir, new FileAttribute[0]);
            RandomizedTest.getContext().closeAtEnd(new TempPathResource(tempDir), scope);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tempDir;
        }
    }

    public <T extends Closeable> T closeAfterTest(T resource) {
        return RandomizedTest.getContext().closeAtEnd(resource, LifecycleScope.TEST);
    }

    public static <T extends Closeable> T closeAfterSuite(T resource) {
        return RandomizedTest.getContext().closeAtEnd(resource, LifecycleScope.SUITE);
    }

    public Path newTempFile() throws IOException {
        return RandomizedTest.newTempFile(LifecycleScope.TEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path newTempFile(LifecycleScope scope) throws IOException {
        RandomizedTest.checkContext();
        Class<RandomizedTest> clazz = RandomizedTest.class;
        synchronized (RandomizedTest.class) {
            Path tempFile = RandomizedTest.globalTempDir().resolve(RandomizedTest.nextTempName());
            Files.createFile(tempFile, new FileAttribute[0]);
            RandomizedTest.getContext().closeAtEnd(new TempPathResource(tempFile), scope);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tempFile;
        }
    }

    private static String nextTempName() {
        return String.format("%04d has-space", tempSubFileNameCount++);
    }

    public static void rmDir(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("Not a folder: " + path);
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException iterationError) throws IOException {
                    if (iterationError != null) {
                        throw iterationError;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                    throw e;
                }
            });
        }
        catch (IOException e) {
            throw new IOException("Could not remove directory: " + path, e);
        }
    }

    public static ServerSocket newServerSocket(LifecycleScope scope) throws IOException {
        final ServerSocket socket = new ServerSocket(0);
        RandomizedTest.getContext().closeAtEnd(new Closeable(){

            @Override
            public void close() throws IOException {
                if (!socket.isClosed()) {
                    socket.close();
                }
            }
        }, scope);
        return socket;
    }

    public static Locale randomLocale() {
        Locale[] availableLocales = Locale.getAvailableLocales();
        Arrays.sort(availableLocales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return RandomizedTest.randomFrom(availableLocales);
    }

    public static TimeZone randomTimeZone() {
        Object[] availableIDs = TimeZone.getAvailableIDs();
        Arrays.sort(availableIDs);
        return TimeZone.getTimeZone((String)RandomizedTest.randomFrom(availableIDs));
    }

    public static String randomAsciiOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomStrings.randomAsciiOfLengthBetween(RandomizedTest.getRandom(), minCodeUnits, maxCodeUnits);
    }

    public static String randomAsciiOfLength(int codeUnits) {
        return RandomStrings.randomAsciiOfLength(RandomizedTest.getRandom(), codeUnits);
    }

    public static String randomUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomStrings.randomUnicodeOfLengthBetween(RandomizedTest.getRandom(), minCodeUnits, maxCodeUnits);
    }

    public static String randomUnicodeOfLength(int codeUnits) {
        return RandomStrings.randomUnicodeOfLength(RandomizedTest.getRandom(), codeUnits);
    }

    public static String randomUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomStrings.randomUnicodeOfCodepointLengthBetween(RandomizedTest.getRandom(), minCodePoints, maxCodePoints);
    }

    public static String randomUnicodeOfCodepointLength(int codePoints) {
        return RandomStrings.randomUnicodeOfCodepointLength(RandomizedTest.getRandom(), codePoints);
    }

    public static String randomRealisticUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomStrings.randomRealisticUnicodeOfLengthBetween(RandomizedTest.getRandom(), minCodeUnits, maxCodeUnits);
    }

    public static String randomRealisticUnicodeOfLength(int codeUnits) {
        return RandomStrings.randomRealisticUnicodeOfLength(RandomizedTest.getRandom(), codeUnits);
    }

    public static String randomRealisticUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomStrings.randomRealisticUnicodeOfCodepointLengthBetween(RandomizedTest.getRandom(), minCodePoints, maxCodePoints);
    }

    public static String randomRealisticUnicodeOfCodepointLength(int codePoints) {
        return RandomStrings.randomRealisticUnicodeOfCodepointLength(RandomizedTest.getRandom(), codePoints);
    }

    public static Object[] $(Object ... objects) {
        return objects;
    }

    public static Object[][] $$(Object[] ... objects) {
        return objects;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Rethrow.rethrow(e);
        }
    }

    public static void assumeTrue(boolean condition) {
        Assume.assumeTrue((boolean)condition);
    }

    public static void assumeFalse(boolean condition) {
        RandomizedTest.assumeTrue(!condition);
    }

    public static void assumeNotNull(Object ... objects) {
        Assume.assumeNotNull((Object[])objects);
    }

    public static void assumeTrue(String message, boolean condition) {
        if (!condition) {
            throw new InternalAssumptionViolatedException(message);
        }
    }

    public static void assumeFalse(String message, boolean condition) {
        RandomizedTest.assumeTrue(message, !condition);
    }

    public static void assumeNoException(String msg, Throwable t) {
        if (t != null) {
            throw new InternalAssumptionViolatedException(msg, t);
        }
    }

    public static void assumeNoException(Throwable t) {
        Assume.assumeNoException((Throwable)t);
    }

    public static double systemPropertyAsDouble(String propertyName, double defaultValue) {
        String v = System.getProperty(propertyName);
        if (v != null && !v.trim().isEmpty()) {
            try {
                return Double.parseDouble(v.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Double value expected for property " + propertyName + ": " + v, e);
            }
        }
        return defaultValue;
    }

    public static float systemPropertyAsFloat(String propertyName, float defaultValue) {
        String v = System.getProperty(propertyName);
        if (v != null && !v.trim().isEmpty()) {
            try {
                return Float.parseFloat(v.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Float value expected for property " + propertyName + ": " + v, e);
            }
        }
        return defaultValue;
    }

    public static int systemPropertyAsInt(String propertyName, int defaultValue) {
        String v = System.getProperty(propertyName);
        if (v != null && !v.trim().isEmpty()) {
            try {
                return Integer.parseInt(v.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Integer value expected for property " + propertyName + ": " + v, e);
            }
        }
        return defaultValue;
    }

    public static float systemPropertyAsLong(String propertyName, int defaultValue) {
        String v = System.getProperty(propertyName);
        if (v != null && !v.trim().isEmpty()) {
            try {
                return Long.parseLong(v.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Long value expected for property " + propertyName + ": " + v, e);
            }
        }
        return defaultValue;
    }

    public static boolean systemPropertyAsBoolean(String propertyName, boolean defaultValue) {
        String v = System.getProperty(propertyName);
        if (v != null && !v.trim().isEmpty()) {
            Boolean result = BOOLEANS.get(v = v.trim());
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Boolean value expected for property " + propertyName + " " + "(true/false, on/off, enabled/disabled, yes/no): " + v);
        }
        return defaultValue;
    }

    private static void checkContext() {
        RandomizedContext.current();
    }

    static {
        BOOLEANS = new HashMap<String, Boolean>(){
            {
                this.put("true", true);
                this.put("false", false);
                this.put("on", true);
                this.put("off", false);
                this.put("yes", true);
                this.put("no", false);
                this.put("enabled", true);
                this.put("disabled", false);
            }
        };
    }
}

