/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.common.messages;

import com.bettercloud.scim2.common.BaseScimResource;
import com.bettercloud.scim2.common.GenericScimResource;
import com.bettercloud.scim2.common.annotations.Attribute;
import com.bettercloud.scim2.common.annotations.Schema;
import com.bettercloud.scim2.common.exceptions.ScimException;
import com.bettercloud.scim2.common.messages.PatchOperation;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@Schema(id="urn:ietf:params:scim:api:messages:2.0:PatchOp", name="Patch Operation", description="SCIM 2.0 Patch Operation Request")
public final class PatchRequest
extends BaseScimResource
implements Iterable<PatchOperation> {
    private static final long serialVersionUID = -719131911989530138L;
    @Attribute(description="Patch Operations")
    @JsonProperty(value="Operations", required=true)
    private final List<PatchOperation> operations;

    @JsonCreator
    public PatchRequest(@JsonProperty(value="Operations", required=true) List<PatchOperation> operations) {
        this.operations = Collections.unmodifiableList(operations);
    }

    public List<PatchOperation> getOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    @Override
    public Iterator<PatchOperation> iterator() {
        return this.getOperations().iterator();
    }

    public void apply(GenericScimResource object) throws ScimException {
        for (PatchOperation operation : this) {
            operation.apply(object.getObjectNode());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatchRequest that = (PatchRequest)o;
        return this.operations.equals(that.operations);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.operations.hashCode();
        return result;
    }
}

