/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.common.filters;

import com.bettercloud.scim2.common.Path;
import com.bettercloud.scim2.common.exceptions.ScimException;
import com.bettercloud.scim2.common.filters.Filter;
import com.bettercloud.scim2.common.filters.FilterType;
import com.bettercloud.scim2.common.filters.FilterVisitor;

public final class ComplexValueFilter
extends Filter {
    private final Path filterAttribute;
    private final Filter valueFilter;

    ComplexValueFilter(Path filterAttribute, Filter valueFilter) {
        this.filterAttribute = filterAttribute;
        this.valueFilter = valueFilter;
    }

    @Override
    public Path getAttributePath() {
        return this.filterAttribute;
    }

    @Override
    public boolean isComplexValueFilter() {
        return true;
    }

    @Override
    public Filter getValueFilter() {
        return this.valueFilter;
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append(this.filterAttribute);
        builder.append('[');
        builder.append(this.valueFilter);
        builder.append(']');
    }

    @Override
    public <R, P> R visit(FilterVisitor<R, P> visitor, P param) throws ScimException {
        return visitor.visit(this, param);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.COMPLEX_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexValueFilter that = (ComplexValueFilter)o;
        if (!this.filterAttribute.equals(that.filterAttribute)) {
            return false;
        }
        return this.valueFilter.equals(that.valueFilter);
    }

    public int hashCode() {
        int result = this.filterAttribute.hashCode();
        result = 31 * result + this.valueFilter.hashCode();
        return result;
    }
}

