/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.common;

import com.bettercloud.scim2.common.Path;
import com.bettercloud.scim2.common.ScimResource;
import com.bettercloud.scim2.common.exceptions.ScimException;
import com.bettercloud.scim2.common.exceptions.ServerErrorException;
import com.bettercloud.scim2.common.types.Meta;
import com.bettercloud.scim2.common.utils.GenericScimObjectDeserializer;
import com.bettercloud.scim2.common.utils.GenericScimObjectSerializer;
import com.bettercloud.scim2.common.utils.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@JsonDeserialize(using=GenericScimObjectDeserializer.class)
@JsonSerialize(using=GenericScimObjectSerializer.class)
public final class GenericScimResource
implements ScimResource,
Serializable {
    private static final long serialVersionUID = -407103329078010411L;
    private static final Path SCHEMAS = Path.root().attribute("schemas");
    private static final Path ID = Path.root().attribute("id");
    private static final Path EXTERNAL_ID = Path.root().attribute("externalId");
    private static final Path META = Path.root().attribute("meta");
    private final ObjectNode objectNode;

    public GenericScimResource() {
        this.objectNode = JsonUtils.getJsonNodeFactory().objectNode();
    }

    public GenericScimResource(ObjectNode objectNode) {
        this.objectNode = objectNode;
    }

    public ObjectNode getObjectNode() {
        return this.objectNode;
    }

    @Override
    public Meta getMeta() {
        try {
            List<JsonNode> values = JsonUtils.findMatchingPaths(META, this.objectNode);
            if (values.isEmpty()) {
                return null;
            }
            return JsonUtils.nodeToValue(values.get(0), Meta.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setMeta(Meta meta) {
        try {
            JsonUtils.replaceValue(META, this.objectNode, JsonUtils.valueToNode(meta));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getId() {
        try {
            JsonNode value = JsonUtils.getValue(ID, this.objectNode);
            if (value.isNull()) {
                return null;
            }
            return JsonUtils.nodeToValue(value, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setId(String id) {
        try {
            JsonUtils.replaceValue(ID, this.objectNode, JsonUtils.valueToNode(id));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getSchemaUrns() {
        try {
            JsonNode value = JsonUtils.getValue(SCHEMAS, this.objectNode);
            if (value.isNull() || !value.isArray()) {
                return Collections.emptyList();
            }
            return JsonUtils.nodeToValues((ArrayNode)value, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setSchemaUrns(Collection<String> schemaUrns) {
        try {
            JsonUtils.replaceValue(SCHEMAS, this.objectNode, JsonUtils.valueToNode(schemaUrns));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getExternalId() {
        try {
            JsonNode value = JsonUtils.getValue(EXTERNAL_ID, this.objectNode);
            if (value.isNull()) {
                return null;
            }
            return JsonUtils.nodeToValue(value, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setExternalId(String externalId) {
        try {
            JsonUtils.replaceValue(EXTERNAL_ID, this.objectNode, JsonUtils.valueToNode(externalId));
        }
        catch (ScimException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode getValue(String path) throws ScimException {
        return this.getValue(Path.fromString(path));
    }

    public JsonNode getValue(Path path) throws ScimException {
        return JsonUtils.getValue(path, this.objectNode);
    }

    public GenericScimResource replaceValue(String path, JsonNode value) throws ScimException {
        this.replaceValue(Path.fromString(path), value);
        return this;
    }

    public GenericScimResource replaceValue(Path path, JsonNode value) throws ScimException {
        JsonUtils.replaceValue(path, this.objectNode, value);
        return this;
    }

    public GenericScimResource addValues(String path, ArrayNode values) throws ScimException {
        this.addValues(Path.fromString(path), values);
        return this;
    }

    public GenericScimResource addValues(Path path, ArrayNode values) throws ScimException {
        JsonUtils.addValue(path, this.objectNode, (JsonNode)values);
        return this;
    }

    public boolean removeValues(String path) throws ScimException {
        return this.removeValues(Path.fromString(path));
    }

    public boolean removeValues(Path path) throws ScimException {
        List<JsonNode> nodes = JsonUtils.removeValues(path, this.objectNode);
        return !nodes.isEmpty();
    }

    @Override
    public GenericScimResource asGenericScimResource() {
        return this;
    }

    public String toString() {
        try {
            return JsonUtils.getObjectWriter().withDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public GenericScimResource replaceValue(String path, String value) throws ScimException {
        return this.replaceValue(Path.fromString(path), value);
    }

    public GenericScimResource replaceValue(Path path, String value) throws ScimException {
        return this.replaceValue(path, (JsonNode)JsonUtils.getJsonNodeFactory().textNode(value));
    }

    public GenericScimResource addStringValues(String path, List<String> values) throws ScimException {
        return this.addStringValues(Path.fromString(path), values);
    }

    public GenericScimResource addStringValues(Path path, List<String> values) throws ScimException {
        ArrayNode valuesArrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (String value : values) {
            valuesArrayNode.add(value);
        }
        return this.addValues(path, valuesArrayNode);
    }

    public String getStringValue(String path) throws ScimException {
        return this.getStringValue(Path.fromString(path));
    }

    public String getStringValue(Path path) throws ScimException {
        JsonNode jsonNode = this.getValue(path);
        return jsonNode.isNull() ? null : jsonNode.textValue();
    }

    public List<String> getStringValueList(String path) throws ScimException {
        return this.getStringValueList(Path.fromString(path));
    }

    public List<String> getStringValueList(Path path) throws ScimException {
        JsonNode valueNode = this.getValue(path);
        ArrayList<String> values = new ArrayList<String>();
        Iterator iterator = valueNode.iterator();
        while (iterator.hasNext()) {
            values.add(((JsonNode)iterator.next()).textValue());
        }
        return values;
    }

    public GenericScimResource replaceValue(String path, Boolean value) throws ScimException {
        return this.replaceValue(Path.fromString(path), value);
    }

    public GenericScimResource replaceValue(Path path, Boolean value) throws ScimException {
        return this.replaceValue(path, (JsonNode)JsonUtils.getJsonNodeFactory().booleanNode(value.booleanValue()));
    }

    public GenericScimResource addBooleanValues(String path, List<Boolean> values) throws ScimException {
        return this.addBooleanValues(Path.fromString(path), values);
    }

    public GenericScimResource addBooleanValues(Path path, List<Boolean> values) throws ScimException {
        ArrayNode valuesArrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (Boolean value : values) {
            valuesArrayNode.add(value);
        }
        return this.addValues(path, valuesArrayNode);
    }

    public Boolean getBooleanValue(String path) throws ScimException {
        return this.getBooleanValue(Path.fromString(path));
    }

    public Boolean getBooleanValue(Path path) throws ScimException {
        JsonNode jsonNode = this.getValue(path);
        return jsonNode.isNull() ? null : Boolean.valueOf(jsonNode.booleanValue());
    }

    public List<Boolean> getBooleanValueList(String path) throws ScimException {
        return this.getBooleanValueList(Path.fromString(path));
    }

    public List<Boolean> getBooleanValueList(Path path) throws ScimException {
        JsonNode valueNode = this.getValue(path);
        ArrayList<Boolean> values = new ArrayList<Boolean>();
        Iterator iterator = valueNode.iterator();
        while (iterator.hasNext()) {
            values.add(((JsonNode)iterator.next()).booleanValue());
        }
        return values;
    }

    public GenericScimResource replaceValue(String path, Double value) throws ScimException {
        return this.replaceValue(Path.fromString(path), value);
    }

    public GenericScimResource replaceValue(Path path, Double value) throws ScimException {
        return this.replaceValue(path, (JsonNode)JsonUtils.getJsonNodeFactory().numberNode(value));
    }

    public GenericScimResource addDoubleValues(String path, List<Double> values) throws ScimException {
        return this.addDoubleValues(Path.fromString(path), values);
    }

    public GenericScimResource addDoubleValues(Path path, List<Double> values) throws ScimException {
        ArrayNode valuesArrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (Double value : values) {
            valuesArrayNode.add(value);
        }
        return this.addValues(path, valuesArrayNode);
    }

    public Double getDoubleValue(String path) throws ScimException {
        return this.getDoubleValue(Path.fromString(path));
    }

    public Double getDoubleValue(Path path) throws ScimException {
        JsonNode jsonNode = this.getValue(path);
        return jsonNode.isNull() ? null : Double.valueOf(jsonNode.doubleValue());
    }

    public List<Double> getDoubleValueList(String path) throws ScimException {
        return this.getDoubleValueList(Path.fromString(path));
    }

    public List<Double> getDoubleValueList(Path path) throws ScimException {
        JsonNode valueNode = this.getValue(path);
        ArrayList<Double> values = new ArrayList<Double>();
        Iterator iterator = valueNode.iterator();
        while (iterator.hasNext()) {
            values.add(((JsonNode)iterator.next()).doubleValue());
        }
        return values;
    }

    public GenericScimResource replaceValue(String path, Integer value) throws ScimException {
        return this.replaceValue(Path.fromString(path), value);
    }

    public GenericScimResource replaceValue(Path path, Integer value) throws ScimException {
        return this.replaceValue(path, (JsonNode)JsonUtils.getJsonNodeFactory().numberNode(value));
    }

    public GenericScimResource addIntegerValues(String path, List<Integer> values) throws ScimException {
        return this.addIntegerValues(Path.fromString(path), values);
    }

    public GenericScimResource addIntegerValues(Path path, List<Integer> values) throws ScimException {
        ArrayNode valuesArrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (Integer value : values) {
            valuesArrayNode.add(value);
        }
        return this.addValues(path, valuesArrayNode);
    }

    public Integer getIntegerValue(String path) throws ScimException {
        return this.getIntegerValue(Path.fromString(path));
    }

    public Integer getIntegerValue(Path path) throws ScimException {
        JsonNode jsonNode = this.getValue(path);
        return jsonNode.isNull() ? null : Integer.valueOf(jsonNode.intValue());
    }

    public List<Integer> getIntegerValueList(String path) throws ScimException {
        return this.getIntegerValueList(Path.fromString(path));
    }

    public List<Integer> getIntegerValueList(Path path) throws ScimException {
        JsonNode valueNode = this.getValue(path);
        ArrayList<Integer> values = new ArrayList<Integer>();
        Iterator iterator = valueNode.iterator();
        while (iterator.hasNext()) {
            values.add(((JsonNode)iterator.next()).intValue());
        }
        return values;
    }

    public GenericScimResource replaceValue(String path, Long value) throws ScimException {
        return this.replaceValue(Path.fromString(path), value);
    }

    public GenericScimResource replaceValue(Path path, Long value) throws ScimException {
        return this.replaceValue(path, (JsonNode)JsonUtils.getJsonNodeFactory().numberNode(value));
    }

    public GenericScimResource addLongValues(String path, List<Long> values) throws ScimException {
        return this.addLongValues(Path.fromString(path), values);
    }

    public GenericScimResource addLongValues(Path path, List<Long> values) throws ScimException {
        ArrayNode valuesArrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (Long value : values) {
            valuesArrayNode.add(value);
        }
        return this.addValues(path, valuesArrayNode);
    }

    public Long getLongValue(String path) throws ScimException {
        return this.getLongValue(Path.fromString(path));
    }

    public Long getLongValue(Path path) throws ScimException {
        JsonNode jsonNode = this.getValue(path);
        return jsonNode.isNull() ? null : Long.valueOf(jsonNode.longValue());
    }

    public List<Long> getLongValueList(String path) throws ScimException {
        return this.getLongValueList(Path.fromString(path));
    }

    public List<Long> getLongValueList(Path path) throws ScimException {
        JsonNode valueNode = this.getValue(path);
        ArrayList<Long> values = new ArrayList<Long>();
        Iterator iterator = valueNode.iterator();
        while (iterator.hasNext()) {
            values.add(((JsonNode)iterator.next()).longValue());
        }
        return values;
    }

    public GenericScimResource replaceValue(String path, Date value) throws ScimException {
        return this.replaceValue(Path.fromString(path), value);
    }

    public GenericScimResource replaceValue(Path path, Date value) throws ScimException {
        return this.replaceValue(path, (JsonNode)GenericScimResource.getDateJsonNode(value));
    }

    public GenericScimResource addDateValues(String path, List<Date> values) throws ScimException {
        return this.addDateValues(Path.fromString(path), values);
    }

    public GenericScimResource addDateValues(Path path, List<Date> values) throws ScimException {
        ArrayNode valuesArrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (Date value : values) {
            valuesArrayNode.add((JsonNode)GenericScimResource.getDateJsonNode(value));
        }
        return this.addValues(path, valuesArrayNode);
    }

    public Date getDateValue(String path) throws ScimException {
        return this.getDateValue(Path.fromString(path));
    }

    public Date getDateValue(Path path) throws ScimException {
        JsonNode jsonNode = this.getValue(path);
        if (jsonNode.isNull()) {
            return null;
        }
        return GenericScimResource.getDateFromJsonNode(jsonNode);
    }

    public List<Date> getDateValueList(String path) throws ScimException {
        return this.getDateValueList(Path.fromString(path));
    }

    public List<Date> getDateValueList(Path path) throws ScimException {
        JsonNode valueNode = this.getValue(path);
        ArrayList<Date> values = new ArrayList<Date>();
        Iterator iterator = valueNode.iterator();
        while (iterator.hasNext()) {
            values.add(GenericScimResource.getDateFromJsonNode((JsonNode)iterator.next()));
        }
        return values;
    }

    public static TextNode getDateJsonNode(Date date) throws ScimException {
        return (TextNode)JsonUtils.valueToNode(date);
    }

    public static Date getDateFromJsonNode(JsonNode node) throws ScimException {
        try {
            return (Date)JsonUtils.getObjectReader().forType(Date.class).readValue(node);
        }
        catch (JsonProcessingException ex) {
            throw new ServerErrorException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new ServerErrorException(ex.getMessage());
        }
    }

    public GenericScimResource replaceValue(String path, byte[] value) throws ScimException {
        return this.replaceValue(Path.fromString(path), value);
    }

    public GenericScimResource replaceValue(Path path, byte[] value) throws ScimException {
        return this.replaceValue(path, (JsonNode)JsonUtils.getJsonNodeFactory().binaryNode(value));
    }

    public GenericScimResource addBinaryValues(String path, List<byte[]> values) throws ScimException {
        return this.addBinaryValues(Path.fromString(path), values);
    }

    public GenericScimResource addBinaryValues(Path path, List<byte[]> values) throws ScimException {
        ArrayNode valuesArrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (byte[] value : values) {
            valuesArrayNode.add((JsonNode)JsonUtils.getJsonNodeFactory().binaryNode(value));
        }
        return this.addValues(path, valuesArrayNode);
    }

    public byte[] getBinaryValue(String path) throws ScimException {
        return this.getBinaryValue(Path.fromString(path));
    }

    public byte[] getBinaryValue(Path path) throws ScimException {
        JsonNode jsonNode = this.getValue(path);
        if (jsonNode.isNull()) {
            return null;
        }
        try {
            return jsonNode.binaryValue();
        }
        catch (IOException e) {
            throw new ServerErrorException(e.getMessage());
        }
    }

    public List<byte[]> getBinaryValueList(String path) throws ScimException {
        return this.getBinaryValueList(Path.fromString(path));
    }

    public List<byte[]> getBinaryValueList(Path path) throws ScimException {
        JsonNode valueNode = this.getValue(path);
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        Iterator iterator = valueNode.iterator();
        while (iterator.hasNext()) {
            try {
                byte[] value = ((JsonNode)iterator.next()).binaryValue();
                if (value == null) {
                    throw new ServerErrorException("Value at path " + path + " is not a valid base64 string");
                }
                values.add(value);
            }
            catch (IOException e) {
                throw new ServerErrorException(e.getMessage());
            }
        }
        return values;
    }

    public GenericScimResource replaceValue(String path, URI value) throws ScimException {
        return this.replaceValue(Path.fromString(path), value);
    }

    public GenericScimResource replaceValue(Path path, URI value) throws ScimException {
        return this.replaceValue(path, (JsonNode)JsonUtils.getJsonNodeFactory().textNode(value.toString()));
    }

    public GenericScimResource addURIValues(String path, List<URI> values) throws ScimException {
        return this.addURIValues(Path.fromString(path), values);
    }

    public GenericScimResource addURIValues(Path path, List<URI> values) throws ScimException {
        ArrayNode valuesArrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (URI value : values) {
            valuesArrayNode.add(value.toString());
        }
        return this.addValues(path, valuesArrayNode);
    }

    public URI getURIValue(String path) throws ScimException {
        return this.getURIValue(Path.fromString(path));
    }

    public URI getURIValue(Path path) throws ScimException {
        try {
            JsonNode jsonNode = this.getValue(path);
            return jsonNode.isNull() ? null : new URI(jsonNode.textValue());
        }
        catch (URISyntaxException ex) {
            throw new ServerErrorException(ex.getMessage());
        }
    }

    public List<URI> getURIValueList(String path) throws ScimException {
        return this.getURIValueList(Path.fromString(path));
    }

    public List<URI> getURIValueList(Path path) throws ScimException {
        try {
            JsonNode valueNode = this.getValue(path);
            ArrayList<URI> values = new ArrayList<URI>();
            Iterator iterator = valueNode.iterator();
            while (iterator.hasNext()) {
                String uriString = ((JsonNode)iterator.next()).textValue();
                values.add(new URI(uriString));
            }
            return values;
        }
        catch (URISyntaxException ex) {
            throw new ServerErrorException(ex.getMessage());
        }
    }
}

