/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import weibo4j.http.Response;
import weibo4j.model.Status;
import weibo4j.model.UserWapper;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;

public class User
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -332738032648843482L;
    private JSONObject json;
    private Long id;
    private String idstr;
    private String screenName;
    private String name;
    private int province;
    private int city;
    private String location;
    private String description;
    private String url;
    private String profileImageUrl;
    private String profileUrl;
    private String domain;
    private String weihao;
    private String gender;
    private int followersCount;
    private int friendsCount;
    private int statusesCount;
    private int favouritesCount;
    private Date createdAt;
    private boolean following;
    private boolean allowAllActMsg;
    private boolean geoEnabled;
    private boolean verified;
    private int verifiedType;
    private String remark;
    private Status status = null;
    private boolean allowAllComment;
    private String avatarLarge;
    private String verifiedReason;
    private boolean followMe;
    private int onlineStatus;
    private int biFollowersCount;
    private String lang;

    public User(JSONObject json) throws WeiboException {
        this.init(json);
    }

    private void init(JSONObject json) throws WeiboException {
        if (json != null) {
            try {
                this.id = json.getLong("id");
                this.idstr = json.getString("idstr");
                this.screenName = json.getString("screen_name");
                this.name = json.getString("name");
                this.province = json.getInt("province");
                this.city = json.getInt("city");
                this.location = json.getString("location");
                this.description = json.getString("description");
                this.url = json.getString("url");
                this.profileImageUrl = json.getString("profile_image_url");
                this.profileUrl = json.getString("profile_url");
                this.domain = json.getString("domain");
                this.weihao = json.getString("weihao");
                this.gender = json.getString("gender");
                this.followersCount = json.getInt("followers_count");
                this.friendsCount = json.getInt("friends_count");
                this.favouritesCount = json.getInt("favourites_count");
                this.statusesCount = json.getInt("statuses_count");
                this.createdAt = User.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
                this.following = User.getBoolean("following", json);
                this.allowAllActMsg = json.getBoolean("allow_all_act_msg");
                this.geoEnabled = json.getBoolean("geo_enabled");
                this.verified = User.getBoolean("verified", json);
                this.verifiedType = json.getInt("verified_type");
                this.remark = json.optString("remark");
                if (!json.isNull("status")) {
                    this.status = new Status(json.getJSONObject("status"));
                }
                this.allowAllComment = json.getBoolean("allow_all_comment");
                this.avatarLarge = json.getString("avatar_large");
                this.verifiedReason = json.getString("verified_reason");
                this.followMe = json.getBoolean("follow_me");
                this.onlineStatus = json.getInt("online_status");
                this.biFollowersCount = json.getInt("bi_followers_count");
                this.lang = json.getString("lang");
            }
            catch (JSONException jsone) {
                throw new WeiboException(jsone.getMessage() + ":" + json.toString(), (Exception)((Object)jsone));
            }
        }
    }

    public static String[] constructIds(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONObject().getJSONArray("ids");
            String temp = list.toString().substring(1, list.toString().length() - 1);
            String[] ids = temp.split(",");
            return ids;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone.getMessage() + ":" + jsone.toString(), (Exception)((Object)jsone));
        }
    }

    public static UserWapper constructWapperUsers(Response res) throws WeiboException {
        JSONObject jsonUsers = res.asJSONObject();
        try {
            JSONArray user = jsonUsers.getJSONArray("users");
            int size = user.length();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User(user.getJSONObject(i)));
            }
            long previousCursor = jsonUsers.getLong("previous_curosr");
            long nextCursor = jsonUsers.getLong("next_cursor");
            long totalNumber = jsonUsers.getLong("total_number");
            String hasvisible = jsonUsers.getString("hasvisible");
            return new UserWapper(users, previousCursor, nextCursor, totalNumber, hasvisible);
        }
        catch (JSONException jsone) {
            throw new WeiboException((Exception)((Object)jsone));
        }
    }

    static List<User> constructResult(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User(list.getJSONObject(i)));
            }
            return users;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.json.toString();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getIdstr() {
        return this.idstr;
    }

    public void setIdstr(String idstr) {
        this.idstr = idstr;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getProvince() {
        return this.province;
    }

    public void setProvince(int province) {
        this.province = province;
    }

    public int getCity() {
        return this.city;
    }

    public void setCity(int city) {
        this.city = city;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getProfileImageUrl() {
        return this.profileImageUrl;
    }

    public void setProfileImageUrl(String profileImageUrl) {
        this.profileImageUrl = profileImageUrl;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getWeihao() {
        return this.weihao;
    }

    public void setWeihao(String weihao) {
        this.weihao = weihao;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public void setFollowersCount(int followersCount) {
        this.followersCount = followersCount;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public void setFriendsCount(int friendsCount) {
        this.friendsCount = friendsCount;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public void setStatusesCount(int statusesCount) {
        this.statusesCount = statusesCount;
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public void setFavouritesCount(int favouritesCount) {
        this.favouritesCount = favouritesCount;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public boolean isFollowing() {
        return this.following;
    }

    public void setFollowing(boolean following) {
        this.following = following;
    }

    public boolean isAllowAllActMsg() {
        return this.allowAllActMsg;
    }

    public void setAllowAllActMsg(boolean allowAllActMsg) {
        this.allowAllActMsg = allowAllActMsg;
    }

    public boolean isGeoEnabled() {
        return this.geoEnabled;
    }

    public void setGeoEnabled(boolean geoEnabled) {
        this.geoEnabled = geoEnabled;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public int getVerifiedType() {
        return this.verifiedType;
    }

    public void setVerifiedType(int verifiedType) {
        this.verifiedType = verifiedType;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isAllowAllComment() {
        return this.allowAllComment;
    }

    public void setAllowAllComment(boolean allowAllComment) {
        this.allowAllComment = allowAllComment;
    }

    public String getAvatarLarge() {
        return this.avatarLarge;
    }

    public void setAvatarLarge(String avatarLarge) {
        this.avatarLarge = avatarLarge;
    }

    public String getVerifiedReason() {
        return this.verifiedReason;
    }

    public void setVerifiedReason(String verifiedReason) {
        this.verifiedReason = verifiedReason;
    }

    public boolean isFollowMe() {
        return this.followMe;
    }

    public void setFollowMe(boolean followMe) {
        this.followMe = followMe;
    }

    public int getOnlineStatus() {
        return this.onlineStatus;
    }

    public void setOnlineStatus(int onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    public int getBiFollowersCount() {
        return this.biFollowersCount;
    }

    public void setBiFollowersCount(int biFollowersCount) {
        this.biFollowersCount = biFollowersCount;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }
}

