/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import weibo4j.Weibo;
import weibo4j.model.Favorites;
import weibo4j.model.FavoritesTag;
import weibo4j.model.Paging;
import weibo4j.model.PostParameter;
import weibo4j.model.Tag;
import weibo4j.model.WeiboException;
import weibo4j.util.WeiboConfig;

public class Favorite
extends Weibo {
    private static final long serialVersionUID = 2298934944028795652L;

    public List<Favorites> getFavorites() throws WeiboException {
        return Favorites.constructFavorites(this.client.get(WeiboConfig.getValue("baseURL") + "favorites.json"));
    }

    public List<Favorites> getFavorites(Paging page) throws WeiboException {
        return Favorites.constructFavorites(this.client.get(WeiboConfig.getValue("baseURL") + "favorites.json", null, page));
    }

    public JSONObject getFavoritesIds() throws WeiboException {
        return this.client.get(WeiboConfig.getValue("baseURL") + "favorites/ids.json").asJSONObject();
    }

    public JSONObject getFavoritesIds(Paging page) throws WeiboException {
        return this.client.get(WeiboConfig.getValue("baseURL") + "favorites/ids.json", null, page).asJSONObject();
    }

    public Favorites showFavorites(String id) throws WeiboException {
        return new Favorites(this.client.get(WeiboConfig.getValue("baseURL") + "favorites/show.json", new PostParameter[]{new PostParameter("id", id)}));
    }

    public List<Favorites> getFavoritesByTags(String tid) throws WeiboException {
        return Favorites.constructFavorites(this.client.get(WeiboConfig.getValue("baseURL") + "favorites/by_tags.json", new PostParameter[]{new PostParameter("tid", tid)}));
    }

    public List<Favorites> getFavoritesByTags(String tid, Paging page) throws WeiboException {
        return Favorites.constructFavorites(this.client.get(WeiboConfig.getValue("baseURL") + "favorites/by_tags.json", new PostParameter[]{new PostParameter("tid", tid)}, page));
    }

    public List<FavoritesTag> getFavoritesTags() throws WeiboException {
        return Tag.constructTag(this.client.get(WeiboConfig.getValue("baseURL") + "favorites/tags.json"));
    }

    public Favorites createFavorites(String id) throws WeiboException {
        return new Favorites(this.client.post(WeiboConfig.getValue("baseURL") + "favorites/create.json", new PostParameter[]{new PostParameter("id", id)}));
    }

    public Favorites destroyFavorites(String id) throws WeiboException {
        return new Favorites(this.client.post(WeiboConfig.getValue("baseURL") + "favorites/destroy.json", new PostParameter[]{new PostParameter("id", id)}));
    }

    public Boolean destroyFavoritesBatch(String ids) throws WeiboException {
        try {
            return this.client.post(WeiboConfig.getValue("baseURL") + "favorites/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}).asJSONObject().getBoolean("result");
        }
        catch (JSONException e) {
            throw new WeiboException((Exception)((Object)e));
        }
    }

    public Favorites updateFavoritesTags(String id) throws WeiboException {
        return new Favorites(this.client.post(WeiboConfig.getValue("baseURL") + "favorites/tags/update.json", new PostParameter[]{new PostParameter("id", id)}));
    }

    public Favorites updateFavoritesTags(String id, String tags) throws WeiboException {
        return new Favorites(this.client.post(WeiboConfig.getValue("baseURL") + "favorites/tags/update.json", new PostParameter[]{new PostParameter("id", id), new PostParameter("tags", tags)}));
    }

    public JSONObject updateFavoritesTagsBatch(String tid, String tag) throws WeiboException {
        return this.client.post(WeiboConfig.getValue("baseURL") + "favorites/tags/update_batch.json", new PostParameter[]{new PostParameter("tid", tid), new PostParameter("tag", tag)}).asJSONObject();
    }

    public Boolean destroyFavoritesTagsBatch(String ids) throws WeiboException {
        try {
            return this.client.post(WeiboConfig.getValue("baseURL") + "favorites/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}).asJSONObject().getBoolean("result");
        }
        catch (JSONException e) {
            throw new WeiboException((Exception)((Object)e));
        }
    }
}

