/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.plugin.kafka;

import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProductor {
    private KafkaProducer<Object, Object> producer = null;
    private static final Logger logger = LoggerFactory.getLogger(KafkaProductor.class);
    private Properties productorPropes;
    private boolean sendDatatoKafka = false;

    public void init() {
        if (this.sendDatatoKafka) {
            this.producer = new KafkaProducer(this.productorPropes);
        }
    }

    public Future<RecordMetadata> send(ProducerRecord<Object, Object> record, Callback callback) {
        if (this.sendDatatoKafka && this.producer != null) {
            return this.producer.send(record, callback);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Ignore send Data to Kafka:sendDatatoKafka={} or producer is null", (Object)this.sendDatatoKafka);
        }
        return null;
    }

    public Future<RecordMetadata> send(String topic, Object msg, Callback callback) {
        if (this.sendDatatoKafka && this.producer != null) {
            return this.producer.send(new ProducerRecord(topic, null, msg), callback);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Ignore send Data to Kafka:sendDatatoKafka={} or producer is null", (Object)this.sendDatatoKafka);
        }
        return null;
    }

    public Future<RecordMetadata> send(String topic, Object key, Object msg, Callback callback) {
        if (this.sendDatatoKafka && this.producer != null) {
            return this.producer.send(new ProducerRecord(topic, key, msg), callback);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Ignore send Data to Kafka:sendDatatoKafka={} or producer is null", (Object)this.sendDatatoKafka);
        }
        return null;
    }

    public Future<RecordMetadata> send(String topic, Object msg) {
        return this.send(topic, msg, null);
    }

    public Future<RecordMetadata> send(String topic, Object key, Object msg) {
        return this.send(topic, key, msg, null);
    }

    public Properties getProductorPropes() {
        return this.productorPropes;
    }

    public void setProductorPropes(Properties productorPropes) {
        this.productorPropes = productorPropes;
    }

    public boolean isSendDatatoKafka() {
        return this.sendDatatoKafka;
    }

    public void setSendDatatoKafka(boolean sendDatatoKafka) {
        this.sendDatatoKafka = sendDatatoKafka;
    }
}

