/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.plugin.kafka;

import org.frameworkset.plugin.kafka.KafkaListener;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.runtime.Starter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaConsumersStarter {
    private static Logger logger = LoggerFactory.getLogger(KafkaConsumersStarter.class);

    public static void startConsumers(String applicationContextIOC) {
        DefaultApplicationContext context = DefaultApplicationContext.getApplicationContext((String)applicationContextIOC);
        context.start(new Starter(){

            public void start(Pro pro, BaseApplicationContext ioc) {
                Object _service = ioc.getBeanObject(pro.getName());
                if (_service == null) {
                    return;
                }
                if (_service instanceof KafkaListener) {
                    KafkaListener consumer = (KafkaListener)_service;
                    Thread t = new Thread((Runnable)consumer, "kafka-consumer-" + pro.getName());
                    t.start();
                    if (logger.isInfoEnabled()) {
                        logger.info("Kafka Listener[name:{},class:{}] started.", (Object)pro.getName(), (Object)pro.getClazz());
                    }
                }
            }

            public void failed(Pro bean, BaseApplicationContext baseApplicationContext, Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Kafka Listener[name:" + bean.getName() + ",class:" + bean.getClazz() + "] start failed:", e);
                }
            }
        });
    }
}

