/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.boot;

import com.frameworkset.common.poolman.util.DBConf;
import com.frameworkset.common.poolman.util.SQLManager;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.boot.BBossESProperties;
import org.frameworkset.elasticsearch.boot.BaseESProperties;
import org.frameworkset.elasticsearch.boot.ElasticSearchBoot;
import org.frameworkset.elasticsearch.boot.ElasticsearchBootResult;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.spi.assemble.PropertiesInterceptor;
import org.frameworkset.spi.assemble.PropertyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BBossESStarter
extends BaseESProperties {
    @Autowired
    private BBossESProperties properties;
    private static final Logger log = LoggerFactory.getLogger(BBossESStarter.class);
    private ClientInterface restClient;

    public void start() {
        Class<?> clz;
        ElasticsearchBootResult elasticsearchBootResult;
        Map ps;
        PropertiesContainer propertiesContainer = null;
        if (this.getElasticsearch() == null) {
            if (this.properties.getElasticsearch() != null) {
                ps = this.properties.buildProperties();
                if (ps != null && ps.size() > 0) {
                    elasticsearchBootResult = ElasticSearchBoot.boot((Map)ps, (boolean)true);
                    propertiesContainer = elasticsearchBootResult.getPropertiesContainer();
                } else {
                    log.info("BBoss Elasticsearch Rest Client properties is not configed in spring application.properties file.Ignore load bboss elasticsearch rest client through spring boot starter.");
                }
            }
        } else {
            if (this.properties.getDslfile() != null && this.getDslfile() == null) {
                this.setDslfile(this.properties.getDslfile());
            }
            if (this.properties.getPropertiesInterceptor() != null && this.getPropertiesInterceptor() == null) {
                this.setPropertiesInterceptor(this.properties.getPropertiesInterceptor());
            }
            if ((ps = this.buildProperties()) != null && ps.size() > 0) {
                elasticsearchBootResult = ElasticSearchBoot.boot((Map)ps, (boolean)true);
                propertiesContainer = elasticsearchBootResult.getPropertiesContainer();
            } else {
                log.info("BBoss Elasticsearch Rest Client properties is not configed in spring application.properties file.Ignore load bboss elasticsearch rest client through spring boot starter.");
            }
        }
        String temp = null;
        temp = this.propertiesInterceptor == null ? this.properties.getPropertiesInterceptor() : this.propertiesInterceptor;
        if (temp != null && !temp.trim().equals("")) {
            temp = temp.trim();
        }
        if (this.getDb() == null) {
            if (this.properties.getDb() != null && this.properties.getDb().getUrl() != null) {
                if (propertiesContainer != null) {
                    propertiesContainer.interceptorValues((Object)this.properties.getDb());
                } else {
                    try {
                        clz = Class.forName(temp);
                        PropertiesInterceptor propertiesInterceptor = (PropertiesInterceptor)clz.newInstance();
                        PropertyContext propertyContext = new PropertyContext();
                        propertyContext.setValue((Object)this.properties.getDb());
                        propertiesInterceptor.convert(propertyContext);
                    }
                    catch (Exception e) {
                        log.error("Init Ds " + temp, (Throwable)e);
                    }
                }
                this.initDS(this.properties.getDb());
            }
        } else {
            if (this.getDb().getUrl() != null) {
                if (propertiesContainer != null) {
                    propertiesContainer.interceptorValues((Object)this.getDb());
                } else {
                    try {
                        clz = Class.forName(temp);
                        PropertiesInterceptor propertiesInterceptor = (PropertiesInterceptor)clz.newInstance();
                        PropertyContext propertyContext = new PropertyContext();
                        propertyContext.setValue((Object)this.getDb());
                        propertiesInterceptor.convert(propertyContext);
                    }
                    catch (Exception e) {
                        log.error("Init Ds " + temp, (Throwable)e);
                    }
                }
            }
            this.initDS(this.getDb());
        }
    }

    private void initDS(BaseESProperties.Db db) {
        DBConf temConf = new DBConf();
        temConf.setPoolname(db.getName());
        temConf.setDriver(db.getDriver());
        temConf.setJdbcurl(db.getUrl());
        temConf.setUsername(db.getUser());
        temConf.setPassword(db.getPassword());
        temConf.setReadOnly(null);
        temConf.setTxIsolationLevel(null);
        temConf.setValidationQuery(db.getValidateSQL());
        temConf.setJndiName(db.getName() + "_jndi");
        temConf.setInitialConnections(db.getInitSize() != null ? Integer.parseInt(db.getInitSize()) : 10);
        temConf.setMinimumSize(db.getMinIdleSize() != null ? Integer.parseInt(db.getMinIdleSize()) : 10);
        temConf.setMaximumSize(db.getMaxSize() != null ? Integer.parseInt(db.getMaxSize()) : 50);
        temConf.setUsepool(db.getUsePool() != null ? Boolean.parseBoolean(db.getUsePool()) : true);
        temConf.setExternal(false);
        temConf.setExternaljndiName(null);
        temConf.setShowsql(db.getShowSql() != null ? Boolean.parseBoolean(db.getShowSql()) : true);
        temConf.setEncryptdbinfo(false);
        temConf.setQueryfetchsize(Integer.valueOf(db.getJdbcFetchSize() != null ? Integer.parseInt(db.getJdbcFetchSize()) : 0));
        temConf.setDbAdaptor(db.getDbAdaptor());
        temConf.setDbtype(db.getDbtype());
        boolean ff = db.getColumnLableUpperCase() == null ? true : db.getColumnLableUpperCase().equals("true");
        temConf.setColumnLableUpperCase(ff);
        ff = db.getEnableShutdownHook() == null ? true : db.getEnableShutdownHook().equals("true");
        temConf.setEnableShutdownHook(ff);
        SQLManager.startPool((DBConf)temConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInterface getRestClient() {
        if (this.restClient == null) {
            BBossESStarter bBossESStarter = this;
            synchronized (bBossESStarter) {
                if (this.restClient == null) {
                    this.restClient = ElasticSearchHelper.getRestClientUtil();
                }
            }
        }
        return this.restClient;
    }

    public ClientInterface getRestClient(String elasticsearchName) {
        return ElasticSearchHelper.getRestClientUtil((String)elasticsearchName);
    }

    public ClientInterface getConfigRestClient(String configFile) {
        return ElasticSearchHelper.getConfigRestClientUtil((String)configFile);
    }

    public ClientInterface getConfigRestClient(String elasticsearchName, String configFile) {
        return ElasticSearchHelper.getConfigRestClientUtil((String)elasticsearchName, (String)configFile);
    }

    public ClientInterface getConfigRestClient(BaseTemplateContainerImpl templateContainer) {
        return ElasticSearchHelper.getConfigRestClientUtil((BaseTemplateContainerImpl)templateContainer);
    }

    public ClientInterface getConfigRestClient(String elasticsearchName, BaseTemplateContainerImpl templateContainer) {
        return ElasticSearchHelper.getConfigRestClientUtil((String)elasticsearchName, (BaseTemplateContainerImpl)templateContainer);
    }
}

