/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.boot;

import com.frameworkset.util.SimpleStringUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseESProperties {
    private String name;
    private String elasticUser;
    private String elasticPassword;
    private Elasticsearch elasticsearch;
    private Http http;
    private Db db;
    private Dslfile dslfile;

    public Dslfile getDslfile() {
        return this.dslfile;
    }

    public void setDslfile(Dslfile dslfile) {
        this.dslfile = dslfile;
    }

    public Http getHttp() {
        return this.http;
    }

    public void setHttp(Http http) {
        this.http = http;
    }

    public Db getDb() {
        return this.db;
    }

    public void setDb(Db db) {
        this.db = db;
    }

    public String getElasticUser() {
        return this.elasticUser;
    }

    public void setElasticUser(String elasticUser) {
        this.elasticUser = elasticUser;
    }

    public String getElasticPassword() {
        return this.elasticPassword;
    }

    public void setElasticPassword(String elasticPassword) {
        this.elasticPassword = elasticPassword;
    }

    public Elasticsearch getElasticsearch() {
        return this.elasticsearch;
    }

    public void setElasticsearch(Elasticsearch elasticsearch) {
        this.elasticsearch = elasticsearch;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map buildProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String _name = "";
        if (SimpleStringUtil.isNotEmpty((String)this.name)) {
            properties.put("elasticsearch.serverNames", this.name);
            _name = this.name + ".";
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticUser)) {
            properties.put(_name + "elasticUser", this.elasticUser);
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticPassword)) {
            properties.put(_name + "elasticPassword", this.elasticPassword);
        }
        if (this.getElasticsearch().getRest() != null && SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getRest().getHostNames())) {
            properties.put(_name + "elasticsearch.rest.hostNames", this.getElasticsearch().getRest().getHostNames());
        }
        if (this.getElasticsearch() != null) {
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getDateFormat())) {
                properties.put(_name + "elasticsearch.dateFormat", this.getElasticsearch().getDateFormat());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getTimeZone())) {
                properties.put(_name + "elasticsearch.timeZone", this.getElasticsearch().getTimeZone());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getTtl())) {
                properties.put(_name + "elasticsearch.ttl", this.getElasticsearch().getTtl());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getShowTemplate())) {
                properties.put(_name + "elasticsearch.showTemplate", this.getElasticsearch().getShowTemplate());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getElasticsearch().getDiscoverHost())) {
                properties.put(_name + "elasticsearch.discoverHost", this.getElasticsearch().getDiscoverHost());
            }
        }
        if (this.getHttp() != null) {
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getTimeoutConnection())) {
                properties.put(_name + "http.timeoutConnection", this.getHttp().getTimeoutConnection());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getTimeoutSocket())) {
                properties.put(_name + "http.timeoutSocket", this.getHttp().getTimeoutSocket());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getConnectionRequestTimeout())) {
                properties.put(_name + "http.connectionRequestTimeout", this.getHttp().getConnectionRequestTimeout());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getRetryTime())) {
                properties.put(_name + "http.retryTime", this.getHttp().getRetryTime());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getMaxLineLength())) {
                properties.put(_name + "http.maxLineLength", this.getHttp().getMaxLineLength());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getMaxHeaderCount())) {
                properties.put(_name + "http.maxHeaderCount", this.getHttp().getMaxHeaderCount());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getMaxTotal())) {
                properties.put(_name + "http.maxTotal", this.getHttp().getMaxTotal());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getDefaultMaxPerRoute())) {
                properties.put(_name + "http.defaultMaxPerRoute", this.getHttp().getDefaultMaxPerRoute());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getSoReuseAddress())) {
                properties.put(_name + "http.soReuseAddress", this.getHttp().getSoReuseAddress());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getSoKeepAlive())) {
                properties.put(_name + "http.soKeepAlive", this.getHttp().getSoKeepAlive());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getTimeToLive())) {
                properties.put(_name + "http.timeToLive", this.getHttp().getTimeToLive());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getKeepAlive())) {
                properties.put(_name + "http.keepAlive", this.getHttp().getKeepAlive());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getKeystore())) {
                properties.put(_name + "http.keystore", this.getHttp().getKeystore());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getKeyPassword())) {
                properties.put(_name + "http.keyPassword", this.getHttp().getKeyPassword());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.getHttp().getHostnameVerifier())) {
                properties.put(_name + "http.hostnameVerifier", this.getHttp().getHostnameVerifier());
            }
        }
        if (this.dslfile != null) {
            properties.put("dslfile.refreshInterval", this.dslfile.getRefreshInterval());
        }
        if (this.getDb() != null) {
            if (SimpleStringUtil.isNotEmpty((String)this.db.getName())) {
                properties.put("db.name", this.db.getName());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.db.getUser())) {
                properties.put("db.user", this.db.getUser());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.db.getPassword())) {
                properties.put("db.password", this.db.getPassword());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.db.getDriver())) {
                properties.put("db.driver", this.db.getDriver());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.db.getUrl())) {
                properties.put("db.url", this.db.getUrl());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.db.getUsePool())) {
                properties.put("db.usePool", this.db.getUsePool());
            }
            if (SimpleStringUtil.isNotEmpty((String)this.db.getValidateSQL())) {
                properties.put("db.validateSQL", this.db.getValidateSQL());
            }
        }
        return properties;
    }

    public static class Rest {
        private String hostNames;

        public String getHostNames() {
            return this.hostNames;
        }

        public void setHostNames(String hostNames) {
            this.hostNames = hostNames;
        }
    }

    public static class Dslfile {
        private String refreshInterval;

        public String getRefreshInterval() {
            return this.refreshInterval;
        }

        public void setRefreshInterval(String refreshInterval) {
            this.refreshInterval = refreshInterval;
        }
    }

    public static class Elasticsearch {
        private Rest rest;
        private String dateFormat;
        private String timeZone;
        private String ttl;
        private String showTemplate;
        private String discoverHost;

        public Rest getRest() {
            return this.rest;
        }

        public void setRest(Rest rest) {
            this.rest = rest;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public String getTtl() {
            return this.ttl;
        }

        public void setTtl(String ttl) {
            this.ttl = ttl;
        }

        public String getShowTemplate() {
            return this.showTemplate;
        }

        public void setShowTemplate(String showTemplate) {
            this.showTemplate = showTemplate;
        }

        public String getDiscoverHost() {
            return this.discoverHost;
        }

        public void setDiscoverHost(String discoverHost) {
            this.discoverHost = discoverHost;
        }
    }

    public static class Http {
        private String keystore;
        private String keyPassword;
        private String hostnameVerifier;
        private String timeoutConnection;
        private String timeoutSocket;
        private String connectionRequestTimeout;
        private String retryTime;
        private String maxLineLength;
        private String maxHeaderCount;
        private String maxTotal;
        private String defaultMaxPerRoute;
        private String soReuseAddress;
        private String soKeepAlive;
        private String timeToLive;
        private String keepAlive;

        public String getTimeoutConnection() {
            return this.timeoutConnection;
        }

        public void setTimeoutConnection(String timeoutConnection) {
            this.timeoutConnection = timeoutConnection;
        }

        public String getTimeoutSocket() {
            return this.timeoutSocket;
        }

        public void setTimeoutSocket(String timeoutSocket) {
            this.timeoutSocket = timeoutSocket;
        }

        public String getConnectionRequestTimeout() {
            return this.connectionRequestTimeout;
        }

        public void setConnectionRequestTimeout(String connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
        }

        public String getRetryTime() {
            return this.retryTime;
        }

        public void setRetryTime(String retryTime) {
            this.retryTime = retryTime;
        }

        public String getMaxLineLength() {
            return this.maxLineLength;
        }

        public void setMaxLineLength(String maxLineLength) {
            this.maxLineLength = maxLineLength;
        }

        public String getMaxHeaderCount() {
            return this.maxHeaderCount;
        }

        public void setMaxHeaderCount(String maxHeaderCount) {
            this.maxHeaderCount = maxHeaderCount;
        }

        public String getMaxTotal() {
            return this.maxTotal;
        }

        public void setMaxTotal(String maxTotal) {
            this.maxTotal = maxTotal;
        }

        public String getDefaultMaxPerRoute() {
            return this.defaultMaxPerRoute;
        }

        public void setDefaultMaxPerRoute(String defaultMaxPerRoute) {
            this.defaultMaxPerRoute = defaultMaxPerRoute;
        }

        public String getSoReuseAddress() {
            return this.soReuseAddress;
        }

        public void setSoReuseAddress(String soReuseAddress) {
            this.soReuseAddress = soReuseAddress;
        }

        public String getSoKeepAlive() {
            return this.soKeepAlive;
        }

        public void setSoKeepAlive(String soKeepAlive) {
            this.soKeepAlive = soKeepAlive;
        }

        public String getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(String timeToLive) {
            this.timeToLive = timeToLive;
        }

        public String getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(String keepAlive) {
            this.keepAlive = keepAlive;
        }

        public String getKeystore() {
            return this.keystore;
        }

        public void setKeystore(String keystore) {
            this.keystore = keystore;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public String getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public void setHostnameVerifier(String hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }
    }

    public static class Db {
        private String name;
        private String user;
        private String password;
        private String driver;
        private String url;
        private String usePool;
        private String validateSQL;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUsePool() {
            return this.usePool;
        }

        public void setUsePool(String usePool) {
            this.usePool = usePool;
        }

        public String getValidateSQL() {
            return this.validateSQL;
        }

        public void setValidateSQL(String validateSQL) {
            this.validateSQL = validateSQL;
        }
    }
}

