/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.template;

import java.io.Writer;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.template.ESSOAProviderParser;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.assemble.LinkConfigFile;
import org.frameworkset.spi.assemble.ProviderParser;
import org.frameworkset.spi.assemble.ServiceProviderManager;

public class ESServiceProviderManager
extends ServiceProviderManager {
    public static String var_pre = "@{";
    public static String var_end = "}";
    public static String jsonEscapePre = "@\"\"\"";
    public static String jsonEscapeEnd = "\"\"\"";
    public static String escapeRNPre = "#\"\"\"";
    public static String escapeRNEnd = "\"\"\"";

    public ESServiceProviderManager(BaseApplicationContext applicationContext, String charset) {
        super(applicationContext, charset);
    }

    public ESServiceProviderManager() {
        super(null);
    }

    public ESServiceProviderManager(BaseApplicationContext applicationContext) {
        super(applicationContext);
    }

    public String getVarpre() {
        return var_pre;
    }

    public String getVarend() {
        return var_end;
    }

    public boolean findVariableFromSelf() {
        return true;
    }

    public String getEscapePre() {
        return jsonEscapePre;
    }

    public String getEscapeEnd() {
        return jsonEscapeEnd;
    }

    public String getEscapeRNPre() {
        return escapeRNPre;
    }

    public String getEscapeRNEnd() {
        return escapeRNEnd;
    }

    public void escapeValue(String value, StringBuilder builder) {
        CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
        charEscapeUtil.writeString(value, true);
    }

    public void escapeRN(String value, StringBuilder builder) {
        builder.append(value.replaceAll("\r|\n+", " "));
    }

    protected ProviderParser _buildProviderParser() {
        return new ESSOAProviderParser(this.getApplicationContext());
    }

    protected ProviderParser _buildProviderParser(String url, LinkConfigFile linkconfigFile) {
        return new ESSOAProviderParser(this.getApplicationContext(), url, linkconfigFile);
    }
}

