/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.bulk;

import java.util.ArrayList;
import java.util.List;
import org.frameworkset.elasticsearch.bulk.BulkActionConfig;
import org.frameworkset.elasticsearch.bulk.BulkInterceptor;
import org.frameworkset.elasticsearch.bulk.BulkRetryHandler;

public class BulkConfig
implements BulkActionConfig {
    private List<BulkInterceptor> bulkInterceptors;
    private long blockedWaitTimeout;
    private int warnMultsRejects;
    private String elasticsearch;
    private String bulkProcessorName = "BulkProcessor";
    private String bulkRejectMessage = "Reject bulk processor";
    private String refreshOption;
    private BulkRetryHandler bulkRetryHandler;
    private int retryTimes = 3;
    private long retryInterval = 0L;
    private int bulkSizes;
    private int bulkFailRetry;
    private long flushInterval;
    private int workThreads = 20;
    private int workThreadQueue = 100;
    private String timeout;
    private String masterTimeout;
    private Integer waitForActiveShards;
    private String refresh;
    private String pipeline;
    private Object routing;
    public static final String ERROR_FILTER_PATH = "took,errors,items.*._index,items.*._type,items.*._id,items.*.status,items.*.error";
    public static final String ERROR_FILTER_PATH_ONLY = "took,errors,items.*.error";
    private String filterPath = "took,errors,items.*._index,items.*._type,items.*._id,items.*.status,items.*.error";

    public int getBulkSizes() {
        return this.bulkSizes;
    }

    public BulkConfig setBulkSizes(int bulkSizes) {
        this.bulkSizes = bulkSizes;
        return this;
    }

    public int getBulkFailRetry() {
        return this.bulkFailRetry;
    }

    public List<BulkInterceptor> getBulkInterceptors() {
        return this.bulkInterceptors;
    }

    public BulkConfig setBulkFailRetry(int bulkFailRetry) {
        this.bulkFailRetry = bulkFailRetry;
        return this;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public BulkConfig setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    public int getWorkThreads() {
        return this.workThreads;
    }

    public BulkConfig setWorkThreads(int workThreads) {
        this.workThreads = workThreads;
        return this;
    }

    public BulkConfig addBulkInterceptor(BulkInterceptor bulkInterceptor) {
        if (this.bulkInterceptors == null) {
            this.bulkInterceptors = new ArrayList<BulkInterceptor>();
        }
        this.bulkInterceptors.add(bulkInterceptor);
        return this;
    }

    public int getWorkThreadQueue() {
        return this.workThreadQueue;
    }

    public BulkConfig setWorkThreadQueue(int workThreadQueue) {
        this.workThreadQueue = workThreadQueue;
        return this;
    }

    public long getBlockedWaitTimeout() {
        return this.blockedWaitTimeout;
    }

    public BulkConfig setBlockedWaitTimeout(long blockedWaitTimeout) {
        this.blockedWaitTimeout = blockedWaitTimeout;
        return this;
    }

    public int getWarnMultsRejects() {
        return this.warnMultsRejects;
    }

    public BulkConfig setWarnMultsRejects(int warnMultsRejects) {
        this.warnMultsRejects = warnMultsRejects;
        return this;
    }

    public String getBulkProcessorName() {
        return this.bulkProcessorName;
    }

    public BulkConfig setBulkProcessorName(String bulkProcessorName) {
        this.bulkProcessorName = bulkProcessorName;
        return this;
    }

    public String getBulkRejectMessage() {
        return this.bulkRejectMessage;
    }

    public BulkConfig setBulkRejectMessage(String bulkRejectMessage) {
        this.bulkRejectMessage = bulkRejectMessage;
        return this;
    }

    public String getElasticsearch() {
        return this.elasticsearch;
    }

    public BulkConfig setElasticsearch(String elasticsearch) {
        this.elasticsearch = elasticsearch;
        return this;
    }

    @Override
    public String getRefreshOption() {
        return this.refreshOption;
    }

    public BulkConfig setRefreshOption(String refreshOption) {
        this.refreshOption = refreshOption;
        return this;
    }

    @Override
    public String getPipeline() {
        return this.pipeline;
    }

    public BulkConfig setPipeline(String pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    @Override
    public String getRefresh() {
        return this.refresh;
    }

    public BulkConfig setRefresh(String refresh) {
        this.refresh = refresh;
        return this;
    }

    @Override
    public Integer getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    public BulkConfig setWaitForActiveShards(Integer waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public String getMasterTimeout() {
        return this.masterTimeout;
    }

    public BulkConfig setMasterTimeout(String masterTimeout) {
        this.masterTimeout = masterTimeout;
        return this;
    }

    @Override
    public String getTimeout() {
        return this.timeout;
    }

    public BulkConfig setTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public Object getRouting() {
        return this.routing;
    }

    public void setRouting(Object routing) {
        this.routing = routing;
    }

    public BulkRetryHandler getBulkRetryHandler() {
        return this.bulkRetryHandler;
    }

    public void setBulkRetryHandler(BulkRetryHandler bulkRetryHandler) {
        this.bulkRetryHandler = bulkRetryHandler;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public String getFilterPath() {
        return this.filterPath;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }
}

