/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.util.SimpleStringUtil;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.ClientUtil;
import org.frameworkset.elasticsearch.client.ConfigRestClientUtil;
import org.frameworkset.elasticsearch.client.DefaultSlowDslCallback;
import org.frameworkset.elasticsearch.client.ESAddress;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.HealthCheck;
import org.frameworkset.elasticsearch.client.HostDiscover;
import org.frameworkset.elasticsearch.client.LogDslCallback;
import org.frameworkset.elasticsearch.client.NoServerElasticSearchException;
import org.frameworkset.elasticsearch.client.RestClientUtil;
import org.frameworkset.elasticsearch.client.RestSearchExecutor;
import org.frameworkset.elasticsearch.client.RoundRobinList;
import org.frameworkset.elasticsearch.handler.BaseExceptionResponseHandler;
import org.frameworkset.elasticsearch.handler.ESStringResponseHandler;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.util.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchRestClient
implements ElasticSearchClient {
    public static final String INDEX_OPERATION_NAME = "index";
    public static final String INDEX_PARAM = "_index";
    public static final String TYPE_PARAM = "_type";
    public static final String TTL_PARAM = "_ttl";
    public static final String BULK_ENDPOINT = "_bulk";
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestClient.class);
    protected final RoundRobinList serversList;
    protected Properties extendElasticsearchPropes;
    protected String httpPool;
    protected String elasticUser;
    protected String elasticPassword;
    protected long healthCheckInterval = -1L;
    protected boolean failAllContinue = true;
    protected RestSearchExecutor restSeachExecutor;
    protected boolean showTemplate = false;
    protected List<ESAddress> addressList;
    protected FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy.MM.dd", (TimeZone)TimeZone.getTimeZone("Etc/UTC"));
    protected Integer slowDslThreshold;
    protected String dateFormat = "yyyy.MM.dd";
    protected TimeZone timeZone = TimeZone.getTimeZone("Etc/UTC");
    protected boolean discoverHost = false;
    protected LogDslCallback slowDslCallback;
    protected LogDslCallback logDslCallback;
    private boolean useHttps;
    protected ElasticSearch elasticSearch;
    protected HealthCheck healthCheck = null;
    protected HostDiscover hostDiscover;
    private Map clusterInfo;
    private String esVersion;
    private boolean v1;
    private boolean lower5;
    private boolean upper7;
    private String clusterVersionInfo;
    private String clusterVarcharInfo;
    private final Map<String, ESAddress> addressMap = new HashMap<String, ESAddress>();
    private String healthPool;
    private String discoverPool;
    private boolean closed = false;

    public boolean isFailAllContinue() {
        return this.failAllContinue;
    }

    public boolean isUseHttps() {
        return this.useHttps;
    }

    public String getElasticsearchName() {
        return this.elasticSearch.getElasticSearchName();
    }

    @Override
    public ElasticSearch getElasticSearch() {
        return this.elasticSearch;
    }

    @Override
    public Integer slowDslThreshold() {
        return this.slowDslThreshold;
    }

    @Override
    public LogDslCallback getSlowDslCallback() {
        return this.slowDslCallback;
    }

    @Override
    public LogDslCallback getLogDslCallback() {
        return this.logDslCallback;
    }

    public boolean isLower5() {
        return this.lower5;
    }

    public void setLower5(boolean lower5) {
        this.lower5 = lower5;
    }

    public boolean isUpper7() {
        return this.upper7;
    }

    public void setUpper7(boolean upper7) {
        this.upper7 = upper7;
    }

    public Map<String, ESAddress> getAddressMap() {
        return this.addressMap;
    }

    public ElasticSearchRestClient(ElasticSearch elasticSearch, String[] hostNames, String elasticUser, String elasticPassword, Properties extendElasticsearchPropes) {
        this.extendElasticsearchPropes = extendElasticsearchPropes;
        this.elasticSearch = elasticSearch;
        this.addressList = new ArrayList<ESAddress>();
        for (String host : hostNames) {
            ESAddress esAddress = new ESAddress(host);
            this.addressList.add(esAddress);
            this.addressMap.put(esAddress.getAddress(), esAddress);
        }
        this.serversList = new RoundRobinList(this.addressList);
        this.elasticUser = elasticUser;
        this.elasticPassword = elasticPassword;
    }

    @Override
    public boolean containAddress(ESAddress address) {
        return this.addressMap.containsKey(address.getAddress());
    }

    @Override
    public void handleRemoved(List<ESAddress> hosts) {
        boolean hasHosts = true;
        if (hosts == null || hosts.size() == 0) {
            hasHosts = false;
        }
        for (Map.Entry<String, ESAddress> esAddressEntry : this.addressMap.entrySet()) {
            String host = esAddressEntry.getKey();
            ESAddress address = esAddressEntry.getValue();
            if (hasHosts) {
                boolean exist = false;
                for (ESAddress httpHost : hosts) {
                    if (!httpHost.toString().equals(host)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                address.setStatus(2);
                if (!logger.isInfoEnabled()) continue;
                logger.info("ElasticSearch Node[" + address.toString() + "] is down or removed.");
                continue;
            }
            address.setStatus(2);
            if (!logger.isInfoEnabled()) continue;
            logger.info("ElasticSearch Node[" + address.toString() + "] is down  or removed.");
        }
    }

    @Override
    public void addAddresses(List<ESAddress> address) {
        this.serversList.addAddresses(address);
        if (this.healthCheck != null) {
            this.healthCheck.checkNewAddresses(address);
        }
        for (ESAddress host : address) {
            this.addressMap.put(host.getAddress(), host);
        }
        if (logger.isInfoEnabled()) {
            StringBuilder info = new StringBuilder();
            info.append("All Live ElasticSearch Server:");
            Iterator<Map.Entry<String, ESAddress>> iterator = this.addressMap.entrySet().iterator();
            boolean firsted = true;
            while (iterator.hasNext()) {
                Map.Entry<String, ESAddress> esAddressEntry = iterator.next();
                String host = esAddressEntry.getKey();
                if (firsted) {
                    info.append(host);
                    firsted = false;
                    continue;
                }
                info.append(",").append(host);
            }
            logger.info(info.toString());
        }
    }

    private void initVersionInfo() {
        try {
            this.getElasticSearch().getRestClientUtil().discover("/", "get", new ResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        ElasticSearchRestClient.this.clusterVarcharInfo = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                        if (logger.isInfoEnabled()) {
                            logger.info("Elasticsearch Server Info:\n" + ElasticSearchRestClient.this.clusterVarcharInfo);
                        }
                        ElasticSearchRestClient.this.clusterInfo = (Map)SimpleStringUtil.json2Object((String)ElasticSearchRestClient.this.clusterVarcharInfo, Map.class);
                        Object version = ElasticSearchRestClient.this.clusterInfo.get("version");
                        if (version instanceof Map) {
                            String _esVersion = String.valueOf(((Map)version).get("number"));
                            if (_esVersion != null && !_esVersion.equals("")) {
                                ElasticSearchRestClient.this.esVersion = _esVersion;
                            }
                            ElasticSearchRestClient.this.clusterVersionInfo = "clusterName:" + ElasticSearchRestClient.this.clusterInfo.get("cluster_name") + ",version:" + ElasticSearchRestClient.this.esVersion;
                        } else {
                            ElasticSearchRestClient.this.clusterVersionInfo = "clusterName:" + ElasticSearchRestClient.this.clusterInfo.get("cluster_name") + ",version:" + version;
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.warn("Init Elasticsearch Cluster Version Information failed:", (Throwable)e);
        }
        if (this.esVersion != null) {
            int idx;
            if (this.esVersion.startsWith("1.")) {
                this.v1 = true;
            }
            if ((idx = this.esVersion.indexOf(".")) > 0) {
                String max = this.esVersion.substring(0, idx);
                try {
                    int v = Integer.parseInt(max);
                    if (v >= 7) {
                        this.upper7 = true;
                    }
                    if (v < 5) {
                        this.lower5 = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String getHealthPool() {
        return this.healthPool;
    }

    public boolean healthCheckEnabled() {
        return this.healthCheckInterval > 0L;
    }

    @Override
    public void init() {
        this.healthPool = this.discoverPool = ClientConfiguration.getHealthPoolName((String)this.httpPool);
        this.restSeachExecutor = new RestSearchExecutor(this.httpPool, this.discoverPool, this);
        if (this.healthCheckInterval > 0L) {
            logger.info("Start Elasticsearch healthCheck thread,you can set elasticsearch.healthCheckInterval=-1 in " + this.elasticSearch.getConfigContainerInfo() + " to disable healthCheck thread.");
            this.healthCheck = new HealthCheck(this.getElasticSearch().getElasticSearchName(), this.healthPool, this.addressList, this.healthCheckInterval);
            this.healthCheck.run();
        } else {
            logger.info("Elasticsearch healthCheck disable,you can set elasticsearch.healthCheckInterval=3000 in " + this.elasticSearch.getConfigContainerInfo() + " to enabled healthCheck thread.");
        }
        this.initVersionInfo();
        if (this.discoverHost) {
            logger.info("Start elastic discoverHost thread,to distabled set elasticsearch.discoverHost=false in " + this.elasticSearch.getConfigContainerInfo() + ".");
            HostDiscover hostDiscover = new HostDiscover(this.getElasticSearch().getElasticSearchName(), this);
            hostDiscover.start();
            this.hostDiscover = hostDiscover;
        } else {
            logger.info("Discover Elasticsearch Host is disabled,to enabled set elasticsearch.discoverHost=true  in " + this.elasticSearch.getConfigContainerInfo() + ".");
        }
    }

    @Override
    public void configure(Properties elasticsearchPropes) {
        String version_;
        String discoverHost_;
        String _slowDslCallback;
        String _logDslCallback;
        String _slowDslThreshold;
        String dateFormatString = elasticsearchPropes.getProperty("elasticsearch.dateFormat");
        String timeZoneString = elasticsearchPropes.getProperty("elasticsearch.timeZone");
        String showTemplate_ = elasticsearchPropes.getProperty("elasticsearch.showTemplate");
        String httpPool = elasticsearchPropes.getProperty("elasticsearch.httpPool");
        if (httpPool == null || httpPool.equals("")) {
            httpPool = "default";
        }
        this.httpPool = httpPool;
        if (showTemplate_ != null && showTemplate_.equals("true")) {
            this.showTemplate = true;
        }
        if (SimpleStringUtil.isEmpty((String)dateFormatString)) {
            dateFormatString = "yyyy.MM.dd";
        }
        if (SimpleStringUtil.isEmpty((String)timeZoneString)) {
            timeZoneString = "";
        }
        this.dateFormat = dateFormatString;
        this.timeZone = TimeZone.getTimeZone(timeZoneString);
        this.fastDateFormat = FastDateFormat.getInstance((String)dateFormatString, (TimeZone)TimeZone.getTimeZone(timeZoneString));
        String healthCheckInterval_ = elasticsearchPropes.getProperty("elasticsearch.healthCheckInterval");
        if (healthCheckInterval_ == null) {
            this.healthCheckInterval = 3000L;
        } else {
            try {
                this.healthCheckInterval = Long.parseLong(healthCheckInterval_);
            }
            catch (Exception e) {
                logger.error("Parse Long healthCheckInterval parameter failed:" + healthCheckInterval_, (Throwable)e);
            }
        }
        String failAllContinue_ = elasticsearchPropes.getProperty("elasticsearch.failAllContinue");
        if (failAllContinue_ != null && failAllContinue_.equals("false")) {
            this.failAllContinue = false;
        }
        if ((_slowDslThreshold = elasticsearchPropes.getProperty("elasticsearch.slowDslThreshold")) != null) {
            try {
                this.slowDslThreshold = Integer.parseInt(_slowDslThreshold);
            }
            catch (Exception e) {
                logger.error("Parse Long slowDslThreshold parameter failed:" + _slowDslThreshold, (Throwable)e);
            }
        }
        if ((_logDslCallback = elasticsearchPropes.getProperty("elasticsearch.logDslCallback")) != null) {
            try {
                this.logDslCallback = (LogDslCallback)Class.forName(_logDslCallback).newInstance();
            }
            catch (Exception e) {
                logger.error("Parse logDslCallback parameter failed:" + _logDslCallback, (Throwable)e);
            }
            catch (Throwable e) {
                logger.error("Parse logDslCallback parameter failed:" + _logDslCallback, e);
            }
        }
        if ((_slowDslCallback = elasticsearchPropes.getProperty("elasticsearch.slowDslCallback")) != null) {
            try {
                this.slowDslCallback = (LogDslCallback)Class.forName(_slowDslCallback).newInstance();
            }
            catch (Exception e) {
                logger.error("Parse slowDslCallback parameter failed:" + _slowDslCallback, (Throwable)e);
            }
            catch (Throwable e) {
                logger.error("Parse slowDslCallback parameter failed:" + _slowDslCallback, e);
            }
        } else {
            this.slowDslCallback = new DefaultSlowDslCallback();
        }
        if ((discoverHost_ = elasticsearchPropes.getProperty("elasticsearch.discoverHost")) != null && !discoverHost_.equals("")) {
            try {
                this.discoverHost = Boolean.parseBoolean(discoverHost_);
            }
            catch (Exception e) {
                logger.error("Parse Boolean discoverHost parameter failed:" + discoverHost_, (Throwable)e);
            }
        }
        this.esVersion = (version_ = elasticsearchPropes.getProperty("elasticsearch.version")) != null && !version_.equals("") ? version_ : "7.0.0";
        String useHttps_ = elasticsearchPropes.getProperty("elasticsearch.useHttps");
        if (useHttps_ != null && !useHttps_.equals("")) {
            try {
                this.useHttps = Boolean.parseBoolean(useHttps_);
            }
            catch (Exception e) {
                logger.error("Parse Boolean useHttps parameter failed:" + useHttps_, (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.hostDiscover != null) {
            this.hostDiscover.stopCheck();
            this.hostDiscover = null;
        }
        if (this.healthCheck != null) {
            this.healthCheck.stopCheck();
            this.healthCheck = null;
        }
        ClientConfiguration.stopHttpClient((String)this.httpPool);
    }

    private ElasticSearchException handleConnectionPoolTimeOutException(ConnectionPoolTimeoutException ex) {
        ClientConfiguration configuration = ClientConfiguration.getClientConfiguration((String)this.httpPool);
        if (configuration == null) {
            return new ElasticSearchException(ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Wait timeout for ").append(configuration.getConnectionRequestTimeout()).append("ms for idle http connection from http connection pool.");
        return new ElasticSearchException(builder.toString(), ex);
    }

    private NoServerElasticSearchException handleConnectionTimeOutException(ConnectTimeoutException ex) {
        ClientConfiguration configuration = ClientConfiguration.getClientConfiguration((String)this.httpPool);
        if (configuration == null) {
            return new NoServerElasticSearchException(ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Build a http connection timeout for ").append(configuration.getTimeoutConnection()).append("ms.");
        return new NoServerElasticSearchException(builder.toString(), ex);
    }

    private ElasticSearchException handleSocketTimeoutException(SocketTimeoutException ex) {
        ClientConfiguration configuration = ClientConfiguration.getClientConfiguration((String)this.httpPool);
        if (configuration == null) {
            return new ElasticSearchException(ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Socket Timeout for ").append(configuration.getTimeoutSocket()).append("ms.");
        return new ElasticSearchException(builder.toString(), ex);
    }

    public String execute(final String entity, String options) throws ElasticSearchException {
        String endpoint = BULK_ENDPOINT;
        if (options != null) {
            endpoint = endpoint + "?" + options;
        }
        final ESStringResponseHandler responseHandler = new ESStringResponseHandler();
        return (String)this._executeHttp(endpoint, (ResponseHandler)responseHandler, new ExecuteRequest(){

            @Override
            public Object execute(ESAddress host, String url, int triesCount) throws Exception {
                String response = null;
                if (ElasticSearchRestClient.this.showTemplate && logger.isInfoEnabled()) {
                    logger.info("ElasticSearch http request endpoint:{},retry:{},request body:\n{}", new Object[]{url, triesCount, entity});
                }
                response = ElasticSearchRestClient.this.restSeachExecutor.execute(url, entity, responseHandler);
                return response;
            }
        });
    }

    @Override
    public ClientUtil getClientUtil(IndexNameBuilder indexNameBuilder) {
        return new RestClientUtil(this, indexNameBuilder);
    }

    @Override
    public ClientUtil getConfigClientUtil(IndexNameBuilder indexNameBuilder, String configFile) {
        return new ConfigRestClientUtil(this, indexNameBuilder, configFile);
    }

    @Override
    public ClientUtil getConfigClientUtil(IndexNameBuilder indexNameBuilder, BaseTemplateContainerImpl templateContainer) {
        return new ConfigRestClientUtil(templateContainer, this, indexNameBuilder);
    }

    public String executeHttp(String path, String action) throws ElasticSearchException {
        return this.executeHttp(path, null, action);
    }

    public <T> T executeHttp(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.executeHttp(path, null, action, responseHandler);
    }

    public <T> T discover(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.discover(path, null, action, responseHandler);
    }

    private String getPath(String host, String path) {
        String url = path.equals("") || path.startsWith("/") ? host + path : host + "/" + path;
        return url;
    }

    public <T> T executeHttp(String path, String entity, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this._executeHttp(path, entity, action, responseHandler, false);
    }

    private <T> T _executeHttp(String path, final String entity, final String action, final ResponseHandler<T> responseHandler, final boolean discoverHost) throws ElasticSearchException {
        return this._executeHttp(path, responseHandler, new ExecuteRequest(){

            @Override
            public Object execute(ESAddress host, String url, int triesCount) throws Exception {
                Object response = null;
                if (!discoverHost) {
                    if (ElasticSearchRestClient.this.showTemplate && !discoverHost && logger.isInfoEnabled()) {
                        if (entity != null) {
                            logger.info("ElasticSearch http request endpoint:{},retry:{},request body:\n{}", new Object[]{url, triesCount, entity});
                        } else {
                            logger.info("ElasticSearch http request endpoint:{},retry:{}", (Object)url, (Object)triesCount);
                        }
                    }
                    response = ElasticSearchRestClient.this.restSeachExecutor.executeHttp(url, entity, action, responseHandler);
                } else {
                    response = ElasticSearchRestClient.this.restSeachExecutor.discoverHost(url, entity, action, responseHandler);
                }
                return response;
            }
        });
    }

    private <T> T _executeHttp(String path, ResponseHandler<T> responseHandler, ExecuteRequest executeRequest) throws ElasticSearchException {
        int triesCount = 0;
        Object response = null;
        Throwable e = null;
        ESAddress host = null;
        String url = null;
        while (true) {
            try {
                host = this.serversList.get(this.failAllContinue || !this.healthCheckEnabled());
                url = this.getPath(host.getAddress(), path);
                if (responseHandler != null && responseHandler instanceof BaseExceptionResponseHandler) {
                    ((BaseExceptionResponseHandler)responseHandler).clean();
                }
                response = executeRequest.execute(host, url, triesCount);
                host.recover();
                e = this.getException(responseHandler);
            }
            catch (HttpHostConnectException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size() - 1) break;
                ++triesCount;
                continue;
            }
            catch (UnknownHostException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size() - 1) break;
                ++triesCount;
                continue;
            }
            catch (NoRouteToHostException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size() - 1) break;
                ++triesCount;
                continue;
            }
            catch (NoHttpResponseException ex) {
                host.setStatus(1);
                e = new NoServerElasticSearchException(ex);
                if (triesCount >= this.serversList.size() - 1) break;
                ++triesCount;
                continue;
            }
            catch (ConnectionPoolTimeoutException ex) {
                if (host.failedCheck()) {
                    host.onlySetStatus(0);
                }
                e = this.handleConnectionPoolTimeOutException(ex);
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                host.setStatus(1);
                e = this.handleConnectionTimeOutException(connectTimeoutException);
                if (triesCount >= this.serversList.size() - 1) break;
                ++triesCount;
                continue;
            }
            catch (SocketTimeoutException ex) {
                if (host.failedCheck()) {
                    host.onlySetStatus(0);
                }
                e = this.handleSocketTimeoutException(ex);
            }
            catch (NoServerElasticSearchException ex) {
                e = ex;
            }
            catch (ClientProtocolException ex) {
                host.setStatus(1);
                e = ex;
                if (triesCount >= this.serversList.size() - 1) break;
                ++triesCount;
                continue;
            }
            catch (ElasticSearchException ex) {
                if (host.failedCheck()) {
                    host.onlySetStatus(0);
                }
                e = ex;
            }
            catch (Exception ex) {
                if (host.failedCheck()) {
                    host.onlySetStatus(0);
                }
                e = ex;
            }
            catch (Throwable ex) {
                if (host.failedCheck()) {
                    host.onlySetStatus(0);
                }
                e = ex;
            }
            break;
        }
        if (e != null) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e);
        }
        return (T)response;
    }

    public <T> T discover(String path, String entity, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this._executeHttp(path, entity, action, responseHandler, true);
    }

    public String executeHttp(String path, String entity, String action) throws ElasticSearchException {
        return (String)this.executeHttp(path, entity, action, (ResponseHandler)new ESStringResponseHandler());
    }

    public String executeRequest(String path, final String entity) throws ElasticSearchException {
        final ESStringResponseHandler responseHandler = new ESStringResponseHandler();
        return (String)this._executeHttp(path, (ResponseHandler)responseHandler, new ExecuteRequest(){

            @Override
            public Object execute(ESAddress host, String url, int triesCount) throws Exception {
                String response = null;
                if (ElasticSearchRestClient.this.showTemplate && logger.isInfoEnabled()) {
                    if (entity != null) {
                        logger.info("ElasticSearch http request endpoint:{},retry:{},request body:\n{}", new Object[]{url, triesCount, entity});
                    } else {
                        logger.info("ElasticSearch http request endpoint:{},retry:{}", (Object)url, (Object)triesCount);
                    }
                }
                response = ElasticSearchRestClient.this.restSeachExecutor.executeSimpleRequest(url, entity, responseHandler);
                return response;
            }
        });
    }

    public <T> T executeRequest(String path, String entity, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.executeRequest(path, entity, responseHandler, "post");
    }

    private Exception getException(ResponseHandler responseHandler) {
        if (responseHandler instanceof BaseExceptionResponseHandler) {
            return ((BaseExceptionResponseHandler)responseHandler).getElasticSearchException();
        }
        return null;
    }

    public <T> T executeRequest(String path, final String entity, final ResponseHandler<T> responseHandler, final String action) throws ElasticSearchException {
        return this._executeHttp(path, responseHandler, new ExecuteRequest(){

            @Override
            public Object execute(ESAddress host, String url, int triesCount) throws Exception {
                Object response = null;
                if (ElasticSearchRestClient.this.showTemplate && logger.isInfoEnabled()) {
                    if (entity != null) {
                        logger.info("ElasticSearch http request endpoint:{},retry:{},request body:\n{}", new Object[]{url, triesCount, entity});
                    } else {
                        logger.info("ElasticSearch http request endpoint:{},retry:{}", (Object)url, (Object)triesCount);
                    }
                }
                response = ElasticSearchRestClient.this.restSeachExecutor.executeRequest(url, entity, action, responseHandler);
                return response;
            }
        });
    }

    public FastDateFormat getFastDateFormat() {
        return this.fastDateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isShowTemplate() {
        return this.showTemplate;
    }

    @Override
    public void setShowTemplate(boolean showTemplate) {
        this.showTemplate = showTemplate;
    }

    @Override
    public void recoverRemovedNodes(List<ESAddress> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return;
        }
        for (ESAddress httpHost : hosts) {
            ESAddress address = this.addressMap.get(httpHost.toString());
            if (address == null || address.getStatus() != 2) continue;
            address.onlySetStatus(0);
            if (!logger.isInfoEnabled()) continue;
            logger.info("Recover Removed Node [" + address.toString() + "] to clusters addresses list.");
        }
    }

    @Override
    public Map getClusterInfo() {
        return this.clusterInfo;
    }

    @Override
    public String getClusterVarcharInfo() {
        return this.clusterVarcharInfo;
    }

    @Override
    public String getClusterVersionInfo() {
        return this.clusterVersionInfo;
    }

    public ExecutorService getSliceScrollQueryExecutorService() {
        return this.elasticSearch.getSliceScrollQueryExecutorService();
    }

    public ExecutorService getScrollQueryExecutorService() {
        return this.elasticSearch.getScrollQueryExecutorService();
    }

    @Override
    public boolean isV1() {
        return this.v1;
    }

    public String getEsVersion() {
        return this.esVersion;
    }

    public void setEsVersion(String esVersion) {
        this.esVersion = esVersion;
    }

    public String getDiscoverPool() {
        return this.discoverPool;
    }

    private static interface ExecuteRequest {
        public Object execute(ESAddress var1, String var2, int var3) throws Exception;
    }
}

