/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch;

import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.client.RestClientUtil;
import org.frameworkset.elasticsearch.scroll.ParallelSliceScrollResult;
import org.frameworkset.elasticsearch.serial.SerialContext;

public class SliceRunTask<T>
implements Runnable {
    private int sliceId;
    private String path;
    private String sliceDsl;
    private String scroll;
    private Class<T> type;
    private ParallelSliceScrollResult sliceScrollResult;
    private RestClientUtil restClientUtil;
    private SerialContext serialContext;

    public SliceRunTask(RestClientUtil restClientUtil, int sliceId, String path, String sliceDsl, String scroll, Class<T> type, ParallelSliceScrollResult sliceScrollResult, SerialContext serialContext) {
        this.restClientUtil = restClientUtil;
        this.sliceId = sliceId;
        this.path = path;
        this.sliceDsl = sliceDsl;
        this.scroll = scroll;
        this.type = type;
        this.sliceScrollResult = sliceScrollResult;
        this.serialContext = serialContext;
    }

    @Override
    public void run() {
        try {
            if (this.serialContext != null) {
                this.serialContext.continueSerialTypes();
            }
            this.restClientUtil._doSliceScroll(this.sliceId, this.path, this.sliceDsl, this.scroll, this.type, this.sliceScrollResult, true);
        }
        catch (ElasticSearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ElasticSearchException("slice query task[" + this.sliceId + "] failed:", e);
        }
        finally {
            if (this.serialContext != null) {
                this.serialContext.clean();
            }
        }
    }
}

