/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.Date;
import java.util.Map;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.RestSearchExecutorUtil;
import org.frameworkset.elasticsearch.entity.SlowDsl;
import org.frameworkset.elasticsearch.handler.ESStringResponseHandler;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSearchExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RestSearchExecutor.class);
    private String httpPool;
    private ElasticSearchClient elasticSearchClient;
    private String discoverHttpPool;

    public RestSearchExecutor(String httpPool, String discoverHttpPool, ElasticSearchClient elasticSearchClient) {
        this.httpPool = httpPool;
        this.discoverHttpPool = discoverHttpPool;
        this.elasticSearchClient = elasticSearchClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String url, String entity, ESStringResponseHandler responseHandler) throws Exception {
        String string;
        Integer slowDslThreshold = this.elasticSearchClient.slowDslThreshold();
        if (slowDslThreshold == null) {
            String response = (String)HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, (Map)null, (ResponseHandler)responseHandler);
            return response;
        }
        long start = System.currentTimeMillis();
        try {
            String response;
            string = response = (String)HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, (Map)null, (ResponseHandler)responseHandler);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            long time = end - start;
            if (time > (long)slowDslThreshold.intValue()) {
                if (this.elasticSearchClient.getSlowDslCallback() == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Slow request[{}] took time:{} ms > slowDslThreshold[{} ms], use DSL[{}]", new Object[]{url, time, (int)slowDslThreshold, RestSearchExecutorUtil.chunkEntity(entity)});
                    }
                } else {
                    SlowDsl slowDsl = new SlowDsl();
                    slowDsl.setUrl(url);
                    slowDsl.setTime(time);
                    slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
                    slowDsl.setEntity(entity);
                    slowDsl.setStartTime(new Date(start));
                    slowDsl.setEndTime(new Date(end));
                    this.elasticSearchClient.getSlowDslCallback().slowDslHandle(slowDsl);
                }
            }
            throw throwable;
        }
        long end = System.currentTimeMillis();
        long time = end - start;
        if (time > (long)slowDslThreshold.intValue()) {
            if (this.elasticSearchClient.getSlowDslCallback() == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Slow request[{}] took time:{} ms > slowDslThreshold[{} ms], use DSL[{}]", new Object[]{url, time, (int)slowDslThreshold, RestSearchExecutorUtil.chunkEntity(entity)});
                }
            } else {
                SlowDsl slowDsl = new SlowDsl();
                slowDsl.setUrl(url);
                slowDsl.setTime(time);
                slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
                slowDsl.setEntity(entity);
                slowDsl.setStartTime(new Date(start));
                slowDsl.setEndTime(new Date(end));
                this.elasticSearchClient.getSlowDslCallback().slowDslHandle(slowDsl);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeHttp(String url, String entity, String action, ResponseHandler<T> responseHandler) throws Exception {
        T t;
        Integer slowDslThreshold = this.elasticSearchClient.slowDslThreshold();
        if (slowDslThreshold == null) {
            return RestSearchExecutorUtil.__executeHttp(this.httpPool, null, url, entity, action, responseHandler);
        }
        long start = System.currentTimeMillis();
        try {
            t = RestSearchExecutorUtil.__executeHttp(this.httpPool, null, url, entity, action, responseHandler);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            long time = end - start;
            if (time > (long)slowDslThreshold.intValue()) {
                if (this.elasticSearchClient.getSlowDslCallback() == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Slow request[{}] action[{}] took time:{} ms > slowDslThreshold[{} ms], use DSL[{}]", new Object[]{url, action, time, (int)slowDslThreshold, RestSearchExecutorUtil.chunkEntity(entity)});
                    }
                } else {
                    SlowDsl slowDsl = new SlowDsl();
                    slowDsl.setUrl(url);
                    slowDsl.setAction(action);
                    slowDsl.setTime(time);
                    slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
                    slowDsl.setEntity(entity);
                    slowDsl.setStartTime(new Date(start));
                    slowDsl.setEndTime(new Date(end));
                    this.elasticSearchClient.getSlowDslCallback().slowDslHandle(slowDsl);
                }
            }
            throw throwable;
        }
        long end = System.currentTimeMillis();
        long time = end - start;
        if (time > (long)slowDslThreshold.intValue()) {
            if (this.elasticSearchClient.getSlowDslCallback() == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Slow request[{}] action[{}] took time:{} ms > slowDslThreshold[{} ms], use DSL[{}]", new Object[]{url, action, time, (int)slowDslThreshold, RestSearchExecutorUtil.chunkEntity(entity)});
                }
            } else {
                SlowDsl slowDsl = new SlowDsl();
                slowDsl.setUrl(url);
                slowDsl.setAction(action);
                slowDsl.setTime(time);
                slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
                slowDsl.setEntity(entity);
                slowDsl.setStartTime(new Date(start));
                slowDsl.setEndTime(new Date(end));
                this.elasticSearchClient.getSlowDslCallback().slowDslHandle(slowDsl);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T discoverHost(String url, String entity, String action, ResponseHandler<T> responseHandler) throws Exception {
        T t;
        Integer slowDslThreshold = this.elasticSearchClient.slowDslThreshold();
        if (slowDslThreshold == null) {
            return RestSearchExecutorUtil.__executeHttp(this.discoverHttpPool, null, url, entity, action, responseHandler);
        }
        long start = System.currentTimeMillis();
        try {
            t = RestSearchExecutorUtil.__executeHttp(this.discoverHttpPool, null, url, entity, action, responseHandler);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            long time = end - start;
            if (time > (long)slowDslThreshold.intValue()) {
                if (this.elasticSearchClient.getSlowDslCallback() == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Slow request[{}] action[{}] took time:{} ms > slowDslThreshold[{} ms], use DSL[{}]", new Object[]{url, action, time, (int)slowDslThreshold, RestSearchExecutorUtil.chunkEntity(entity)});
                    }
                } else {
                    SlowDsl slowDsl = new SlowDsl();
                    slowDsl.setUrl(url);
                    slowDsl.setAction(action);
                    slowDsl.setTime(time);
                    slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
                    slowDsl.setEntity(entity);
                    slowDsl.setStartTime(new Date(start));
                    slowDsl.setEndTime(new Date(end));
                    this.elasticSearchClient.getSlowDslCallback().slowDslHandle(slowDsl);
                }
            }
            throw throwable;
        }
        long end = System.currentTimeMillis();
        long time = end - start;
        if (time > (long)slowDslThreshold.intValue()) {
            if (this.elasticSearchClient.getSlowDslCallback() == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Slow request[{}] action[{}] took time:{} ms > slowDslThreshold[{} ms], use DSL[{}]", new Object[]{url, action, time, (int)slowDslThreshold, RestSearchExecutorUtil.chunkEntity(entity)});
                }
            } else {
                SlowDsl slowDsl = new SlowDsl();
                slowDsl.setUrl(url);
                slowDsl.setAction(action);
                slowDsl.setTime(time);
                slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
                slowDsl.setEntity(entity);
                slowDsl.setStartTime(new Date(start));
                slowDsl.setEndTime(new Date(end));
                this.elasticSearchClient.getSlowDslCallback().slowDslHandle(slowDsl);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeSimpleRequest(String url, String entity, ESStringResponseHandler responseHandler) throws Exception {
        String string;
        Integer slowDslThreshold = this.elasticSearchClient.slowDslThreshold();
        if (slowDslThreshold == null) {
            String response = null;
            response = entity == null ? (String)HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, (Map)null, (ResponseHandler)responseHandler) : (String)HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, (Map)null, (ResponseHandler)responseHandler);
            return response;
        }
        long start = System.currentTimeMillis();
        try {
            String response = null;
            response = entity == null ? (String)HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, (Map)null, (ResponseHandler)responseHandler) : (String)HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, (Map)null, (ResponseHandler)responseHandler);
            string = response;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            long time = end - start;
            if (time > (long)slowDslThreshold.intValue()) {
                if (this.elasticSearchClient.getSlowDslCallback() == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Slow request[{}] took time:{} ms > slowDslThreshold[{} ms], use DSL[{}]", new Object[]{url, time, (int)slowDslThreshold, RestSearchExecutorUtil.chunkEntity(entity)});
                    }
                } else {
                    SlowDsl slowDsl = new SlowDsl();
                    slowDsl.setUrl(url);
                    slowDsl.setTime(time);
                    slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
                    slowDsl.setEntity(entity);
                    slowDsl.setStartTime(new Date(start));
                    slowDsl.setEndTime(new Date(end));
                    this.elasticSearchClient.getSlowDslCallback().slowDslHandle(slowDsl);
                }
            }
            throw throwable;
        }
        long end = System.currentTimeMillis();
        long time = end - start;
        if (time > (long)slowDslThreshold.intValue()) {
            if (this.elasticSearchClient.getSlowDslCallback() == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Slow request[{}] took time:{} ms > slowDslThreshold[{} ms], use DSL[{}]", new Object[]{url, time, (int)slowDslThreshold, RestSearchExecutorUtil.chunkEntity(entity)});
                }
            } else {
                SlowDsl slowDsl = new SlowDsl();
                slowDsl.setUrl(url);
                slowDsl.setTime(time);
                slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
                slowDsl.setEntity(entity);
                slowDsl.setStartTime(new Date(start));
                slowDsl.setEndTime(new Date(end));
                this.elasticSearchClient.getSlowDslCallback().slowDslHandle(slowDsl);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeRequest(String url, String entity, String action, ResponseHandler<T> responseHandler) throws Exception {
        T t;
        Integer slowDslThreshold = this.elasticSearchClient.slowDslThreshold();
        if (slowDslThreshold == null) {
            return RestSearchExecutorUtil._executeRequest(this.httpPool, null, url, entity, action, responseHandler);
        }
        long start = System.currentTimeMillis();
        try {
            t = RestSearchExecutorUtil._executeRequest(this.httpPool, null, url, entity, action, responseHandler);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            long time = end - start;
            if (time > (long)slowDslThreshold.intValue()) {
                if (this.elasticSearchClient.getSlowDslCallback() == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Slow request[{}] action[{}] took time:{} ms > slowDslThreshold[{} ms],use DSL[{}] ", new Object[]{url, action, time, (int)slowDslThreshold, RestSearchExecutorUtil.chunkEntity(entity)});
                    }
                } else {
                    SlowDsl slowDsl = new SlowDsl();
                    slowDsl.setUrl(url);
                    slowDsl.setAction(action);
                    slowDsl.setTime(time);
                    slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
                    slowDsl.setEntity(entity);
                    slowDsl.setStartTime(new Date(start));
                    slowDsl.setEndTime(new Date(end));
                    this.elasticSearchClient.getSlowDslCallback().slowDslHandle(slowDsl);
                }
            }
            throw throwable;
        }
        long end = System.currentTimeMillis();
        long time = end - start;
        if (time > (long)slowDslThreshold.intValue()) {
            if (this.elasticSearchClient.getSlowDslCallback() == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Slow request[{}] action[{}] took time:{} ms > slowDslThreshold[{} ms],use DSL[{}] ", new Object[]{url, action, time, (int)slowDslThreshold, RestSearchExecutorUtil.chunkEntity(entity)});
                }
            } else {
                SlowDsl slowDsl = new SlowDsl();
                slowDsl.setUrl(url);
                slowDsl.setAction(action);
                slowDsl.setTime(time);
                slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
                slowDsl.setEntity(entity);
                slowDsl.setStartTime(new Date(start));
                slowDsl.setEndTime(new Date(end));
                this.elasticSearchClient.getSlowDslCallback().slowDslHandle(slowDsl);
            }
        }
        return t;
    }

    public String getClusterVersionInfo() {
        return this.elasticSearchClient.getClusterVersionInfo();
    }
}

