/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.RestClientUtil;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.elasticsearch.client.SliceScroll;
import org.frameworkset.elasticsearch.entity.AggHit;
import org.frameworkset.elasticsearch.entity.ESAggDatas;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.MapRestResponse;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.entity.sql.SQLRestResponse;
import org.frameworkset.elasticsearch.entity.sql.SQLRestResponseHandler;
import org.frameworkset.elasticsearch.entity.sql.SQLResult;
import org.frameworkset.elasticsearch.entity.suggest.CompleteRestResponse;
import org.frameworkset.elasticsearch.entity.suggest.PhraseRestResponse;
import org.frameworkset.elasticsearch.entity.suggest.TermRestResponse;
import org.frameworkset.elasticsearch.handler.ESAggBucketHandle;
import org.frameworkset.elasticsearch.handler.ESMapResponseHandler;
import org.frameworkset.elasticsearch.handler.ElasticSearchResponseHandler;
import org.frameworkset.elasticsearch.scroll.ScrollHandler;
import org.frameworkset.elasticsearch.scroll.SliceScrollResult;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.elasticsearch.template.ESTemplateHelper;
import org.frameworkset.elasticsearch.template.ESUtil;
import org.frameworkset.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRestClientUtil
extends RestClientUtil {
    private static Logger logger = LoggerFactory.getLogger(ConfigRestClientUtil.class);
    private static String java_date_format = "yyyy-MM-dd HH:mm:ss";
    private String configFile;
    private ESUtil esUtil = null;

    public ConfigRestClientUtil(ElasticSearchClient client, IndexNameBuilder indexNameBuilder, String configFile) {
        super(client, indexNameBuilder);
        this.configFile = configFile;
        this.esUtil = ESUtil.getInstance(client.getElasticSearch().getDslMappingDir(), configFile);
    }

    public ConfigRestClientUtil(BaseTemplateContainerImpl templateContainer, ElasticSearchClient client, IndexNameBuilder indexNameBuilder) {
        super(client, indexNameBuilder);
        this.esUtil = ESUtil.getInstance(templateContainer);
    }

    @Override
    public String reindexByDsl(String actionUrl, String dslName, Object params) {
        return this.client.executeHttp(actionUrl, ESTemplateHelper.evalTemplate(this.esUtil, dslName, params), "post");
    }

    @Override
    public String reindexByDsl(String actionUrl, String dslName) {
        return this.client.executeHttp(actionUrl, ESTemplateHelper.evalTemplate(this.esUtil, dslName, null), "post");
    }

    @Override
    public Object executeRequest(String path) throws ElasticSearchException {
        return this.executeRequest(path, null);
    }

    public Object execute(String options) throws ElasticSearchException {
        return this.client.execute(this.bulkBuilder.toString(), options);
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(indexName, indexType, addTemplate, beans, null);
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (Object bean : beans) {
            ESTemplateHelper.evalBuilkTemplate(this.esUtil, builder, indexName, indexType, addTemplate, bean, "index", this.client.isUpper7());
        }
        if (refreshOption == null) {
            return this.client.executeHttp("_bulk", builder.toString(), "post");
        }
        return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (Object bean : beans) {
            ESTemplateHelper.evalBuilkTemplate(this.esUtil, builder, indexName, indexType, updateTemplate, bean, "update", this.client.isUpper7());
        }
        return this.client.executeHttp("_bulk", builder.toString(), "post");
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (Object bean : beans) {
            ESTemplateHelper.evalBuilkTemplate(this.esUtil, builder, indexName, indexType, updateTemplate, bean, "update", this.client.isUpper7());
        }
        return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, beans);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, beans, refreshOption);
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, addTemplate, bean, null);
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(bean.getClass());
        Object id = BuildTool.getId(bean, classInfo);
        Object routing = BuildTool.getRouting(bean, classInfo);
        builder.append(indexName).append("/").append(indexType);
        if (id != null) {
            builder.append("/").append(id);
        }
        Object parentId = BuildTool.getParentId(bean, classInfo);
        if (refreshOption != null) {
            builder.append("?").append(refreshOption);
            if (parentId != null) {
                builder.append("&parent=").append(parentId);
            }
            if (routing != null) {
                builder.append("&routing=").append(routing);
            }
        } else if (parentId != null) {
            builder.append("?parent=").append(parentId);
            if (routing != null) {
                builder.append("&routing=").append(routing);
            }
        } else if (routing != null) {
            builder.append("?routing=").append(routing);
        }
        String path = builder.toString();
        builder.setLength(0);
        path = this.client.executeHttp(path, ESTemplateHelper.evalDocumentTemplate(this.esUtil, builder, indexType, indexName, addTemplate, bean, "create"), "post");
        builder = null;
        return path;
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, bean);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, bean, refreshOption);
    }

    @Override
    public String executeRequest(String path, String templateName) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null));
    }

    @Override
    public String executeRequest(String path, String templateName, Map params) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public String executeRequest(String path, String templateName, Object params) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Map params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), responseHandler);
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Object params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), responseHandler);
    }

    @Override
    public String deleteByQuery(String path, String templateName) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), "post");
    }

    @Override
    public String deleteByQuery(String path, String templateName, Map params) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), "post");
    }

    @Override
    public String deleteByQuery(String path, String templateName, Object params) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), "post");
    }

    @Override
    public String executeHttp(String path, String templateName, String action) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), action);
    }

    @Override
    public <T> T executeHttp(String path, String templateName, String action, Map params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), action, responseHandler);
    }

    @Override
    public String executeHttp(String path, String templateName, Map params, String action) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), action);
    }

    @Override
    public <T> T executeHttp(String path, String templateName, String action, Object bean, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, bean), action, responseHandler);
    }

    @Override
    public <T> T executeHttp(String path, String templateName, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), action, responseHandler);
    }

    @Override
    public String executeHttp(String path, String templateName, Object bean, String action) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, bean), action);
    }

    @Override
    public <T> T executeRequest(String path, String templateName, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), responseHandler);
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String templateName, Map params) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), new SQLRestResponseHandler());
        return ResultUtil.buildSQLResult(result, beanType);
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String templateName, Object bean) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.esUtil, templateName, bean), new SQLRestResponseHandler());
        return ResultUtil.buildSQLResult(result, beanType);
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String templateName) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), new SQLRestResponseHandler());
        return ResultUtil.buildSQLResult(result, beanType);
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String templateName, Map params) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, (SQLResult)null);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String templateName, Object bean) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.esUtil, templateName, bean), new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, (SQLResult)null);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String templateName) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, (SQLResult)null);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String templateName, Map params) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), new SQLRestResponseHandler());
        return ResultUtil.buildSQLObject(result, beanType);
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String templateName, Object bean) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.esUtil, templateName, bean), new SQLRestResponseHandler());
        return ResultUtil.buildSQLObject(result, beanType);
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String templateName) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), new SQLRestResponseHandler());
        return ResultUtil.buildSQLObject(result, beanType);
    }

    @Override
    public MapRestResponse search(String path, String templateName, Map params) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public MapRestResponse search(String path, String templateName, Object params) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public MapRestResponse search(String path, String templateName) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null));
    }

    @Override
    public long count(String index, String templateName) throws ElasticSearchException {
        return super.count(index, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null));
    }

    @Override
    public long count(String index, String templateName, Map params) throws ElasticSearchException {
        return super.count(index, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public long count(String index, String templateName, Object params) throws ElasticSearchException {
        return super.count(index, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, Class<?> type) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, Class<?> type) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Class<?> type) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), type);
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return super.searchList(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return super.searchList(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Class<T> type) throws ElasticSearchException {
        return super.searchList(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), type);
    }

    @Override
    public <T> T searchObject(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return super.searchObject(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public <T> T searchObject(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return super.searchObject(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public <T> T searchObject(String path, String templateName, Class<T> type) throws ElasticSearchException {
        return super.searchObject(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, ESTypeReferences type) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, ESTypeReferences type) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, ESTypeReferences type) throws ElasticSearchException {
        return (RestResponse)this.client.executeRequest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), new ElasticSearchResponseHandler((ESTypeReferences<?, ?>)type));
    }

    @Override
    public String updateIndiceMapping(String action, String templateName) throws ElasticSearchException {
        return super.updateIndiceMapping(action, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null));
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName) throws ElasticSearchException {
        return super.createIndiceMapping(indexName, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null));
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Object parameter) throws ElasticSearchException {
        return super.updateIndiceMapping(action, ESTemplateHelper.evalTemplate(this.esUtil, templateName, parameter));
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Object parameter) throws ElasticSearchException {
        return super.createIndiceMapping(indexName, ESTemplateHelper.evalTemplate(this.esUtil, templateName, parameter));
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Map parameter) throws ElasticSearchException {
        return super.updateIndiceMapping(action, ESTemplateHelper.evalTemplate(this.esUtil, templateName, parameter));
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Map parameter) throws ElasticSearchException {
        return super.createIndiceMapping(indexName, ESTemplateHelper.evalTemplate(this.esUtil, templateName, parameter));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Map params) throws ElasticSearchException {
        return super.searchMap(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Object params) throws ElasticSearchException {
        return super.searchMap(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName) throws ElasticSearchException {
        return (Map)super.executeRequest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), new ESMapResponseHandler());
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Map params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type, aggs, stats);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Object params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type, aggs, stats);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), type, aggs, stats);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Map params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type, aggs, stats, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Object params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type, aggs, stats, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), type, aggs, stats, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Map params, Class<T> type, String aggs) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type, aggs);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Object params, Class<T> type, String aggs) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type, aggs);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Class<T> type, String aggs) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), type, aggs);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Map params, Class<T> type, String aggs, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type, aggs, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Object params, Class<T> type, String aggs, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type, aggs, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Class<T> type, String aggs, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), type, aggs, aggBucketHandle);
    }

    @Override
    public String createTempate(String template, String templateName) throws ElasticSearchException {
        return super.createTempate(template, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null));
    }

    @Override
    public String createTempate(String template, String templateName, Object params) throws ElasticSearchException {
        return super.createTempate(template, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public String createTempate(String template, String templateName, Map params) throws ElasticSearchException {
        return super.createTempate(template, ESTemplateHelper.evalTemplate(this.esUtil, templateName, (Object)params));
    }

    @Override
    public TermRestResponse termSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return super.termSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return super.phraseSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public TermRestResponse termSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return super.termSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public TermRestResponse termSuggest(String path, String templateName) throws ElasticSearchException {
        return super.termSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null));
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return super.phraseSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String templateName) throws ElasticSearchException {
        return super.phraseSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null));
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Object params, Class<?> type) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Class<?> type) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), type);
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Map params, Class<?> type) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null));
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params));
    }

    @Override
    public String updateByPath(String path, String templateName) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), "post");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    @Override
    public String updateByPath(String path, String templateName, Map params) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), "post");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    @Override
    public String updateByPath(String path, String templateName, Object params) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), "post");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    @Override
    public String updateByQuery(String path, String templateName) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), "post");
    }

    @Override
    public String updateByQuery(String path, String templateName, Map params) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), "post");
    }

    @Override
    public String updateByQuery(String path, String templateName, Object params) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), "post");
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String templateName, Class<T> type) throws ElasticSearchException {
        return super.mgetDocuments(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, null), type);
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return super.mgetDocuments(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return super.mgetDocuments(path, ESTemplateHelper.evalTemplate(this.esUtil, templateName, params), type);
    }

    @Override
    public ESInfo getESInfo(String templateName) {
        return this.esUtil.getESInfo(templateName);
    }

    @Override
    public <T> ESDatas<T> scrollSliceParallel(String path, final String dslTemplate, final Map params, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        Integer mx = (Integer)params.get("sliceMax");
        if (mx == null) {
            throw new ElasticSearchException("Slice parameters exception: must set sliceMax in params!");
        }
        int max = mx;
        SliceScroll sliceScroll = new SliceScroll(){

            @Override
            public String buildSliceDsl(int sliceId, int max) {
                HashMap<String, Integer> _params = new HashMap<String, Integer>();
                _params.putAll(params);
                _params.put("sliceId", sliceId);
                String sliceDsl = ESTemplateHelper.evalTemplate(ConfigRestClientUtil.this.esUtil, dslTemplate, _params);
                return sliceDsl;
            }
        };
        return this._slice(path, scrollHandler, type, max, scroll, sliceScroll);
    }

    private <T> ESDatas<T> _scrollSlice(String path, String dslTemplate, Map params, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        long starttime = System.currentTimeMillis();
        Integer mx = (Integer)params.get("sliceMax");
        if (mx == null) {
            throw new ElasticSearchException("Slice parameters exception: must set sliceMax in params!");
        }
        int max = mx;
        String _path = path.indexOf(63) < 0 ? path + "?scroll=" + scroll : path + "&scroll=" + scroll;
        SliceScrollResult<T> sliceScrollResult = new SliceScrollResult<T>();
        if (scrollHandler != null) {
            sliceScrollResult.setScrollHandler(scrollHandler);
        }
        int j = 0;
        while (j < max && !sliceScrollResult.isBreaked()) {
            int i = j++;
            try {
                params.put("sliceId", i);
                this._doSliceScroll(i, _path, ESTemplateHelper.evalTemplate(this.esUtil, dslTemplate, params), scroll, type, sliceScrollResult, false);
            }
            catch (ElasticSearchException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ElasticSearchException("slice query task[" + i + "] failed:", e);
            }
        }
        if (logger.isDebugEnabled()) {
            long endtime = System.currentTimeMillis();
            logger.debug("Slice scroll query\u8017\u65f6\uff1a" + (endtime - starttime) + ",realTotalSize\uff1a" + sliceScrollResult.getRealTotalSize());
        }
        sliceScrollResult.complete();
        return sliceScrollResult.getSliceResponse();
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Map params, Class<T> type) throws ElasticSearchException {
        return super.scroll(path, ESTemplateHelper.evalTemplate(this.esUtil, dslTemplate, params), scroll, type);
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Map params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return super.scroll(path, ESTemplateHelper.evalTemplate(this.esUtil, dslTemplate, params), scroll, type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> scrollParallel(String path, String dslTemplate, String scroll, Map params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return super.scrollParallel(path, ESTemplateHelper.evalTemplate(this.esUtil, dslTemplate, params), scroll, type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Object params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return super.scroll(path, ESTemplateHelper.evalTemplate(this.esUtil, dslTemplate, params), scroll, type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> scrollParallel(String path, String dslTemplate, String scroll, Object params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return super.scrollParallel(path, ESTemplateHelper.evalTemplate(this.esUtil, dslTemplate, params), scroll, type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Object params, Class<T> type) throws ElasticSearchException {
        return super.scroll(path, ESTemplateHelper.evalTemplate(this.esUtil, dslTemplate, params), scroll, type);
    }

    @Override
    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Map params, String scroll, Class<T> type) throws ElasticSearchException {
        return this.scrollSlice(path, dslTemplate, params, scroll, type, null);
    }

    @Override
    public <T> ESDatas<T> scrollSliceParallel(String path, String dslTemplate, Map params, String scroll, Class<T> type) throws ElasticSearchException {
        return this.scrollSliceParallel(path, dslTemplate, params, scroll, type, null);
    }

    @Override
    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Map params, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return this._scrollSlice(path, dslTemplate, params, scroll, type, scrollHandler);
    }

    @Override
    public String addDocumentsNew(String indexName, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(indexName, "_doc", addTemplate, beans, refreshOption);
    }

    @Override
    public String addDocumentsNew(String indexName, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(indexName, "_doc", addTemplate, beans);
    }

    @Override
    public String addDocumentNew(String indexName, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", addTemplate, bean);
    }

    @Override
    public String addDocumentNew(String indexName, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", addTemplate, bean, refreshOption);
    }

    @Override
    public String updateDocumentsNew(String indexName, String updateTemplate, List<?> beans) throws ElasticSearchException {
        return this.updateDocuments(indexName, "_doc", updateTemplate, beans);
    }

    @Override
    public String updateDocumentsNew(String indexName, String updateTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.updateDocuments(indexName, "_doc", updateTemplate, beans, refreshOption);
    }

    @Override
    public String addDateDocumentNew(String indexName, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", addTemplate, bean);
    }

    @Override
    public String addDateDocumentNew(String indexName, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", addTemplate, bean, refreshOption);
    }

    @Override
    public String addDateDocumentsNew(String indexName, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDateDocuments(indexName, "_doc", addTemplate, beans);
    }

    @Override
    public String addDateDocumentsNew(String indexName, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDateDocuments(indexName, "_doc", addTemplate, beans, refreshOption);
    }

    @Override
    public String createScript(String scriptName, String scriptDslTemplate) {
        return this.client.executeHttp("_scripts/" + scriptName, ESTemplateHelper.evalTemplate(this.esUtil, scriptDslTemplate, null), "post");
    }

    @Override
    public String createScript(String scriptName, String scriptDslTemplate, Map params) {
        return this.client.executeHttp("_scripts/" + scriptName, ESTemplateHelper.evalTemplate(this.esUtil, scriptDslTemplate, params), "post");
    }

    @Override
    public String createScript(String scriptName, String scriptDslTemplate, Object params) {
        return this.client.executeHttp("_scripts/" + scriptName, ESTemplateHelper.evalTemplate(this.esUtil, scriptDslTemplate, params), "post");
    }
}

