/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import com.frameworkset.orm.annotation.NameParserException;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.bulk.BulkActionConfig;
import org.frameworkset.elasticsearch.bulk.BulkData;
import org.frameworkset.elasticsearch.client.ClientOptions;
import org.frameworkset.elasticsearch.client.RestGetVariableValue;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.elasticsearch.entity.ESIndice;
import org.frameworkset.elasticsearch.entity.IndexField;
import org.frameworkset.elasticsearch.entity.IndiceHeader;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.DataFormatUtil;
import org.frameworkset.util.annotations.DateFormateMeta;

public abstract class BuildTool {
    private static final ThreadLocal<BatchContext> batchContextThreadLocal = new ThreadLocal();

    public static void buildIndiceName(ESIndexWrapper esIndexWrapper, StringBuilder builder, ESIndexWrapper.GetVariableValue getVariableValue) {
        String name = esIndexWrapper.getName();
        if (name != null) {
            builder.append(name);
            return;
        }
        boolean useBatchContext = esIndexWrapper.isUseBatchContextIndexName();
        List tokens = esIndexWrapper.getNameTokens();
        if (tokens == null || tokens.size() == 0) {
            return;
        }
        BatchContext batchContext = getVariableValue.getBatchContext();
        String indexName = null;
        if (batchContext != null && useBatchContext && (indexName = batchContext.getIndexName(esIndexWrapper.getIndex())) != null) {
            builder.append(indexName);
            return;
        }
        boolean onlyCurrentDateTimestamp = esIndexWrapper.isOnlyCurrentDateTimestamp();
        ESIndexWrapper.NameGrammarToken nameGrammarToken = null;
        StringBuilder temp = onlyCurrentDateTimestamp && batchContext != null && indexName == null && useBatchContext ? new StringBuilder() : null;
        for (int i = 0; i < tokens.size(); ++i) {
            nameGrammarToken = (ESIndexWrapper.NameGrammarToken)tokens.get(i);
            if (!nameGrammarToken.varibletoken()) {
                if (temp != null) {
                    temp.append(nameGrammarToken.getText());
                }
                builder.append(nameGrammarToken.getText());
                continue;
            }
            if (nameGrammarToken.getFieldName() != null) {
                Object va = getVariableValue.getValue(nameGrammarToken.getFieldName());
                if (va == null) {
                    throw new NameParserException(esIndexWrapper.getNameInfo().toString() + ",property[" + nameGrammarToken.getFieldName() + "] is null.");
                }
                if (nameGrammarToken.getDateformat() != null) {
                    SimpleDateFormat dateFormat = DataFormatUtil.getSimpleDateFormat((String)nameGrammarToken.getDateformat());
                    if (va instanceof Date) {
                        builder.append(dateFormat.format((Date)va));
                        continue;
                    }
                    if (va instanceof Long) {
                        builder.append(dateFormat.format(new Date((Long)va)));
                        continue;
                    }
                    builder.append(va);
                    continue;
                }
                builder.append(va);
                continue;
            }
            SimpleDateFormat dateFormat = DataFormatUtil.getSimpleDateFormat((String)nameGrammarToken.getDateformat());
            Date date = new Date();
            String d = dateFormat.format(date);
            builder.append(d);
            if (temp == null) continue;
            temp.append(d);
        }
        if (temp != null && useBatchContext) {
            batchContext.setIndexName(esIndexWrapper.getIndex(), temp.toString());
        }
    }

    public static void buildIndiceName(ESIndexWrapper esIndexWrapper, Writer writer, ESIndexWrapper.GetVariableValue getVariableValue) throws IOException {
        String name = esIndexWrapper.getName();
        if (name != null) {
            writer.write(name);
            return;
        }
        List tokens = esIndexWrapper.getNameTokens();
        if (tokens == null || tokens.size() == 0) {
            return;
        }
        BatchContext batchContext = getVariableValue.getBatchContext();
        boolean useBatchContextIndexName = esIndexWrapper.isUseBatchContextIndexName();
        String indexName = null;
        if (useBatchContextIndexName && batchContext != null && (indexName = batchContext.getIndexName(esIndexWrapper.getIndex())) != null) {
            writer.write(indexName);
            return;
        }
        ESIndexWrapper.NameGrammarToken nameGrammarToken = null;
        boolean onlyCurrentDateTimestamp = esIndexWrapper.isOnlyCurrentDateTimestamp();
        StringBuilder temp = onlyCurrentDateTimestamp && batchContext != null && indexName == null && useBatchContextIndexName ? new StringBuilder() : null;
        for (int i = 0; i < tokens.size(); ++i) {
            nameGrammarToken = (ESIndexWrapper.NameGrammarToken)tokens.get(i);
            if (!nameGrammarToken.varibletoken()) {
                if (temp != null) {
                    temp.append(nameGrammarToken.getText());
                }
                writer.write(nameGrammarToken.getText());
                continue;
            }
            if (nameGrammarToken.getFieldName() != null) {
                Object va = getVariableValue.getValue(nameGrammarToken.getFieldName());
                if (va == null) {
                    throw new NameParserException(esIndexWrapper.getNameInfo().toString() + ",property[" + nameGrammarToken.getFieldName() + "] is null.");
                }
                if (nameGrammarToken.getDateformat() != null) {
                    SimpleDateFormat dateFormat = DataFormatUtil.getSimpleDateFormat((String)nameGrammarToken.getDateformat());
                    if (va instanceof Date) {
                        writer.write(dateFormat.format((Date)va));
                        continue;
                    }
                    if (va instanceof Long) {
                        writer.write(dateFormat.format(new Date((Long)va)));
                        continue;
                    }
                    writer.write(String.valueOf(va));
                    continue;
                }
                writer.write(String.valueOf(va));
                continue;
            }
            SimpleDateFormat dateFormat = DataFormatUtil.getSimpleDateFormat((String)nameGrammarToken.getDateformat());
            Date date = new Date();
            String d = dateFormat.format(date);
            writer.write(d);
            if (temp == null) continue;
            temp.append(d);
        }
        if (useBatchContextIndexName && temp != null) {
            batchContext.setIndexName(esIndexWrapper.getIndex(), temp.toString());
        }
    }

    public static void buildIndiceType(ESIndexWrapper esIndexWrapper, StringBuilder builder, ESIndexWrapper.GetVariableValue getVariableValue) {
        ESIndexWrapper.TypeInfo typeInfo = esIndexWrapper.getTypeInfo();
        if (typeInfo == null) {
            builder.append("_doc");
            return;
        }
        String type = typeInfo.getType();
        if (type != null) {
            builder.append(type);
            return;
        }
        List tokens = typeInfo.getTokens();
        if (tokens == null || tokens.size() == 0) {
            builder.append("_doc");
            return;
        }
        boolean useBatchContext = esIndexWrapper.isUseBatchContextIndexType();
        BatchContext batchContext = getVariableValue.getBatchContext();
        if (batchContext != null && useBatchContext && batchContext.getIndexType() != null) {
            builder.append(batchContext.getIndexType());
            return;
        }
        ESIndexWrapper.NameGrammarToken nameGrammarToken = null;
        for (int i = 0; i < tokens.size(); ++i) {
            nameGrammarToken = (ESIndexWrapper.NameGrammarToken)tokens.get(i);
            if (!nameGrammarToken.varibletoken()) {
                builder.append(nameGrammarToken.getText());
                continue;
            }
            Object va = getVariableValue.getValue(nameGrammarToken.getFieldName());
            if (va == null) {
                throw new NameParserException(typeInfo.toString() + ",property[" + nameGrammarToken.getFieldName() + "] is null.");
            }
            builder.append(va);
        }
    }

    public static String buildIndiceType(ESIndexWrapper esIndexWrapper, ESIndexWrapper.GetVariableValue getVariableValue) {
        ESIndexWrapper.TypeInfo typeInfo = esIndexWrapper.getTypeInfo();
        if (typeInfo == null) {
            return null;
        }
        String type = typeInfo.getType();
        if (type != null) {
            return type;
        }
        List tokens = typeInfo.getTokens();
        if (tokens == null || tokens.size() == 0) {
            return null;
        }
        boolean useBatchContext = esIndexWrapper.isUseBatchContextIndexType();
        BatchContext batchContext = getVariableValue.getBatchContext();
        if (batchContext != null && useBatchContext && batchContext.getIndexType() != null) {
            return batchContext.getIndexType();
        }
        ESIndexWrapper.NameGrammarToken nameGrammarToken = null;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            nameGrammarToken = (ESIndexWrapper.NameGrammarToken)tokens.get(i);
            if (!nameGrammarToken.varibletoken()) {
                builder.append(nameGrammarToken.getText());
                continue;
            }
            Object va = getVariableValue.getValue(nameGrammarToken.getFieldName());
            if (va == null) {
                throw new NameParserException(typeInfo.toString() + ",property[" + nameGrammarToken.getFieldName() + "] is null.");
            }
            builder.append(va);
        }
        return builder.toString();
    }

    public static BatchContext initBatchContextThreadLocal() {
        BatchContext batchContext = new BatchContext();
        batchContextThreadLocal.set(batchContext);
        return batchContext;
    }

    public static void cleanBatchContextThreadLocal() {
        batchContextThreadLocal.set(null);
    }

    public static BatchContext getBatchContext() {
        return batchContextThreadLocal.get();
    }

    public static Map<Integer, IndiceHeader> buildIndiceHeaders(String lineHeader) {
        if (lineHeader == null) {
            return null;
        }
        lineHeader = lineHeader.trim();
        HashMap<Integer, IndiceHeader> indiceHeaders = new HashMap<Integer, IndiceHeader>();
        int k = 0;
        IndiceHeader indiceHeader = null;
        StringBuilder token = new StringBuilder();
        int offset = 0;
        for (int j = 0; j < lineHeader.length(); ++j) {
            char c = lineHeader.charAt(j);
            if (c != ' ') {
                if (token.length() == 0) {
                    offset = j;
                }
                token.append(c);
                continue;
            }
            if (token.length() == 0) continue;
            indiceHeader = new IndiceHeader();
            indiceHeader.setHeaderName(token.toString());
            indiceHeader.setOffset(offset);
            indiceHeader.setPosition(k);
            indiceHeaders.put(k, indiceHeader);
            token.setLength(0);
            ++k;
        }
        if (token.length() > 0) {
            indiceHeader = new IndiceHeader();
            indiceHeader.setHeaderName(token.toString());
            indiceHeader.setPosition(k);
            indiceHeaders.put(k, indiceHeader);
            token.setLength(0);
        }
        return indiceHeaders;
    }

    public static List<IndiceHeader> buildListIndiceHeaders(String lineHeader) {
        if (lineHeader == null) {
            return null;
        }
        lineHeader = lineHeader.trim();
        ArrayList<IndiceHeader> indiceHeaders = new ArrayList<IndiceHeader>();
        int k = 0;
        IndiceHeader indiceHeader = null;
        StringBuilder token = new StringBuilder();
        int offset = 0;
        for (int j = 0; j < lineHeader.length(); ++j) {
            char c = lineHeader.charAt(j);
            if (c != ' ') {
                if (token.length() == 0) {
                    offset = j;
                }
                token.append(c);
                continue;
            }
            if (token.length() == 0) continue;
            indiceHeader = new IndiceHeader();
            indiceHeader.setHeaderName(token.toString());
            indiceHeader.setOffset(offset);
            indiceHeader.setPosition(k);
            indiceHeaders.add(indiceHeader);
            token.setLength(0);
            ++k;
        }
        if (token.length() > 0) {
            indiceHeader = new IndiceHeader();
            indiceHeader.setHeaderName(token.toString());
            indiceHeader.setPosition(k);
            indiceHeader.setOffset(offset);
            indiceHeaders.add(indiceHeader);
            token.setLength(0);
        }
        return indiceHeaders;
    }

    private static void putField(ESIndice esIndice, IndiceHeader indiceHeader, StringBuilder token, SimpleDateFormat format) {
        if (indiceHeader.getHeaderName().equals("health")) {
            if (token.length() > 0) {
                esIndice.setHealth(token.toString());
                token.setLength(0);
            }
        } else if (indiceHeader.getHeaderName().equals("status")) {
            if (token.length() > 0) {
                esIndice.setStatus(token.toString());
                token.setLength(0);
            }
        } else if (indiceHeader.getHeaderName().equals("index")) {
            if (token.length() > 0) {
                esIndice.setIndex(token.toString());
                BuildTool.putGendate(esIndice, format);
                token.setLength(0);
            }
        } else if (indiceHeader.getHeaderName().equals("uuid")) {
            if (token.length() > 0) {
                esIndice.setUuid(token.toString());
                token.setLength(0);
            }
        } else if (indiceHeader.getHeaderName().equals("pri")) {
            if (token.length() > 0) {
                esIndice.setPri(Integer.parseInt(token.toString()));
                token.setLength(0);
            }
        } else if (indiceHeader.getHeaderName().equals("rep")) {
            if (token.length() > 0) {
                esIndice.setRep(Integer.parseInt(token.toString()));
                token.setLength(0);
            }
        } else if (indiceHeader.getHeaderName().equals("docs.count")) {
            if (token.length() > 0) {
                esIndice.setDocsCcount(Long.parseLong(token.toString()));
                token.setLength(0);
            }
        } else if (indiceHeader.getHeaderName().equals("docs.deleted")) {
            if (token.length() > 0) {
                esIndice.setDocsDeleted(Long.parseLong(token.toString()));
                token.setLength(0);
            }
        } else if (indiceHeader.getHeaderName().equals("store.size")) {
            if (token.length() > 0) {
                esIndice.setStoreSize(token.toString());
                token.setLength(0);
            }
        } else if (indiceHeader.getHeaderName().equals("pri.store.size")) {
            if (token.length() > 0) {
                esIndice.setPriStoreSize(token.toString());
                token.setLength(0);
            }
        } else {
            esIndice.addOtherData(indiceHeader.getHeaderName(), token.toString());
            token.setLength(0);
        }
    }

    private static IndiceHeader fieldValueStart(int offset, List<IndiceHeader> indiceHeaderList) {
        for (IndiceHeader indiceHeader : indiceHeaderList) {
            if (offset != indiceHeader.getOffset()) continue;
            return indiceHeader;
        }
        return null;
    }

    public static String findByFieldValueDsl(String fieldName, Object fieldValue) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \"size\":").append(1).append(",\"query\": {\"bool\": {\"filter\":[{\"term\":{\"").append(fieldName).append("\":");
        CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
        if (fieldValue instanceof String) {
            builder.append("\"");
            charEscapeUtil.writeString((String)fieldValue, true);
            builder.append("\"");
        } else if (fieldValue instanceof Date) {
            DateFormateMeta dateFormateMeta = SerialUtil.getDateFormateMeta();
            DateFormat format = dateFormateMeta.toDateFormat();
            builder.append("\"");
            builder.append(format.format((Date)fieldValue));
            builder.append("\"");
        } else {
            builder.append(String.valueOf(fieldValue));
        }
        builder.append("}}]}}}");
        return builder.toString();
    }

    public static String matchByFieldValueDsl(String fieldName, Object fieldValue) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \"size\":").append(1).append(",\"query\": {\"match\": {\"").append(fieldName).append("\":");
        CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
        builder.append("\"");
        charEscapeUtil.writeString(String.valueOf(fieldValue), true);
        builder.append("\"");
        builder.append("}}}");
        return builder.toString();
    }

    public static String findByFieldValueDsl(String fieldName, Object fieldValue, int from, int size) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \"from\":").append(from).append(",\"size\":").append(size).append(",\"query\": {\"bool\": {\"filter\":[{\"term\":{\"").append(fieldName).append("\":");
        CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
        if (fieldValue instanceof String) {
            builder.append("\"");
            charEscapeUtil.writeString((String)fieldValue, true);
            builder.append("\"");
        } else if (fieldValue instanceof Date) {
            DateFormateMeta dateFormateMeta = SerialUtil.getDateFormateMeta();
            DateFormat format = dateFormateMeta.toDateFormat();
            builder.append("\"");
            builder.append(format.format((Date)fieldValue));
            builder.append("\"");
        } else {
            builder.append(String.valueOf(fieldValue));
        }
        builder.append("}}]}}}");
        return builder.toString();
    }

    public static String matchByFieldValueDsl(String fieldName, Object fieldValue, int from, int size) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \"from\":").append(from).append(",\"size\":").append(size).append(",\"query\": {\"match\": {\"").append(fieldName).append("\":");
        CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
        builder.append("\"");
        charEscapeUtil.writeString(String.valueOf(fieldValue), true);
        builder.append("\"");
        builder.append("}}}");
        return builder.toString();
    }

    public static ESIndice buildESIndice(String line, SimpleDateFormat format, List<IndiceHeader> indiceHeaderList) {
        StringBuilder token = new StringBuilder();
        ESIndice esIndice = new ESIndice();
        IndiceHeader indiceHeader = null;
        for (int j = 0; j < line.length(); ++j) {
            char c;
            IndiceHeader _indiceHeader = BuildTool.fieldValueStart(j, indiceHeaderList);
            if (_indiceHeader != null) {
                if (indiceHeader != null) {
                    BuildTool.putField(esIndice, indiceHeader, token, format);
                }
                indiceHeader = _indiceHeader;
            }
            if ((c = line.charAt(j)) != ' ') {
                token.append(c);
                continue;
            }
            if (token.length() == 0 || indiceHeader == null) continue;
            BuildTool.putField(esIndice, indiceHeader, token, format);
            indiceHeader = null;
        }
        if (token.length() > 0) {
            BuildTool.putField(esIndice, indiceHeader, token, format);
        }
        return esIndice;
    }

    public static void putGendate(ESIndice esIndice, SimpleDateFormat format) {
        int dsplit = esIndice.getIndex().lastIndexOf(45);
        try {
            if (dsplit > 0) {
                String date = esIndice.getIndex().substring(dsplit + 1);
                esIndice.setGenDate((Date)format.parseObject(date));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String buildGetDocumentRequest(String indexName, String indexType, String documentId, Map<String, Object> options) {
        if (documentId == null) {
            throw new ElasticSearchException("GetDocumentRequest failed:indexName[" + indexName + "] indexType[" + indexType + "] documentId is null.");
        }
        if (documentId.equals("")) {
            throw new ElasticSearchException("GetDocumentRequest failed:indexName[" + indexName + "] indexType[" + indexType + "] documentId is \"\".");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(indexName).append("/").append(indexType).append("/");
        CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
        charEscapeUtil.writeString(documentId, true);
        if (options != null) {
            builder.append("?");
            Iterator<Map.Entry<String, Object>> iterable = options.entrySet().iterator();
            boolean first = true;
            while (iterable.hasNext()) {
                Map.Entry<String, Object> entry = iterable.next();
                if (first) {
                    builder.append(entry.getKey()).append("=").append(entry.getValue());
                    first = false;
                    continue;
                }
                builder.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return builder.toString();
    }

    public static String buildSearchDocumentRequest(String indexName, String indexType, Map<String, Object> options) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(indexName);
        if (indexType != null) {
            builder.append("/").append(indexType);
        }
        builder.append("/_search");
        if (options != null && options.size() > 0) {
            builder.append("?");
            Iterator<Map.Entry<String, Object>> iterable = options.entrySet().iterator();
            boolean first = true;
            while (iterable.hasNext()) {
                Map.Entry<String, Object> entry = iterable.next();
                if (first) {
                    builder.append(entry.getKey()).append("=").append(entry.getValue());
                    first = false;
                    continue;
                }
                builder.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return builder.toString();
    }

    public static void buildId(Object id, StringBuilder builder, boolean escape) {
        if (id instanceof String) {
            if (!escape) {
                builder.append("\"").append(id).append("\"");
            } else {
                builder.append("\"");
                CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
                charEscapeUtil.writeString((String)id, true);
                builder.append("\"");
            }
        } else {
            builder.append(id);
        }
    }

    public static void buildId(Object id, Writer writer, boolean escape) throws IOException {
        if (id instanceof String) {
            writer.write("\"");
            if (!escape) {
                writer.write((String)id);
            } else {
                CharEscapeUtil charEscapeUtil = new CharEscapeUtil(writer);
                charEscapeUtil.writeString((String)id, true);
            }
            writer.write("\"");
        } else {
            writer.write(String.valueOf(id));
        }
    }

    public static String buildActionUrl(BulkActionConfig bulkConfig) {
        if (bulkConfig == null) {
            return "_bulk";
        }
        StringBuilder url = new StringBuilder();
        url.append("_bulk");
        String refreshOption = bulkConfig.getRefreshOption();
        if (refreshOption != null) {
            url.append("?").append(refreshOption);
        } else {
            String pipeline;
            Integer wait_for_active_shards;
            String timeout;
            Object routing;
            String refresh = bulkConfig.getRefresh();
            boolean p = false;
            if (refresh != null) {
                url.append("?refresh=").append(refresh);
                p = true;
            }
            if ((routing = bulkConfig.getRouting()) != null) {
                if (p) {
                    url.append("&routing=").append(routing);
                } else {
                    url.append("?routing=").append(routing);
                    p = true;
                }
            }
            if ((timeout = bulkConfig.getTimeout()) != null) {
                if (p) {
                    url.append("&timeout=").append(timeout);
                } else {
                    url.append("?timeout=").append(timeout);
                    p = true;
                }
            }
            if ((wait_for_active_shards = bulkConfig.getWaitForActiveShards()) != null) {
                if (p) {
                    url.append("&wait_for_active_shards=").append(wait_for_active_shards);
                } else {
                    url.append("?wait_for_active_shards=").append(wait_for_active_shards);
                    p = true;
                }
            }
            if ((pipeline = bulkConfig.getPipeline()) != null) {
                if (p) {
                    url.append("&pipeline=").append(pipeline);
                } else {
                    url.append("?pipeline=").append(pipeline);
                    p = true;
                }
            }
        }
        return url.toString();
    }

    public static String buildAddPathUrlMeta(String indexName, String indexType, Object params, ClientOptions clientOptions, ClassUtil.ClassInfo beanInfo) {
        Integer wait_for_active_shards;
        String master_timeout;
        String timeout;
        String refresh;
        String op_type;
        String pipeline;
        Long if_primary_term;
        Long if_seq_no;
        Object docId = null;
        Object parentId = null;
        Object routing = null;
        String refreshOption = null;
        Object esRetryOnConflict = null;
        Object version = null;
        Object versionType = null;
        ClassUtil.ClassInfo beanClassInfo = ClassUtil.getClassInfo(params.getClass());
        docId = clientOptions != null ? (clientOptions.getId() != null ? clientOptions.getId() : (clientOptions.getIdField() != null ? BuildTool.getId(params, beanClassInfo, clientOptions.getIdField()) : BuildTool.getId(params, beanInfo))) : BuildTool.getId(params, beanInfo);
        parentId = clientOptions != null ? (clientOptions.getParentId() != null ? clientOptions.getParentId() : (clientOptions.getParentIdField() != null ? BuildTool.getParentId(params, beanClassInfo, clientOptions.getParentIdField()) : BuildTool.getParentId(params, beanInfo))) : BuildTool.getParentId(params, beanInfo);
        if (clientOptions != null) {
            refreshOption = clientOptions.getRefreshOption();
        }
        if (clientOptions != null) {
            routing = clientOptions.getRouting() == null ? (clientOptions.getRoutingField() != null ? BuildTool.getRouting(params, beanInfo, clientOptions.getRoutingField()) : BuildTool.getRouting(params, beanInfo)) : clientOptions.getRouting();
            esRetryOnConflict = clientOptions.getEsRetryOnConflict() == null ? (clientOptions.getEsRetryOnConflictField() != null ? BuildTool.getEsRetryOnConflict(params, beanInfo, clientOptions.getEsRetryOnConflictField()) : BuildTool.getEsRetryOnConflict(params, beanInfo)) : clientOptions.getEsRetryOnConflict();
            version = clientOptions.getVersion() == null ? (clientOptions.getVersionField() != null ? BuildTool.getEsRetryOnConflict(params, beanInfo, clientOptions.getVersionField()) : BuildTool.getVersion(beanInfo, params)) : clientOptions.getVersion();
            versionType = clientOptions.getVersionType() == null ? (clientOptions.getVersionTypeField() != null ? BuildTool.getEsRetryOnConflict(params, beanInfo, clientOptions.getVersionTypeField()) : BuildTool.getVersionType(beanInfo, params)) : clientOptions.getVersionType();
        } else {
            routing = BuildTool.getRouting(params, beanInfo);
            esRetryOnConflict = BuildTool.getEsRetryOnConflict(params, beanInfo);
            version = BuildTool.getVersion(beanInfo, params);
            versionType = BuildTool.getVersionType(beanInfo, params);
        }
        StringBuilder builder = new StringBuilder();
        Object id = docId;
        if (indexName == null) {
            if (beanClassInfo == null) {
                throw new ElasticSearchException(" _addDocument failed: Class info not setted.");
            }
            ESIndexWrapper esIndexWrapper = beanClassInfo.getEsIndexWrapper();
            if (esIndexWrapper == null) {
                throw new ElasticSearchException(builder.append(" ESIndex annotation do not set in class ").append(beanClassInfo.toString()).toString());
            }
            RestGetVariableValue restGetVariableValue = new RestGetVariableValue(beanClassInfo, params);
            BuildTool.buildIndiceName(esIndexWrapper, builder, (ESIndexWrapper.GetVariableValue)restGetVariableValue);
            builder.append("/");
            if (indexType == null) {
                BuildTool.buildIndiceType(esIndexWrapper, builder, (ESIndexWrapper.GetVariableValue)restGetVariableValue);
            } else {
                builder.append("/").append(indexType);
            }
        } else {
            builder.append(indexName);
            if (indexType == null || indexType.equals("")) {
                builder.append("/").append("_doc");
            } else {
                builder.append("/").append(indexType);
            }
        }
        if (id != null) {
            builder.append("/").append(id);
        }
        boolean p = false;
        if (refreshOption != null) {
            builder.append("?").append(refreshOption);
            if (parentId != null) {
                builder.append("&parent=").append(parentId);
            }
            if (routing != null) {
                builder.append("&routing=").append(routing);
            }
            p = true;
        } else if (parentId != null) {
            builder.append("?parent=").append(parentId);
            if (routing != null) {
                builder.append("&routing=").append(routing);
            }
            p = true;
        } else if (routing != null) {
            builder.append("?routing=").append(routing);
            p = true;
        }
        if (esRetryOnConflict != null) {
            if (p) {
                builder.append("&retry_on_conflict=").append(esRetryOnConflict);
            } else {
                builder.append("?retry_on_conflict=").append(esRetryOnConflict);
                p = true;
            }
        }
        if (version != null) {
            if (p) {
                builder.append("&version=").append(version);
            } else {
                builder.append("?version=").append(version);
                p = true;
            }
        }
        if (versionType != null) {
            if (p) {
                builder.append("&version_type=").append(versionType);
            } else {
                builder.append("?version_type=").append(versionType);
                p = true;
            }
        }
        Long l = if_seq_no = clientOptions != null ? clientOptions.getIfSeqNo() : null;
        if (if_seq_no != null) {
            if (p) {
                builder.append("&if_seq_no=").append(if_seq_no);
            } else {
                builder.append("?if_seq_no=").append(if_seq_no);
                p = true;
            }
        }
        Long l2 = if_primary_term = clientOptions != null ? clientOptions.getIfPrimaryTerm() : null;
        if (if_primary_term != null) {
            if (p) {
                builder.append("&if_primary_term=").append(if_primary_term);
            } else {
                builder.append("?if_primary_term=").append(if_primary_term);
                p = true;
            }
        }
        String string = pipeline = clientOptions != null ? clientOptions.getPipeline() : null;
        if (pipeline != null) {
            if (p) {
                builder.append("&pipeline=").append(pipeline);
            } else {
                builder.append("?pipeline=").append(pipeline);
                p = true;
            }
        }
        String string2 = op_type = clientOptions != null ? clientOptions.getOpType() : null;
        if (op_type != null) {
            if (p) {
                builder.append("&op_type=").append(op_type);
            } else {
                builder.append("?op_type=").append(op_type);
                p = true;
            }
        }
        String string3 = refresh = clientOptions != null ? clientOptions.getRefresh() : null;
        if (refresh != null) {
            if (p) {
                builder.append("&refresh=").append(refresh);
            } else {
                builder.append("?refresh=").append(refresh);
                p = true;
            }
        }
        String string4 = timeout = clientOptions != null ? clientOptions.getTimeout() : null;
        if (timeout != null) {
            if (p) {
                builder.append("&timeout=").append(timeout);
            } else {
                builder.append("?timeout=").append(timeout);
                p = true;
            }
        }
        String string5 = master_timeout = clientOptions != null ? clientOptions.getMasterTimeout() : null;
        if (master_timeout != null) {
            if (p) {
                builder.append("&master_timeout=").append(master_timeout);
            } else {
                builder.append("?master_timeout=").append(master_timeout);
                p = true;
            }
        }
        Integer n = wait_for_active_shards = clientOptions != null ? clientOptions.getWaitForActiveShards() : null;
        if (wait_for_active_shards != null) {
            if (p) {
                builder.append("&wait_for_active_shards=").append(wait_for_active_shards);
            } else {
                builder.append("?wait_for_active_shards=").append(wait_for_active_shards);
                p = true;
            }
        }
        return builder.toString();
    }

    public static String buildUpdatePathUrlMeta(String index, String indexType, Object params, ClientOptions clientOptions, ClassUtil.ClassInfo beanInfo, boolean uper7) {
        Integer wait_for_active_shards;
        String master_timeout;
        String timeout;
        String refresh;
        Long if_primary_term;
        Long if_seq_no;
        Object docId = null;
        Object routing = null;
        String refreshOption = null;
        Object esRetryOnConflict = null;
        Object version = null;
        Object versionType = null;
        ClassUtil.ClassInfo beanClassInfo = ClassUtil.getClassInfo(params.getClass());
        docId = clientOptions != null ? (clientOptions.getId() != null ? clientOptions.getId() : (clientOptions.getIdField() != null ? BuildTool.getId(params, beanClassInfo, clientOptions.getIdField()) : BuildTool.getId(params, beanInfo))) : BuildTool.getId(params, beanInfo);
        if (clientOptions != null) {
            refreshOption = clientOptions.getRefreshOption();
        }
        if (clientOptions != null) {
            routing = clientOptions.getRouting() == null ? (clientOptions.getRoutingField() != null ? BuildTool.getRouting(params, beanInfo, clientOptions.getRoutingField()) : BuildTool.getRouting(params, beanInfo)) : clientOptions.getRouting();
            esRetryOnConflict = clientOptions.getEsRetryOnConflict() == null ? (clientOptions.getEsRetryOnConflictField() != null ? BuildTool.getEsRetryOnConflict(params, beanInfo, clientOptions.getEsRetryOnConflictField()) : BuildTool.getEsRetryOnConflict(params, beanInfo)) : clientOptions.getEsRetryOnConflict();
            version = clientOptions.getVersion() == null ? (clientOptions.getVersionField() != null ? BuildTool.getEsRetryOnConflict(params, beanInfo, clientOptions.getVersionField()) : BuildTool.getVersion(beanInfo, params)) : clientOptions.getVersion();
            versionType = clientOptions.getVersionType() == null ? (clientOptions.getVersionTypeField() != null ? BuildTool.getEsRetryOnConflict(params, beanInfo, clientOptions.getVersionTypeField()) : BuildTool.getVersionType(beanInfo, params)) : clientOptions.getVersionType();
        } else {
            routing = BuildTool.getRouting(params, beanInfo);
            esRetryOnConflict = BuildTool.getEsRetryOnConflict(params, beanInfo);
            version = BuildTool.getVersion(beanInfo, params);
            versionType = BuildTool.getVersionType(beanInfo, params);
        }
        StringBuilder builder = new StringBuilder();
        Object id = docId;
        if (index == null) {
            if (beanClassInfo == null) {
                throw new ElasticSearchException(" _addDocument failed: Class info not setted.");
            }
            ESIndexWrapper esIndexWrapper = beanClassInfo.getEsIndexWrapper();
            if (esIndexWrapper == null) {
                throw new ElasticSearchException(builder.append(" ESIndex annotation do not set in class ").append(beanClassInfo.toString()).toString());
            }
            RestGetVariableValue restGetVariableValue = new RestGetVariableValue(beanClassInfo, params);
            BuildTool.buildIndiceName(esIndexWrapper, builder, (ESIndexWrapper.GetVariableValue)restGetVariableValue);
            if (!uper7) {
                if (indexType == null || indexType.equals("")) {
                    indexType = BuildTool.buildIndiceType(esIndexWrapper, (ESIndexWrapper.GetVariableValue)restGetVariableValue);
                }
                if (indexType == null || indexType.equals("")) {
                    builder.append("/").append(id).append("/_update");
                } else {
                    builder.append("/").append(indexType).append("/").append(id).append("/_update");
                }
            } else {
                builder.append("/_update").append("/").append(id);
            }
        } else if (!uper7) {
            if (indexType == null || indexType.equals("")) {
                builder.append(index).append("/").append(id).append("/_update");
            } else {
                builder.append(index).append("/").append(indexType).append("/").append(id).append("/_update");
            }
        } else {
            builder.append(index).append("/_update").append("/").append(id);
        }
        boolean p = false;
        if (refreshOption != null) {
            builder.append("?").append(refreshOption);
            p = true;
        }
        if (routing != null) {
            if (p) {
                builder.append("&routing=").append(routing);
            } else {
                builder.append("?routing=").append(routing);
                p = true;
            }
        }
        if (version != null) {
            if (p) {
                builder.append("&version=").append(version);
            } else {
                builder.append("?version=").append(version);
                p = true;
            }
        }
        if (versionType != null) {
            if (p) {
                builder.append("&version_type=").append(versionType);
            } else {
                builder.append("?version_type=").append(versionType);
                p = true;
            }
        }
        Long l = if_seq_no = clientOptions != null ? clientOptions.getIfSeqNo() : null;
        if (if_seq_no != null) {
            if (p) {
                builder.append("&if_seq_no=").append(if_seq_no);
            } else {
                builder.append("?if_seq_no=").append(if_seq_no);
                p = true;
            }
        }
        Long l2 = if_primary_term = clientOptions != null ? clientOptions.getIfPrimaryTerm() : null;
        if (if_primary_term != null) {
            if (p) {
                builder.append("&if_primary_term=").append(if_primary_term);
            } else {
                builder.append("?if_primary_term=").append(if_primary_term);
                p = true;
            }
        }
        String string = refresh = clientOptions != null ? clientOptions.getRefresh() : null;
        if (refresh != null) {
            if (p) {
                builder.append("&refresh=").append(refresh);
            } else {
                builder.append("?refresh=").append(refresh);
                p = true;
            }
        }
        String string2 = timeout = clientOptions != null ? clientOptions.getTimeout() : null;
        if (timeout != null) {
            if (p) {
                builder.append("&timeout=").append(timeout);
            } else {
                builder.append("?timeout=").append(timeout);
                p = true;
            }
        }
        String string3 = master_timeout = clientOptions != null ? clientOptions.getMasterTimeout() : null;
        if (master_timeout != null) {
            if (p) {
                builder.append("&master_timeout=").append(master_timeout);
            } else {
                builder.append("?master_timeout=").append(master_timeout);
                p = true;
            }
        }
        if (esRetryOnConflict != null) {
            if (p) {
                builder.append("&retry_on_conflict=").append(esRetryOnConflict);
            } else {
                builder.append("?retry_on_conflict=").append(esRetryOnConflict);
                p = true;
            }
        }
        Integer n = wait_for_active_shards = clientOptions != null ? clientOptions.getWaitForActiveShards() : null;
        if (wait_for_active_shards != null) {
            if (p) {
                builder.append("&wait_for_active_shards=").append(wait_for_active_shards);
            } else {
                builder.append("?wait_for_active_shards=").append(wait_for_active_shards);
                p = true;
            }
        }
        return builder.toString();
    }

    public static void buildMeta(Writer writer, BulkData bulkData, boolean upper7, ClassUtil.ClassInfo beanInfo) throws IOException {
        String pipeline;
        String indexType = bulkData.getIndexType();
        ClientOptions clientOption = bulkData.getClientOptions();
        String indexName = bulkData.getIndex();
        Object params = bulkData.getData();
        String action = bulkData.getElasticsearchBulkType();
        Object id = null;
        Object parentId = null;
        Object routing = null;
        Object esRetryOnConflict = null;
        Object version = null;
        Object versionType = null;
        id = !bulkData.isDelete() ? (clientOption != null && clientOption.getIdField() != null ? BuildTool.getId(params, beanInfo, clientOption.getIdField()) : BuildTool.getId(params, beanInfo)) : bulkData.getData();
        if (clientOption != null) {
            Object object = parentId = clientOption.getParentIdField() != null ? BuildTool.getParentId(params, beanInfo, clientOption.getParentIdField()) : BuildTool.getParentId(params, beanInfo);
            routing = clientOption.getRouting() == null ? (clientOption.getRoutingField() != null ? BuildTool.getRouting(params, beanInfo, clientOption.getRoutingField()) : BuildTool.getRouting(params, beanInfo)) : clientOption.getRouting();
            esRetryOnConflict = clientOption.getEsRetryOnConflict() == null ? (clientOption.getEsRetryOnConflictField() != null ? BuildTool.getEsRetryOnConflict(params, beanInfo, clientOption.getEsRetryOnConflictField()) : BuildTool.getEsRetryOnConflict(params, beanInfo)) : clientOption.getEsRetryOnConflict();
            version = clientOption.getVersion() == null ? (clientOption.getVersionField() != null ? BuildTool.getEsRetryOnConflict(params, beanInfo, clientOption.getVersionField()) : BuildTool.getVersion(beanInfo, params)) : clientOption.getVersion();
            versionType = clientOption.getVersionType() == null ? (clientOption.getVersionTypeField() != null ? BuildTool.getEsRetryOnConflict(params, beanInfo, clientOption.getVersionTypeField()) : BuildTool.getVersionType(beanInfo, params)) : clientOption.getVersionType();
        } else {
            parentId = BuildTool.getParentId(params, beanInfo);
            routing = BuildTool.getRouting(params, beanInfo);
            esRetryOnConflict = BuildTool.getEsRetryOnConflict(params, beanInfo);
            version = BuildTool.getVersion(beanInfo, params);
            versionType = BuildTool.getVersionType(beanInfo, params);
        }
        writer.write("{ \"");
        writer.write(action);
        writer.write("\" : { \"_index\" : \"");
        ESIndexWrapper esIndexWrapper = null;
        RestGetVariableValue restGetVariableValue = null;
        if (indexName != null) {
            writer.write(indexName);
        } else {
            esIndexWrapper = beanInfo != null ? beanInfo.getEsIndexWrapper() : null;
            RestGetVariableValue restGetVariableValue2 = restGetVariableValue = esIndexWrapper != null ? new RestGetVariableValue(beanInfo, params) : null;
            if (esIndexWrapper == null) {
                throw new ElasticSearchException(" ESIndex annotation do not set in class " + (beanInfo != null ? beanInfo.toString() : ""));
            }
            BuildTool.buildIndiceName(esIndexWrapper, writer, (ESIndexWrapper.GetVariableValue)restGetVariableValue);
        }
        writer.write("\"");
        if (!upper7) {
            writer.write(", \"_type\" : \"");
            if (indexType != null) {
                writer.write(indexType);
            } else {
                if (esIndexWrapper == null) {
                    throw new ElasticSearchException(" ESIndex annotation do not set in class " + (beanInfo != null ? beanInfo.toString() : "") + " which must be set below  elasticsearch 7x  when type or indice name not setted.");
                }
                indexType = BuildTool.buildIndiceType(esIndexWrapper, (ESIndexWrapper.GetVariableValue)restGetVariableValue);
                if (indexType != null && !indexType.equals("")) {
                    writer.write(indexType);
                } else {
                    throw new ElasticSearchException(" ESIndex annotation do not set index type in class " + (beanInfo != null ? beanInfo.toString() : "") + " which must be set below  elasticsearch 7x when type or indice name not setted.");
                }
            }
            writer.write("\"");
        }
        if (id != null) {
            writer.write(", \"_id\" : ");
            BuildTool.buildId(id, writer, true);
        }
        if (parentId != null) {
            writer.write(", \"parent\" : ");
            BuildTool.buildId(parentId, writer, true);
        }
        if (routing != null) {
            if (!upper7) {
                writer.write(", \"_routing\" : ");
            } else {
                writer.write(", \"routing\" : ");
            }
            BuildTool.buildId(routing, writer, true);
        }
        if (esRetryOnConflict != null) {
            if (!upper7) {
                writer.write(",\"_retry_on_conflict\":");
            } else {
                writer.write(",\"retry_on_conflict\":");
            }
            writer.write(String.valueOf(esRetryOnConflict));
        }
        if (version != null) {
            if (!upper7) {
                writer.write(",\"_version\":");
            } else {
                writer.write(",\"version\":");
            }
            writer.write(String.valueOf(version));
        }
        if (versionType != null) {
            if (!upper7) {
                writer.write(",\"_version_type\":\"");
            } else {
                writer.write(",\"version_type\":\"");
            }
            writer.write(String.valueOf(versionType));
            writer.write("\"");
        }
        if (upper7) {
            Long if_primary_term;
            Long if_seq_no;
            Long l = if_seq_no = clientOption != null ? clientOption.getIfSeqNo() : null;
            if (if_seq_no != null) {
                writer.write(",\"if_seq_no\":");
                writer.write(String.valueOf(if_seq_no));
            }
            Long l2 = if_primary_term = clientOption != null ? clientOption.getIfPrimaryTerm() : null;
            if (if_primary_term != null) {
                writer.write(",\"if_primary_term\":");
                writer.write(String.valueOf(if_primary_term));
            }
        }
        String string = pipeline = clientOption != null ? clientOption.getPipeline() : null;
        if (pipeline != null) {
            writer.write(",\"pipeline\":\"");
            writer.write(pipeline);
            writer.write("\"");
        }
        if (bulkData.isInsert()) {
            String op_type;
            String string2 = op_type = clientOption != null ? clientOption.getOpType() : null;
            if (op_type != null) {
                writer.write(",\"op_type\":\"");
                writer.write(op_type);
                writer.write("\"");
            }
        }
        writer.write(" } }\n");
    }

    public static Object getVersion(ClassUtil.ClassInfo classInfo, Object params) {
        if (classInfo == null) {
            return null;
        }
        ClassUtil.PropertieDescription esVersionProperty = classInfo.getEsVersionProperty();
        Object version = null;
        if (esVersionProperty != null) {
            version = classInfo.getPropertyValue(params, esVersionProperty.getName());
        }
        return version;
    }

    public static Object getVersionType(ClassUtil.ClassInfo classInfo, Object params) {
        if (classInfo == null) {
            return null;
        }
        ClassUtil.PropertieDescription esVersionTypeProperty = classInfo.getEsVersionTypeProperty();
        Object versionType = null;
        if (esVersionTypeProperty != null) {
            versionType = classInfo.getPropertyValue(params, esVersionTypeProperty.getName());
        }
        return versionType;
    }

    public static void evalBuilk(Writer writer, BulkData bulkData, boolean upper7) throws IOException {
        Object param = bulkData.getData();
        ClassUtil.ClassInfo beanClassInfo = ClassUtil.getClassInfo(param.getClass());
        BuildTool.buildMeta(writer, bulkData, upper7, beanClassInfo);
        if (bulkData.isInsert()) {
            SerialUtil.object2json(bulkData.getData(), writer);
            writer.write("\n");
        } else if (bulkData.isUpdate()) {
            List<String> sourceUpdateIncludes;
            List<String> sourceUpdateExcludes;
            Boolean returnSource;
            Object detect_noop = null;
            Object doc_as_upsert = null;
            ClientOptions clientOptions = bulkData.getClientOptions();
            if (clientOptions != null) {
                if (clientOptions.getDetectNoop() != null) {
                    detect_noop = clientOptions.getDetectNoop();
                } else {
                    Object object = detect_noop = clientOptions.getDetectNoopField() != null ? BuildTool.getFieldValue(param, beanClassInfo, clientOptions.getDetectNoopField()) : null;
                }
                doc_as_upsert = clientOptions.getDocasupsert() != null ? clientOptions.getDocasupsert() : (clientOptions.getDocasupsertField() != null ? BuildTool.getFieldValue(param, beanClassInfo, clientOptions.getDocasupsertField()) : BuildTool.getEsDocAsUpsert(param, beanClassInfo));
            } else {
                doc_as_upsert = BuildTool.getEsDocAsUpsert(param, beanClassInfo);
            }
            writer.write("{\"doc\":");
            SerialUtil.object2json(param, writer);
            if (detect_noop != null) {
                writer.write(",\"detect_noop\":");
                writer.write(detect_noop.toString());
            }
            if (doc_as_upsert != null) {
                writer.write(",\"doc_as_upsert\":");
                writer.write(doc_as_upsert.toString());
            }
            Boolean bl = returnSource = clientOptions != null ? clientOptions.getReturnSource() : null;
            if (returnSource != null) {
                writer.write(",\"_source\":");
                writer.write(String.valueOf(returnSource));
            }
            List<String> list = sourceUpdateExcludes = clientOptions != null ? clientOptions.getSourceUpdateExcludes() : null;
            if (sourceUpdateExcludes != null && !upper7) {
                writer.write(",\"_source_excludes\":");
                SerialUtil.object2json(sourceUpdateExcludes, writer);
            }
            List<String> list2 = sourceUpdateIncludes = clientOptions != null ? clientOptions.getSourceUpdateIncludes() : null;
            if (sourceUpdateIncludes != null && !upper7) {
                writer.write(",\"_source_includes\":");
                SerialUtil.object2json(sourceUpdateIncludes, writer);
            }
            writer.write("}\n");
        }
    }

    public static void handleFields(Map<String, Object> subFileds, String fieldName, List<IndexField> fields) {
        if (subFileds == null || subFileds.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : subFileds.entrySet()) {
            IndexField indexField = BuildTool.buildIndexField(entry, fields, fieldName);
        }
    }

    public static Boolean parseBoolean(Object norms) {
        if (norms == null) {
            return null;
        }
        if (norms instanceof Boolean) {
            return (Boolean)norms;
        }
        if (norms instanceof Map) {
            return (Boolean)((Map)norms).get("enabled");
        }
        return null;
    }

    public static IndexField buildIndexField(Map.Entry<String, Object> field, List<IndexField> fields, String parentFieldName) {
        IndexField indexField = new IndexField();
        String fieldName = null;
        fieldName = parentFieldName != null ? parentFieldName + "." + field.getKey() : field.getKey();
        indexField.setFieldName(fieldName);
        Map fieldInfo = (Map)field.getValue();
        indexField.setType((String)fieldInfo.get("type"));
        indexField.setIgnoreAbove((Object)ResultUtil.intValue(fieldInfo.get("ignore_above"), null));
        indexField.setAnalyzer((String)fieldInfo.get("analyzer"));
        indexField.setNormalizer((String)fieldInfo.get("normalizer"));
        indexField.setBoost(fieldInfo.get("boost"));
        indexField.setCoerce(BuildTool.parseBoolean(fieldInfo.get("coerce")));
        indexField.setCopyTo((String)fieldInfo.get("copy_to"));
        indexField.setDocValues(BuildTool.parseBoolean(fieldInfo.get("doc_values")));
        indexField.setDynamic(BuildTool.parseBoolean(fieldInfo.get("doc_values")));
        indexField.setEnabled(BuildTool.parseBoolean(fieldInfo.get("enabled")));
        indexField.setFielddata(BuildTool.parseBoolean(fieldInfo.get("fielddata")));
        indexField.setFormat((String)fieldInfo.get("format"));
        indexField.setIgnoreMalformed(BuildTool.parseBoolean(fieldInfo.get("ignore_malformed")));
        indexField.setIncludeInAll(BuildTool.parseBoolean(fieldInfo.get("include_in_all")));
        indexField.setIndexOptions((String)fieldInfo.get("index_options"));
        indexField.setIndex(BuildTool.parseBoolean(fieldInfo.get("index")));
        indexField.setFields((Map)fieldInfo.get("fields"));
        indexField.setNorms(BuildTool.parseBoolean(fieldInfo.get("norms")));
        indexField.setNullValue(fieldInfo.get("null_value"));
        indexField.setPositionIncrementGap((Object)((Integer)fieldInfo.get("position_increment_gap")));
        indexField.setProperties((Map)fieldInfo.get("properties"));
        indexField.setSearchAnalyzer((String)fieldInfo.get("search_analyzer"));
        indexField.setSimilarity((String)fieldInfo.get("similarity"));
        indexField.setStore(BuildTool.parseBoolean(fieldInfo.get("store")));
        indexField.setTermVector((String)fieldInfo.get("term_vector"));
        fields.add(indexField);
        BuildTool.handleFields(indexField.getFields(), fieldName, fields);
        return indexField;
    }

    public static Object getId(Object bean, ClassUtil.ClassInfo beanInfo) {
        if (beanInfo == null) {
            return null;
        }
        ClassUtil.PropertieDescription pkProperty = beanInfo.getEsIdProperty();
        if (pkProperty == null) {
            return null;
        }
        return BuildTool.getFieldValue(bean, beanInfo, pkProperty.getName());
    }

    public static Object getId(Object bean, ClassUtil.ClassInfo beanInfo, String docIdField) {
        return BuildTool.getFieldValue(bean, beanInfo, docIdField);
    }

    public static Object getEsRetryOnConflict(Object bean, ClassUtil.ClassInfo beanInfo) {
        if (beanInfo == null) {
            return null;
        }
        ClassUtil.PropertieDescription esRetryOnConflictProperty = beanInfo.getEsRetryOnConflictProperty();
        if (esRetryOnConflictProperty == null) {
            return null;
        }
        return BuildTool.getFieldValue(bean, beanInfo, esRetryOnConflictProperty.getName());
    }

    public static Object getEsRetryOnConflict(Object bean, ClassUtil.ClassInfo beanInfo, String esRetryOnConflictField) {
        return BuildTool.getFieldValue(bean, beanInfo, esRetryOnConflictField);
    }

    public static Object getRouting(Object bean, ClassUtil.ClassInfo beanInfo) {
        if (beanInfo == null) {
            return null;
        }
        ClassUtil.PropertieDescription routingProperty = beanInfo.getEsRoutingProperty();
        if (routingProperty == null) {
            return null;
        }
        return BuildTool.getFieldValue(bean, beanInfo, routingProperty.getName());
    }

    public static Object getRouting(Object bean, ClassUtil.ClassInfo beanInfo, String routingField) {
        return BuildTool.getFieldValue(bean, beanInfo, routingField);
    }

    public static Object getEsDocAsUpsert(Object bean, ClassUtil.ClassInfo beanClassInfo) {
        if (beanClassInfo == null) {
            return null;
        }
        ClassUtil.PropertieDescription propertieDescription = beanClassInfo.getEsDocAsUpsertProperty();
        if (propertieDescription == null) {
            return null;
        }
        return BuildTool.getFieldValue(bean, beanClassInfo, propertieDescription.getName());
    }

    public static Object getParentId(Object bean, ClassUtil.ClassInfo beanInfo) {
        if (beanInfo == null) {
            return null;
        }
        ClassUtil.PropertieDescription pkProperty = beanInfo.getEsParentProperty();
        if (pkProperty == null) {
            return null;
        }
        return BuildTool.getFieldValue(bean, beanInfo, pkProperty.getName());
    }

    public static Object getParentId(Object bean, ClassUtil.ClassInfo beanInfo, String parentIdField) {
        return BuildTool.getFieldValue(bean, beanInfo, parentIdField);
    }

    public static Object getFieldValue(Object bean, ClassUtil.ClassInfo beanInfo, String field) {
        if (beanInfo == null) {
            return null;
        }
        if (field == null) {
            return null;
        }
        if (!beanInfo.isMap()) {
            return beanInfo.getPropertyValue(bean, field);
        }
        return ((Map)bean).get(field);
    }
}

