/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.bulk;

import org.frameworkset.elasticsearch.bulk.BulkConfig;
import org.frameworkset.elasticsearch.bulk.BulkInterceptor;
import org.frameworkset.elasticsearch.bulk.BulkProcessor;
import org.frameworkset.elasticsearch.bulk.BulkProcessorException;
import org.frameworkset.elasticsearch.bulk.BulkRetryHandler;

public class BulkProcessorBuilder {
    private BulkConfig bulkConfig = new BulkConfig();

    public BulkProcessorBuilder setBulkRetryHandler(BulkRetryHandler bulkRetryHandler) {
        this.bulkConfig.setBulkRetryHandler(bulkRetryHandler);
        return this;
    }

    public BulkProcessorBuilder setRetryTimes(int retryTimes) {
        this.bulkConfig.setRetryTimes(retryTimes);
        return this;
    }

    public BulkProcessorBuilder setRetryInterval(long retryInterval) {
        this.bulkConfig.setRetryInterval(retryInterval);
        return this;
    }

    public BulkProcessorBuilder setBulkSizes(int bulkSizes) {
        this.bulkConfig.setBulkSizes(bulkSizes);
        return this;
    }

    public BulkProcessorBuilder setBulkFailRetry(int bulkFailRetry) {
        this.bulkConfig.setBulkFailRetry(bulkFailRetry);
        return this;
    }

    public BulkProcessorBuilder setFlushInterval(long flushInterval) {
        this.bulkConfig.setFlushInterval(flushInterval);
        return this;
    }

    public BulkProcessorBuilder setWorkThreadQueue(int workThreadQueue) {
        this.bulkConfig.setWorkThreadQueue(workThreadQueue);
        return this;
    }

    public BulkProcessorBuilder setWorkThreads(int workThreads) {
        this.bulkConfig.setWorkThreads(workThreads);
        return this;
    }

    public BulkProcessorBuilder addBulkInterceptor(BulkInterceptor bulkInterceptor) {
        this.bulkConfig.addBulkInterceptor(bulkInterceptor);
        return this;
    }

    public BulkProcessorBuilder setBlockedWaitTimeout(long blockedWaitTimeout) {
        this.bulkConfig.setBlockedWaitTimeout(blockedWaitTimeout);
        return this;
    }

    public BulkProcessorBuilder setWarnMultsRejects(int warnMultsRejects) {
        this.bulkConfig.setWarnMultsRejects(warnMultsRejects);
        return this;
    }

    public BulkProcessor build() {
        if (this.bulkConfig == null) {
            throw new BulkProcessorException("build BulkProcessor failed:bulkConfig is null.");
        }
        BulkProcessor bulkProcessor = new BulkProcessor(this.bulkConfig);
        bulkProcessor.init();
        return bulkProcessor;
    }

    public BulkProcessorBuilder setElasticsearch(String elasticsearch) {
        this.bulkConfig.setElasticsearch(elasticsearch);
        return this;
    }

    public BulkProcessorBuilder setRefreshOption(String refreshOption) {
        this.bulkConfig.setRefreshOption(refreshOption);
        return this;
    }

    public BulkProcessorBuilder setBulkRejectMessage(String bulkRejectMessage) {
        if (bulkRejectMessage == null) {
            bulkRejectMessage = "Reject bulk processor";
        }
        this.bulkConfig.setBulkRejectMessage(bulkRejectMessage);
        return this;
    }

    public BulkProcessorBuilder setBulkProcessorName(String bulkProcessorName) {
        if (bulkProcessorName == null) {
            bulkProcessorName = "BulkProcessor";
        }
        this.bulkConfig.setBulkProcessorName(bulkProcessorName);
        return this;
    }

    public BulkProcessorBuilder setTimeout(String timeout) {
        this.bulkConfig.setTimeout(timeout);
        return this;
    }

    public BulkProcessorBuilder setMasterTimeout(String masterTimeout) {
        this.bulkConfig.setMasterTimeout(masterTimeout);
        return this;
    }

    public BulkProcessorBuilder setWaitForActiveShards(Integer waitForActiveShards) {
        this.bulkConfig.setWaitForActiveShards(waitForActiveShards);
        return this;
    }

    public BulkProcessorBuilder setRefresh(String refresh) {
        this.bulkConfig.setRefresh(refresh);
        return this;
    }

    public BulkProcessorBuilder setPipeline(String pipeline) {
        this.bulkConfig.setPipeline(pipeline);
        return this;
    }

    public BulkProcessorBuilder setRouting(Object routing) {
        this.bulkConfig.setRouting(routing);
        return this;
    }
}

