/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.bulk;

import java.util.Date;
import java.util.List;
import org.frameworkset.elasticsearch.bulk.BulkConfig;
import org.frameworkset.elasticsearch.bulk.BulkData;
import org.frameworkset.elasticsearch.bulk.BulkInterceptor;
import org.frameworkset.elasticsearch.bulk.BulkProcessor;
import org.frameworkset.elasticsearch.bulk.BulkRetryHandler;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkCommand
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(BulkCommand.class);
    private List<BulkData> batchBulkDatas;
    private BulkProcessor bulkProcessor;
    private ClientInterface clientInterface;
    private Date bulkCommandStartTime;
    private Date bulkCommandCompleteTime;

    public Date getBulkCommandStartTime() {
        return this.bulkCommandStartTime;
    }

    public void setBulkCommandStartTime(Date bulkCommandStartTime) {
        this.bulkCommandStartTime = bulkCommandStartTime;
    }

    public Date getBulkCommandCompleteTime() {
        return this.bulkCommandCompleteTime;
    }

    public void setBulkCommandCompleteTime(Date bulkCommandCompleteTime) {
        this.bulkCommandCompleteTime = bulkCommandCompleteTime;
    }

    public BulkCommand(List<BulkData> batchBulkDatas, BulkProcessor bulkProcessor) {
        this.batchBulkDatas = batchBulkDatas;
        this.bulkProcessor = bulkProcessor;
        this.clientInterface = bulkProcessor.getClientInterface();
    }

    public String getRefreshOption() {
        return this.bulkProcessor.getRefreshOption();
    }

    private void directRun(List<BulkInterceptor> bulkInterceptors) {
        String result = this.clientInterface.executeBulk(this);
        this.bulkProcessor.increamentTotalsize(this.getBulkDataSize());
        boolean hasError = ResultUtil.bulkResponseError(result);
        if (!hasError) {
            for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                BulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                try {
                    bulkInterceptor.afterBulk(this, result);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("bulkInterceptor.afterBulk", (Throwable)e);
                }
            }
        } else {
            for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                BulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                try {
                    bulkInterceptor.errorBulk(this, result);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("bulkInterceptor.errorBulk", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BulkConfig bulkConfig = this.bulkProcessor.getBulkConfig();
        List<BulkInterceptor> bulkInterceptors = bulkConfig.getBulkInterceptors();
        for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
            BulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
            try {
                bulkInterceptor.beforeBulk(this);
                continue;
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error("bulkInterceptor.beforeBulk", (Throwable)e);
            }
        }
        BulkRetryHandler bulkRetryHandler = bulkConfig.getBulkRetryHandler();
        int retryTimes = bulkConfig.getRetryTimes();
        if (bulkRetryHandler == null || retryTimes <= 0) {
            try {
                this.setBulkCommandStartTime(new Date(System.currentTimeMillis()));
                this.directRun(bulkInterceptors);
            }
            catch (Throwable throwable) {
                this.bulkProcessor.increamentFailedSize(this.getBulkDataSize());
                for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                    BulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                    try {
                        bulkInterceptor.exceptionBulk(this, throwable);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("bulkInterceptor.errorBulk", (Throwable)e);
                    }
                }
            }
            finally {
                this.setBulkCommandCompleteTime(new Date(System.currentTimeMillis()));
                if (this.batchBulkDatas != null) {
                    this.batchBulkDatas.clear();
                    this.batchBulkDatas = null;
                }
            }
        } else {
            try {
                this.setBulkCommandStartTime(new Date(System.currentTimeMillis()));
                Exception exception = null;
                int count = 0;
                long retryInterval = bulkConfig.getRetryInterval();
                while (true) {
                    if (count > 0 && logger.isInfoEnabled()) {
                        logger.info("Retry bulkprocess {} times.", (Object)count);
                    }
                    try {
                        this.directRun(bulkInterceptors);
                        exception = null;
                    }
                    catch (Exception e) {
                        exception = e;
                        if (!bulkRetryHandler.neadRetry(e, this) || count == retryTimes) break;
                        if (logger.isErrorEnabled()) {
                            logger.error("Exception occur and  Retry process will be take.", (Throwable)e);
                        }
                        ++count;
                        if (retryInterval <= 0L) continue;
                        try {
                            Thread.sleep(retryInterval);
                        }
                        catch (Exception interupt) {
                            break;
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                this.bulkProcessor.increamentFailedSize(this.getBulkDataSize());
                for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                    BulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                    try {
                        bulkInterceptor.exceptionBulk(this, throwable);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("bulkInterceptor.errorBulk", (Throwable)e);
                    }
                }
            }
            finally {
                this.setBulkCommandCompleteTime(new Date(System.currentTimeMillis()));
                if (this.batchBulkDatas != null) {
                    this.batchBulkDatas.clear();
                    this.batchBulkDatas = null;
                }
            }
        }
    }

    public long getTotalSize() {
        return this.bulkProcessor.getTotalSize();
    }

    public long getTotalFailedSize() {
        return this.bulkProcessor.getFailedSize();
    }

    public BulkProcessor getBulkProcessor() {
        return this.bulkProcessor;
    }

    public List<BulkData> getBatchBulkDatas() {
        return this.batchBulkDatas;
    }

    public void addBulkData(BulkData bulkData) {
        this.batchBulkDatas.add(bulkData);
    }

    public int getBulkDataSize() {
        if (this.batchBulkDatas != null) {
            return this.batchBulkDatas.size();
        }
        return 0;
    }
}

