/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch;

import com.frameworkset.util.SimpleStringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.ElasticsearchParseException;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.template.AOPTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.ESSOAFileApplicationContext;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.assemble.GetProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchHelper {
    private static Logger logger;
    protected static DefaultApplicationContext context;
    public static final String DEFAULT_SEARCH = "elasticSearch";
    protected static ElasticSearch elasticSearchSink;
    private static Map<String, String> geoipConfig;
    private static boolean inited;
    private static long dslfileRefreshInterval;
    private static String dslfileMappingDir;
    private static Method bootMethod;
    private static Map<String, ElasticSearch> elasticSearchMap;

    public static Map<String, String> getGeoipConfig() {
        return geoipConfig;
    }

    public static long getDslfileRefreshInterval() {
        return dslfileRefreshInterval;
    }

    public static String getDslfileMappingDir() {
        return dslfileMappingDir;
    }

    public static void setDslfileRefreshInterval(long dslfileRefreshInterval) {
        ElasticSearchHelper.dslfileRefreshInterval = dslfileRefreshInterval;
    }

    public static void booter(String[] elasticsearchServerNames, GetProperties configContext, boolean forceBoot) {
        ElasticSearchHelper.booter(elasticsearchServerNames, configContext, forceBoot, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void booter(String[] elasticsearchServerNames, GetProperties configContext, boolean forceBoot, boolean fromspringboot) {
        if (inited && !forceBoot) {
            return;
        }
        inited = true;
        ElasticSearch elasticSearchSink = null;
        ElasticSearch firstElasticSearch = null;
        ElasticSearchHelper.initDslFileRefreshInterval(configContext);
        HashMap<String, ElasticSearch> elasticSearchMap = new HashMap<String, ElasticSearch>();
        for (String serverName : elasticsearchServerNames) {
            String useHttps;
            String slowDslCallback;
            if (ElasticSearchHelper.elasticSearchMap.containsKey(serverName) || serverName.equals("default") && ElasticSearchHelper.elasticSearchMap.containsKey(DEFAULT_SEARCH)) continue;
            Properties elasticsearchPropes = new Properties();
            elasticsearchPropes.put("elasticsearch.client", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.client", configContext, "restful"));
            elasticsearchPropes.put("elasticUser", ElasticSearchHelper._getStringValue(serverName, "elasticUser", configContext, ""));
            elasticsearchPropes.put("elasticPassword", ElasticSearchHelper._getStringValue(serverName, "elasticPassword", configContext, ""));
            elasticsearchPropes.put("elasticsearch.rest.hostNames", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.rest.hostNames", configContext, "127.0.0.1:9200"));
            elasticsearchPropes.put("elasticsearch.dateFormat", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.dateFormat", configContext, "yyyy.MM.dd"));
            elasticsearchPropes.put("elasticsearch.timeZone", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.timeZone", configContext, "Asia/Shanghai"));
            elasticsearchPropes.put("elasticsearch.ttl", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.ttl", configContext, "2d"));
            elasticsearchPropes.put("elasticsearch.showTemplate", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.showTemplate", configContext, "false"));
            elasticsearchPropes.put("elasticsearch.httpPool", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.httpPool", configContext, serverName));
            elasticsearchPropes.put("elasticsearch.discoverHost", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.discoverHost", configContext, "false"));
            elasticsearchPropes.put("elasticsearch.sliceScrollThreadCount", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.sliceScrollThreadCount", configContext, "50"));
            elasticsearchPropes.put("elasticsearch.sliceScrollThreadQueue", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.sliceScrollThreadQueue", configContext, "100"));
            elasticsearchPropes.put("elasticsearch.sliceScrollBlockedWaitTimeout", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.sliceScrollBlockedWaitTimeout", configContext, "0"));
            elasticsearchPropes.put("elasticsearch.includeTypeName", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.includeTypeName", configContext, "false"));
            elasticsearchPropes.put("elasticsearch.scrollThreadCount", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.scrollThreadCount", configContext, "50"));
            elasticsearchPropes.put("elasticsearch.scrollThreadQueue", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.scrollThreadQueue", configContext, "200"));
            elasticsearchPropes.put("elasticsearch.scrollBlockedWaitTimeout", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.scrollBlockedWaitTimeout", configContext, "0"));
            elasticsearchPropes.put("elasticsearch.healthCheckInterval", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.healthCheckInterval", configContext, "3000"));
            String slowDslThreshold = ElasticSearchHelper._getStringValue(serverName, "elasticsearch.slowDslThreshold", configContext, null);
            if (slowDslThreshold != null) {
                elasticsearchPropes.put("elasticsearch.slowDslThreshold", slowDslThreshold);
            }
            if ((slowDslCallback = ElasticSearchHelper._getStringValue(serverName, "elasticsearch.slowDslCallback", configContext, null)) != null) {
                elasticsearchPropes.put("elasticsearch.slowDslCallback", slowDslCallback);
            }
            if ((useHttps = ElasticSearchHelper._getStringValue(serverName, "elasticsearch.useHttps", configContext, null)) != null) {
                elasticsearchPropes.put("elasticsearch.useHttps", useHttps);
            }
            ElasticSearch elasticSearch = new ElasticSearch();
            if (firstElasticSearch == null) {
                firstElasticSearch = elasticSearch;
            }
            elasticSearch.setFromspringboot(fromspringboot);
            elasticSearch.setElasticSearchName(serverName);
            elasticSearch.setElasticsearchPropes(elasticsearchPropes);
            elasticSearch.configureWithConfigContext(configContext);
            if (!serverName.equals("default")) {
                elasticSearchMap.put(serverName, elasticSearch);
                continue;
            }
            elasticSearchMap.put(DEFAULT_SEARCH, elasticSearch);
            elasticSearchSink = elasticSearch;
        }
        geoipConfig.put("ip.database", ElasticSearchHelper._getStringValue("", "ip.database", configContext, ""));
        geoipConfig.put("ip.asnDatabase", ElasticSearchHelper._getStringValue("", "ip.asnDatabase", configContext, ""));
        geoipConfig.put("ip.cachesize", ElasticSearchHelper._getStringValue("", "ip.cachesize", configContext, "10000"));
        geoipConfig.put("ip.serviceUrl", ElasticSearchHelper._getStringValue("", "ip.serviceUrl", configContext, ""));
        if (logger.isInfoEnabled()) {
            try {
                logger.info("Geo ipinfo config {},from springboot:{}", (Object)SimpleStringUtil.object2json(geoipConfig), (Object)fromspringboot);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ElasticSearchHelper.elasticSearchSink == null) {
            if (elasticSearchSink == null) {
                elasticSearchSink = firstElasticSearch;
            }
            ElasticSearchHelper.elasticSearchSink = elasticSearchSink;
        }
        if (elasticSearchMap.size() > 0) {
            for (Map.Entry entry : elasticSearchMap.entrySet()) {
                final ElasticSearch elasticSearch = (ElasticSearch)((Object)entry.getValue());
                elasticSearch.start();
                BaseApplicationContext.addShutdownHook((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        elasticSearch.stop();
                    }
                });
            }
            Map<String, ElasticSearch> map = ElasticSearchHelper.elasticSearchMap;
            synchronized (map) {
                ElasticSearchHelper.elasticSearchMap.putAll(elasticSearchMap);
            }
        }
    }

    private static long _getLongValue(String poolName, String propertyName, GetProperties context, long defaultValue) throws Exception {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        long ret = Long.parseLong(_value.trim());
        return ret;
    }

    private static int _getIntValue(String poolName, String propertyName, BaseApplicationContext context, int defaultValue) throws Exception {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        int ret = Integer.parseInt(_value);
        return ret;
    }

    public static String _getStringValue(String poolName, String propertyName, GetProperties context, String defaultValue) {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = !poolName.equals("") ? context.getExternalProperty(poolName + "." + propertyName) : context.getExternalProperty(propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        return _value;
    }

    private static void initDslFileRefreshInterval(GetProperties context) {
        try {
            long _dslfileRefreshInterval;
            dslfileRefreshInterval = _dslfileRefreshInterval = ElasticSearchHelper._getLongValue("default", "dslfile.refreshInterval", context, 5000L);
        }
        catch (Exception _dslfileRefreshInterval) {
            // empty catch block
        }
        String _dslfileMappingDir = ElasticSearchHelper._getStringValue("default", "dslfile.dslMappingDir", context, null);
        if (_dslfileMappingDir != null && !_dslfileMappingDir.trim().equals("")) {
            dslfileMappingDir = _dslfileMappingDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void init() {
        if (inited) {
            return;
        }
        Map<String, ElasticSearch> map = elasticSearchMap;
        synchronized (map) {
            ElasticSearch _elasticSearchSink;
            if (inited) {
                return;
            }
            if (elasticSearchSink == null && (_elasticSearchSink = elasticSearchMap.get(DEFAULT_SEARCH)) == null && !(context = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch.xml")).isEmptyContext()) {
                ElasticSearchHelper.initDslFileRefreshInterval((GetProperties)context);
                _elasticSearchSink = (ElasticSearch)((Object)context.getTBeanObject(DEFAULT_SEARCH, ElasticSearch.class));
                if (_elasticSearchSink != null) {
                    elasticSearchMap.put(DEFAULT_SEARCH, _elasticSearchSink);
                    elasticSearchSink = _elasticSearchSink;
                }
            }
            if (context.isEmptyContext()) {
                if (bootMethod != null) {
                    try {
                        bootMethod.invoke(null, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        throw new ElasticsearchParseException("ElasticSearch load from Boot failed:", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ElasticsearchParseException("ElasticSearch load from Boot failed:", e);
                    }
                } else if (logger.isWarnEnabled()) {
                    logger.warn("ElasticSearch load from Boot warn: No booter found and bootMethod is null!");
                }
            }
            inited = true;
        }
    }

    public static synchronized void stopElasticsearch(String esname) {
        ElasticSearch elasticSearch = ElasticSearchHelper.getElasticSearchSinkOnly(esname);
        if (elasticSearch != null) {
            elasticSearch.stop();
            if (elasticSearch == null || ((Object)((Object)elasticSearch)).equals("") || ((Object)((Object)elasticSearch)).equals("default")) {
                elasticSearchSink = null;
                elasticSearchMap.remove(DEFAULT_SEARCH);
            } else {
                elasticSearchMap.remove(esname);
            }
        }
    }

    public static ElasticSearch getElasticSearchSinkOnly(String elasticSearch) {
        if (elasticSearch == null || elasticSearch.equals("") || elasticSearch.equals("default")) {
            return elasticSearchSink;
        }
        ElasticSearch elasticSearchSink = elasticSearchMap.get(elasticSearch);
        return elasticSearchSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElasticSearch getElasticSearchSink(String elasticSearch) {
        ElasticSearchHelper.init();
        if (elasticSearch == null || elasticSearch.equals("") || elasticSearch.equals("default")) {
            return elasticSearchSink;
        }
        ElasticSearch elasticSearchSink = elasticSearchMap.get(elasticSearch);
        if (elasticSearchSink == null) {
            Map<String, ElasticSearch> map = elasticSearchMap;
            synchronized (map) {
                elasticSearchSink = elasticSearchMap.get(elasticSearch);
                if (elasticSearchSink != null) {
                    return elasticSearchSink;
                }
                context = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch.xml");
                elasticSearchSink = (ElasticSearch)((Object)context.getTBeanObject(elasticSearch, ElasticSearch.class));
                if (elasticSearchSink != null) {
                    elasticSearchMap.put(elasticSearch, elasticSearchSink);
                }
            }
        }
        return elasticSearchSink;
    }

    public static ElasticSearch getElasticSearchSink() {
        ElasticSearchHelper.init();
        return elasticSearchSink;
    }

    public static ClientInterface getRestClientUtil() {
        ElasticSearchHelper.init();
        return elasticSearchSink.getRestClientUtil();
    }

    public static ClientInterface getRestClientUtil(String elasticSearch) {
        ElasticSearch elasticSearchSink = ElasticSearchHelper.getElasticSearchSink(elasticSearch);
        if (elasticSearchSink == null) {
            throw new ElasticSearchException("Elasticsearh Datasource[" + elasticSearch + "] is not configured. please check your configs.");
        }
        return elasticSearchSink.getRestClientUtil();
    }

    public static ClientInterface getConfigRestClientUtil(String configFile) {
        ElasticSearchHelper.init();
        if (elasticSearchSink == null) {
            throw new ElasticSearchException("Elasticsearh Datasource[default] is not configured. please check your configs.");
        }
        return elasticSearchSink.getConfigRestClientUtil(configFile);
    }

    public static AOPTemplateContainerImpl getAOPTemplateContainerImpl(String dslpath) {
        ElasticSearchHelper.init();
        AOPTemplateContainerImpl aopTemplateContainer = new AOPTemplateContainerImpl(dslfileMappingDir, (BaseApplicationContext)new ESSOAFileApplicationContext(dslfileMappingDir, dslpath));
        return aopTemplateContainer;
    }

    public static ClientInterface getConfigRestClientUtil(BaseTemplateContainerImpl templateContainer) {
        ElasticSearchHelper.init();
        if (elasticSearchSink == null) {
            throw new ElasticSearchException("Elasticsearh Datasource[default] is not configured. please check your configs.");
        }
        return elasticSearchSink.getConfigRestClientUtil(templateContainer);
    }

    public static ClientInterface getConfigRestClientUtil(String elasticSearch, String configFile) {
        ElasticSearch elasticSearchSink = ElasticSearchHelper.getElasticSearchSink(elasticSearch);
        if (elasticSearchSink == null) {
            throw new ElasticSearchException("Elasticsear Datasource[" + elasticSearch + "] is not configured. please check your configs.");
        }
        return elasticSearchSink.getConfigRestClientUtil(configFile);
    }

    public static ClientInterface getConfigRestClientUtil(String elasticSearch, BaseTemplateContainerImpl templateContainer) {
        ElasticSearch elasticSearchSink = ElasticSearchHelper.getElasticSearchSink(elasticSearch);
        if (elasticSearchSink == null) {
            throw new ElasticSearchException("Elasticsear Datasource[" + elasticSearch + "] is not configured. please check your configs.");
        }
        return elasticSearchSink.getConfigRestClientUtil(templateContainer);
    }

    public static void addHttpServer(List<String> hosts) {
    }

    static {
        block4: {
            logger = LoggerFactory.getLogger(ElasticSearchHelper.class);
            context = null;
            elasticSearchSink = null;
            geoipConfig = new HashMap<String, String>();
            dslfileRefreshInterval = 5000L;
            try {
                Class<?> booterClass = Class.forName("org.frameworkset.elasticsearch.boot.ElasticSearchConfigBoot");
                bootMethod = booterClass.getMethod("boot", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("ElasticSearch load from Boot ignore: org.frameworkset.elasticsearch.boot.ElasticSearchConfigBoot Not found!");
                }
            }
            catch (NoSuchMethodException e) {
                if (!logger.isWarnEnabled()) break block4;
                logger.warn("ElasticSearch load from Boot ignore: boot method Not found in org.frameworkset.elasticsearch.boot.ElasticSearchConfigBoot!");
            }
        }
        elasticSearchMap = new HashMap<String, ElasticSearch>();
    }
}

