/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.mongodb.input;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.client.model.DBCollectionFindOptions;
import java.util.Date;
import org.frameworkset.nosql.mongodb.MongoDB;
import org.frameworkset.nosql.mongodb.MongoDBConfig;
import org.frameworkset.nosql.mongodb.MongoDBHelper;
import org.frameworkset.tran.BaseDataTranPlugin;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.mongodb.MongoDBContext;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.util.TimeUtil;

public abstract class MongoDBInputPlugin
extends BaseDataTranPlugin
implements DataTranPlugin {
    private MongoDBContext es2DBContext;

    protected void init(ImportContext importContext, ImportContext targetImportContext) {
        super.init(importContext, targetImportContext);
        this.es2DBContext = (MongoDBContext)importContext;
    }

    public MongoDBInputPlugin(ImportContext importContext, ImportContext targetImportContext) {
        super(importContext, targetImportContext);
    }

    public void beforeInit() {
        this.initMongoDB();
    }

    protected void initMongoDB() {
        MongoDBConfig mongoDBConfig = new MongoDBConfig();
        mongoDBConfig.setName(this.es2DBContext.getName());
        mongoDBConfig.setCredentials(this.es2DBContext.getCredentials());
        mongoDBConfig.setServerAddresses(this.es2DBContext.getServerAddresses());
        mongoDBConfig.setOption(this.es2DBContext.getOption());
        mongoDBConfig.setWriteConcern(this.es2DBContext.getWriteConcern());
        mongoDBConfig.setReadPreference(this.es2DBContext.getReadPreference());
        mongoDBConfig.setAutoConnectRetry(this.es2DBContext.getAutoConnectRetry());
        mongoDBConfig.setConnectionsPerHost(this.es2DBContext.getConnectionsPerHost());
        mongoDBConfig.setMaxWaitTime(this.es2DBContext.getMaxWaitTime());
        mongoDBConfig.setSocketTimeout(this.es2DBContext.getSocketTimeout());
        mongoDBConfig.setConnectTimeout(this.es2DBContext.getConnectTimeout());
        mongoDBConfig.setThreadsAllowedToBlockForConnectionMultiplier(this.es2DBContext.getThreadsAllowedToBlockForConnectionMultiplier());
        mongoDBConfig.setSocketKeepAlive(this.es2DBContext.getSocketKeepAlive());
        mongoDBConfig.setMode(this.es2DBContext.getMode());
        MongoDBHelper.init((MongoDBConfig)mongoDBConfig);
    }

    public void afterInit() {
    }

    public void initStatusTableId() {
        if (this.isIncreamentImport()) {
            String statusTableId = this.es2DBContext.getDB() + "|" + this.es2DBContext.getDBCollection() + "|" + this.es2DBContext.getServerAddresses();
            if (this.es2DBContext.getQuery() != null) {
                statusTableId = statusTableId + "|" + this.es2DBContext.getQuery().toString();
            }
            this.importContext.setStatusTableId(statusTableId.hashCode());
        }
    }

    private void commonImportData(TaskContext taskContext) throws Exception {
        DBObject dbObject = this.es2DBContext.getQuery();
        if (dbObject == null) {
            dbObject = new BasicDBObject();
        }
        this.exportESData(dbObject, taskContext);
    }

    private void exportESData(DBObject dbObject, TaskContext taskContext) {
        MongoDB mogodb = MongoDBHelper.getMongoDB((String)this.es2DBContext.getName());
        DB db = mogodb.getDB(this.es2DBContext.getDB());
        DBCollection dbCollection = db.getCollection(this.es2DBContext.getDBCollection());
        DBCollectionFindOptions dbCollectionFindOptions = null;
        if (this.es2DBContext.getDBCollectionFindOptions() != null) {
            dbCollectionFindOptions = this.es2DBContext.getDBCollectionFindOptions();
            dbCollectionFindOptions.batchSize(this.importContext.getFetchSize().intValue());
        } else {
            dbCollectionFindOptions = new DBCollectionFindOptions();
            dbCollectionFindOptions.batchSize(this.importContext.getFetchSize().intValue());
        }
        if (this.es2DBContext.getFetchFields() != null) {
            dbCollectionFindOptions.projection(this.es2DBContext.getFetchFields());
        }
        DBCursor dbCursor = dbCollection.find(dbObject, dbCollectionFindOptions);
        this.doTran(dbCursor, taskContext);
    }

    protected abstract void doTran(DBCursor var1, TaskContext var2);

    private void increamentImportData(TaskContext taskContext) throws Exception {
        DBObject dbObject = this.es2DBContext.getQuery();
        if (dbObject == null) {
            dbObject = new BasicDBObject();
        }
        this.putLastParamValue((BasicDBObject)dbObject);
        this.exportESData(dbObject, taskContext);
    }

    public void putLastParamValue(BasicDBObject query) {
        if (this.lastValueType == 0) {
            query.append(this.getLastValueVarName(), (Object)new BasicDBObject("$gt", this.currentStatus.getLastValue()));
        } else {
            Object lv = null;
            lv = this.currentStatus.getLastValue() instanceof Date ? this.currentStatus.getLastValue() : (this.currentStatus.getLastValue() instanceof Long ? new Date((Long)this.currentStatus.getLastValue()) : (this.currentStatus.getLastValue() instanceof Integer ? new Date(((Integer)this.currentStatus.getLastValue()).longValue()) : (this.currentStatus.getLastValue() instanceof Short ? new Date(((Short)this.currentStatus.getLastValue()).longValue()) : new Date(((Number)this.currentStatus.getLastValue()).longValue()))));
            if (this.importContext.increamentEndOffset() != null) {
                Date lastOffsetValue = TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                BasicDBObject basicDBObject = new BasicDBObject();
                basicDBObject.put((Object)"$gt", lv);
                basicDBObject.put((Object)"$lte", (Object)lastOffsetValue);
                query.append(this.getLastValueVarName(), (Object)basicDBObject);
            } else {
                query.append(this.getLastValueVarName(), (Object)new BasicDBObject("$gt", lv));
            }
        }
        if (this.isPrintTaskLog()) {
            this.logger.info("Current values: " + query);
        }
    }

    public void doImportData(TaskContext taskContext) throws ESDataImportException {
        try {
            if (!this.isIncreamentImport()) {
                this.commonImportData(taskContext);
            } else {
                this.increamentImportData(taskContext);
            }
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException((Throwable)e);
        }
    }
}

