/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.mongodb;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Date;
import org.bson.types.ObjectId;
import org.frameworkset.tran.DefaultTranMetaData;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.LastValue;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.util.TranUtil;

public class MongoDBResultSet
extends LastValue
implements TranResultSet {
    private DBCursor dbCursor;
    private DBObject record;

    public MongoDBResultSet(ImportContext importContext, DBCursor dbCursor) {
        this.importContext = importContext;
        this.dbCursor = dbCursor;
    }

    public Object getValue(int i, String colName, int sqlType) throws ESDataImportException {
        return this.getValue(colName);
    }

    public Object getValue(String colName) throws ESDataImportException {
        Object value = this.record.get(colName);
        if (value != null && colName.equals("_id") && value instanceof ObjectId) {
            return ((ObjectId)value).toString();
        }
        return value;
    }

    public Object getValue(String colName, int sqlType) throws ESDataImportException {
        return this.getValue(colName);
    }

    public Date getDateTimeValue(String colName) throws ESDataImportException {
        Object value = this.getValue(colName);
        if (value == null) {
            return null;
        }
        return TranUtil.getDateTimeValue((String)colName, (Object)value, (ImportContext)this.importContext);
    }

    public Boolean next() throws ESDataImportException {
        boolean hasNext = this.dbCursor.hasNext();
        if (hasNext) {
            this.record = this.dbCursor.next();
        }
        return hasNext;
    }

    public TranMeta getMetaData() {
        return new DefaultTranMetaData((Object)this.record.keySet());
    }

    public Object getKeys() {
        return this.record.keySet();
    }

    public Object getRecord() {
        return this.record;
    }

    public void stop() {
    }

    public void stopTranOnly() {
    }

    public Object getMetaValue(String fieldName) {
        return null;
    }

    public boolean removed() {
        return false;
    }

    public boolean reachEOFClosed() {
        return false;
    }
}

