/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.mongodb;

import com.mongodb.DBObject;
import com.mongodb.client.model.DBCollectionFindOptions;
import java.util.ArrayList;
import java.util.List;
import org.frameworkset.nosql.mongodb.ClientMongoCredential;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.DBExportBuilder;
import org.frameworkset.tran.db.DBImportConfig;
import org.frameworkset.tran.es.ESExportResultHandler;
import org.frameworkset.tran.mongodb.MongoDBImportConfig;
import org.frameworkset.tran.mongodb.MongoDBImportContext;

public abstract class MongoDBExportBuilder
extends DBExportBuilder {
    private String name;
    private String serverAddresses;
    private String option;
    private String writeConcern;
    private String readPreference;
    private Boolean autoConnectRetry = true;
    private int connectionsPerHost = 50;
    private int maxWaitTime = 120000;
    private int socketTimeout = 0;
    private int connectTimeout = 15000;
    private int threadsAllowedToBlockForConnectionMultiplier = 5;
    private Boolean socketKeepAlive = false;
    private String mode;
    private DBCollectionFindOptions dbCollectionFindOptions;
    private DBObject query;
    private DBObject fetchFields;
    private String dbCollection;
    private String db;
    private List<ClientMongoCredential> credentials;

    public String getName() {
        return this.name;
    }

    protected ImportContext buildImportContext(BaseImportConfig importConfig) {
        MongoDBImportContext mongoDBImportContext = new MongoDBImportContext((MongoDBImportConfig)importConfig);
        mongoDBImportContext.init();
        return mongoDBImportContext;
    }

    public MongoDBExportBuilder buildClientMongoCredential(String database, String userName, String password, String mechanism) {
        if (this.credentials == null) {
            this.credentials = new ArrayList<ClientMongoCredential>();
        }
        ClientMongoCredential clientMongoCredential = new ClientMongoCredential();
        clientMongoCredential.setDatabase(database);
        clientMongoCredential.setMechanism(mechanism);
        clientMongoCredential.setUserName(userName);
        clientMongoCredential.setPassword(password);
        this.credentials.add(clientMongoCredential);
        return this;
    }

    protected void setTargetImportContext(DataStream dataStream) {
        dataStream.setTargetImportContext(dataStream.getImportContext());
    }

    public MongoDBExportBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public String getServerAddresses() {
        return this.serverAddresses;
    }

    public MongoDBExportBuilder setServerAddresses(String serverAddresses) {
        this.serverAddresses = serverAddresses;
        return this;
    }

    public String getOption() {
        return this.option;
    }

    public MongoDBExportBuilder setOption(String option) {
        this.option = option;
        return this;
    }

    public String getWriteConcern() {
        return this.writeConcern;
    }

    public MongoDBExportBuilder setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    public String getReadPreference() {
        return this.readPreference;
    }

    public MongoDBExportBuilder setReadPreference(String readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    public Boolean getAutoConnectRetry() {
        return this.autoConnectRetry;
    }

    public MongoDBExportBuilder setAutoConnectRetry(Boolean autoConnectRetry) {
        this.autoConnectRetry = autoConnectRetry;
        return this;
    }

    public int getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    public MongoDBExportBuilder setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
        return this;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public MongoDBExportBuilder setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
        return this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public MongoDBExportBuilder setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public MongoDBExportBuilder setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public MongoDBExportBuilder setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
        return this;
    }

    public Boolean getSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public MongoDBExportBuilder setSocketKeepAlive(Boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
        return this;
    }

    public String getMode() {
        return this.mode;
    }

    public MongoDBExportBuilder setMode(String mode) {
        this.mode = mode;
        return this;
    }

    protected WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        return new ESExportResultHandler(exportResultHandler);
    }

    public DataStream builder() {
        super.builderConfig();
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("MongoDB Import Configs:");
                this.logger.info(this.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MongoDBImportConfig es2DBImportConfig = new MongoDBImportConfig();
        super.buildImportConfig((BaseImportConfig)es2DBImportConfig);
        es2DBImportConfig.setName(this.name);
        es2DBImportConfig.setServerAddresses(this.serverAddresses);
        es2DBImportConfig.setOption(this.option);
        es2DBImportConfig.setWriteConcern(this.writeConcern);
        es2DBImportConfig.setReadPreference(this.readPreference);
        es2DBImportConfig.setAutoConnectRetry(this.autoConnectRetry);
        es2DBImportConfig.setConnectionsPerHost(this.connectionsPerHost);
        es2DBImportConfig.setMaxWaitTime(this.maxWaitTime);
        es2DBImportConfig.setSocketTimeout(this.socketTimeout);
        es2DBImportConfig.setConnectTimeout(this.connectTimeout);
        es2DBImportConfig.setThreadsAllowedToBlockForConnectionMultiplier(this.threadsAllowedToBlockForConnectionMultiplier);
        es2DBImportConfig.setSocketKeepAlive(this.socketKeepAlive);
        es2DBImportConfig.setMode(this.mode);
        es2DBImportConfig.setDbCollectionFindOptions(this.dbCollectionFindOptions);
        es2DBImportConfig.setQuery(this.query);
        es2DBImportConfig.setFetchFields(this.fetchFields);
        es2DBImportConfig.setDbCollection(this.dbCollection);
        es2DBImportConfig.setDb(this.db);
        es2DBImportConfig.setCredentials(this.credentials);
        super.buildDBImportConfig((DBImportConfig)es2DBImportConfig);
        DataStream dataStream = this.createDataStream();
        dataStream.setImportConfig((BaseImportConfig)es2DBImportConfig);
        dataStream.setImportContext(this.buildImportContext((BaseImportConfig)es2DBImportConfig));
        this.setTargetImportContext(dataStream);
        dataStream.setDataTranPlugin(this.buildDataTranPlugin(dataStream.getImportContext(), dataStream.getTargetImportContext()));
        return dataStream;
    }

    public DBCollectionFindOptions getDBCollectionFindOptions() {
        return this.dbCollectionFindOptions;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public String getDBCollection() {
        return this.dbCollection;
    }

    public String getDB() {
        return this.db;
    }

    public MongoDBExportBuilder setDbCollectionFindOptions(DBCollectionFindOptions dbCollectionFindOptions) {
        this.dbCollectionFindOptions = dbCollectionFindOptions;
        return this;
    }

    public MongoDBExportBuilder setQuery(DBObject dbObject) {
        this.query = dbObject;
        return this;
    }

    public MongoDBExportBuilder setDbCollection(String dbCollection) {
        this.dbCollection = dbCollection;
        return this;
    }

    public MongoDBExportBuilder setDb(String db) {
        this.db = db;
        return this;
    }

    public DBObject getFetchFields() {
        return this.fetchFields;
    }

    public MongoDBExportBuilder setFetchFields(DBObject fetchFields) {
        this.fetchFields = fetchFields;
        return this;
    }
}

