/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.status;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.SQLExecutor;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.status.BaseStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiStatusManager
extends BaseStatusManager {
    private static Logger logger = LoggerFactory.getLogger(MultiStatusManager.class);
    private Map<String, WrapStatus> statuses = new LinkedHashMap<String, WrapStatus>();
    private long liveTime = 86400000L;
    private long lastUpdateTime;

    public MultiStatusManager(String statusDbname, String updateSQL, int lastValueType, DataTranPlugin dataTranPlugin) {
        super(statusDbname, updateSQL, lastValueType, dataTranPlugin);
    }

    @Override
    protected void _putStatus(Status currentStatus) {
        WrapStatus wrapStatus = this.statuses.get(currentStatus.getFileId());
        if (wrapStatus == null) {
            wrapStatus = new WrapStatus();
            wrapStatus.currentStatus = currentStatus;
            wrapStatus.lastPutTime = System.currentTimeMillis();
            this.statuses.put(currentStatus.getFileId(), wrapStatus);
        } else {
            wrapStatus.currentStatus = currentStatus;
            wrapStatus.lastPutTime = System.currentTimeMillis();
        }
    }

    @Override
    protected void _flushStatus() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("flushStatus start.");
        }
        ArrayList<Status> datas = new ArrayList<Status>();
        ArrayList<Status> removeDatas = new ArrayList<Status>();
        Set<Map.Entry<String, WrapStatus>> statusSet = this.statuses.entrySet();
        WrapStatus wrapStatus = null;
        long interval = 0L;
        long ntime = System.currentTimeMillis();
        for (Map.Entry<String, WrapStatus> entry : statusSet) {
            wrapStatus = entry.getValue();
            if (this.lastUpdateTime < wrapStatus.lastPutTime) {
                datas.add(wrapStatus.currentStatus);
                continue;
            }
            interval = ntime - wrapStatus.lastPutTime;
            if (interval < this.liveTime) continue;
            removeDatas.add(wrapStatus.currentStatus);
        }
        if (datas.size() > 0) {
            SQLExecutor.executeBatch((String)this.statusDbname, (String)this.updateSQL, datas, (int)100, (BatchHandler)new BatchHandler<Status>(){

                public void handler(PreparedStatement stmt, Status record, int i) throws SQLException {
                    stmt.setLong(1, record.getTime());
                    stmt.setObject(2, record.getLastValue());
                    stmt.setInt(3, MultiStatusManager.this.lastValueType);
                    stmt.setString(4, record.getFilePath());
                    stmt.setString(5, record.getFileId());
                    stmt.setInt(6, record.getStatus());
                    stmt.setInt(7, record.getId());
                }
            });
            this.lastUpdateTime = System.currentTimeMillis();
            for (Status status : removeDatas) {
                this.statuses.remove(status.getFileId());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("flush {} Statuses end .", (Object)datas.size());
        }
    }

    static class WrapStatus {
        Status currentStatus;
        long lastPutTime;

        WrapStatus() {
        }
    }
}

