/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.es.input.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.DBImportConfig;
import org.frameworkset.tran.db.DBImportContext;
import org.frameworkset.tran.es.input.ESExportBuilder;
import org.frameworkset.tran.es.input.db.ES2DBDataTranPlugin;

public class ES2DBExportBuilder
extends ESExportBuilder {
    @JsonIgnore
    private DBImportConfig dbmportConfig;

    public void setOutputDBConfig(DBImportConfig dbmportConfig) {
        this.dbmportConfig = dbmportConfig;
    }

    @Override
    public DataTranPlugin buildDataTranPlugin(ImportContext importContext, ImportContext targetImportContext) {
        return new ES2DBDataTranPlugin(importContext, targetImportContext);
    }

    @Override
    protected ImportContext buildTargetImportContext(BaseImportConfig importConfig) {
        DBImportContext dbImportContext = new DBImportContext(importConfig);
        dbImportContext.init();
        return dbImportContext;
    }

    @Override
    public DataStream builder() {
        DataStream dataStream = super.builder();
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ES2DB Import Configs:");
                this.logger.info(this.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dbmportConfig != null) {
            dataStream.setTargetImportContext(this.buildTargetImportContext(this.dbmportConfig));
        } else {
            dataStream.setTargetImportContext(dataStream.getImportContext());
        }
        dataStream.setDataTranPlugin(this.buildDataTranPlugin(dataStream.getImportContext(), dataStream.getTargetImportContext()));
        return dataStream;
    }
}

