/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.es.input.db;

import com.frameworkset.common.poolman.ConfigSQLExecutor;
import java.util.concurrent.CountDownLatch;
import org.frameworkset.elasticsearch.entity.MetaMap;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.output.AsynDBOutPutDataTran;
import org.frameworkset.tran.db.output.DBOutPutContext;
import org.frameworkset.tran.es.input.ESInputPlugin;
import org.frameworkset.tran.es.input.db.ESDirectExporterScrollHandler;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.util.TranUtil;

public class ES2DBDataTranPlugin
extends ESInputPlugin
implements DataTranPlugin {
    protected ConfigSQLExecutor executor;
    protected DBOutPutContext dbOutPutContext;

    public ES2DBDataTranPlugin(ImportContext importContext, ImportContext targetImportContext) {
        super(importContext, targetImportContext);
        this.dbOutPutContext = (DBOutPutContext)((Object)targetImportContext);
    }

    @Override
    public void beforeInit() {
        super.beforeInit();
        if (this.dbOutPutContext.getTargetDBConfig() != null) {
            this.initDS(this.dbOutPutContext.getTargetDBConfig());
        }
        if (this.importContext.getDbConfig() != null) {
            this.initDS(this.importContext.getDbConfig());
        }
        this.initOtherDSes(this.importContext.getConfigs());
    }

    @Override
    public void afterInit() {
        this.executor = TranUtil.initTargetSQLInfo(this.dbOutPutContext, this.dbOutPutContext.getTargetDBConfig() != null ? this.dbOutPutContext.getTargetDBConfig() : this.importContext.getDbConfig());
    }

    @Override
    protected BaseDataTran createBaseDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, CountDownLatch countDownLatch, Status currentStatus) {
        AsynDBOutPutDataTran asynDBOutPutDataTran = new AsynDBOutPutDataTran(taskContext, jdbcResultSet, this.importContext, this.targetImportContext, countDownLatch, currentStatus);
        asynDBOutPutDataTran.init();
        return asynDBOutPutDataTran;
    }

    @Override
    public void doImportData(TaskContext taskContext) throws ESDataImportException {
        if (this.dbOutPutContext.getBatchHandler() != null) {
            this.doBatchHandler(taskContext);
        } else {
            super.doImportData(taskContext);
        }
    }

    @Override
    protected void doBatchHandler(TaskContext taskContext) {
        ESDirectExporterScrollHandler<MetaMap> esDirectExporterScrollHandler = new ESDirectExporterScrollHandler<MetaMap>(this.importContext, this.targetImportContext, this.executor);
        try {
            if (!this.isIncreamentImport()) {
                this.commonImportData(taskContext, esDirectExporterScrollHandler);
            } else {
                this.increamentImportData(taskContext, esDirectExporterScrollHandler);
            }
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }
}

