/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db.output;

import com.frameworkset.util.VariableHandler;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.Param;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.DBRecord;
import org.frameworkset.tran.db.output.Base2DBTaskCommandImpl;
import org.frameworkset.tran.db.output.DBOutPutContext;
import org.frameworkset.tran.db.output.TranSQLInfo;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.ParallImportCount;
import org.frameworkset.tran.metrics.SerialImportCount;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskCall;
import org.slf4j.Logger;

public class DBOutPutDataTran
extends BaseDataTran {
    protected DBOutPutContext es2DBContext;
    private String taskInfo;

    @Override
    public void logTaskStart(Logger logger) {
        logger.info(this.taskInfo + " start.");
    }

    @Override
    public void init() {
        super.init();
        this.es2DBContext = this.targetImportContext == null ? (DBOutPutContext)((Object)this.importContext) : (DBOutPutContext)((Object)this.targetImportContext);
        DBConfig dbConfig = null;
        dbConfig = this.es2DBContext.getTargetDBConfig() == null ? this.importContext.getDbConfig() : this.es2DBContext.getTargetDBConfig();
        StringBuilder builder = new StringBuilder().append("Import data to db[").append(dbConfig.getDbUrl()).append("] dbuser[").append(dbConfig.getDbUser()).append("]");
        if (this.es2DBContext.getTargetSqlInfo() != null) {
            builder.append(" insert sql[").append(this.es2DBContext.getTargetSqlInfo().getOriginSQL()).append("]");
        }
        if (this.es2DBContext.getTargetUpdateSqlInfo() != null) {
            builder.append("\r\nupdate sql[").append(this.es2DBContext.getTargetUpdateSqlInfo().getOriginSQL()).append("]");
        }
        if (this.es2DBContext.getTargetDeleteSqlInfo() != null) {
            builder.append("\r\ndelete sql[").append(this.es2DBContext.getTargetDeleteSqlInfo().getOriginSQL()).append("]");
        }
        this.taskInfo = builder.toString();
    }

    public DBOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, targetImportContext, currentStatus);
    }

    @Override
    public String serialExecute() {
        Object lastValue = null;
        Throwable exception = null;
        long start = System.currentTimeMillis();
        Status currentStatus = this.currentStatus;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        SerialImportCount importCount = new SerialImportCount();
        int taskNo = 0;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        boolean reachEOFClosed = false;
        try {
            Object temp = null;
            Object param = null;
            ArrayList<DBRecord> records = new ArrayList<DBRecord>();
            while (true) {
                Boolean hasNext;
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    if (records.size() > 0) {
                        Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(importCount, this.importContext, this.targetImportContext, records, ++taskNo, importCount.getJobNo(), this.taskInfo, true, lastValue, currentStatus, reachEOFClosed);
                        TaskCall.call(taskCommand);
                        records.clear();
                        if (this.isPrintTaskLog()) {
                            long end = System.currentTimeMillis();
                            this.logger.info("Serial import Force flush records Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records.");
                        }
                    }
                    if (!this.isPrintTaskLog()) continue;
                    long end = System.currentTimeMillis();
                    this.logger.info("Serial import Force flush datas Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                try {
                    lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                    Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, null);
                    if (!reachEOFClosed) {
                        reachEOFClosed = context.reachEOFClosed();
                    }
                    if (context.removed()) {
                        if (!reachEOFClosed) {
                            ((ImportCount)importCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                        continue;
                    }
                    context.refactorData();
                    context.afterRefactor();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    DBRecord record = this.buildRecord(context);
                    records.add(record);
                    ++totalCount;
                }
                catch (Exception e) {
                    throw new ElasticSearchException((Throwable)e);
                }
            }
            if (records.size() > 0) {
                Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(importCount, this.importContext, this.targetImportContext, records, ++taskNo, importCount.getJobNo(), this.taskInfo, true, lastValue, currentStatus, reachEOFClosed);
                TaskCall.call(taskCommand);
            }
            if (this.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                this.logger.info("Serial import All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records.");
            }
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition((Exception)exception, this.importContext)) {
                if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                    this.stop();
                } else {
                    this.stopTranOnly();
                }
            }
            if (this.importContext.isCurrentStoped()) {
                this.stopTranOnly();
            }
            importCount.setJobEndTime(new Date());
        }
        return null;
    }

    private DBRecord buildRecord(Context context) {
        List<VariableHandler.Variable> vars = null;
        Object temp = null;
        Param param = null;
        DBRecord dbRecord = new DBRecord();
        TranSQLInfo insertSqlinfo = this.es2DBContext.getTargetSqlInfo();
        TranSQLInfo updateSqlinfo = this.es2DBContext.getTargetUpdateSqlInfo();
        TranSQLInfo deleteSqlinfo = this.es2DBContext.getTargetDeleteSqlInfo();
        if (context.isInsert()) {
            dbRecord.setAction(0);
            vars = insertSqlinfo.getVars();
        } else if (context.isUpdate()) {
            dbRecord.setAction(1);
            vars = updateSqlinfo.getVars();
        } else {
            dbRecord.setAction(2);
            vars = deleteSqlinfo.getVars();
        }
        ArrayList<Param> record = new ArrayList<Param>();
        HashMap<String, Object> addedFields = new HashMap<String, Object>();
        List<FieldMeta> fieldValueMetas = context.getFieldValues();
        this.appendFieldValues(record, vars, fieldValueMetas, addedFields);
        fieldValueMetas = context.getESJDBCFieldValues();
        this.appendFieldValues(record, vars, fieldValueMetas, addedFields);
        String varName = null;
        for (int i = 0; i < vars.size(); ++i) {
            VariableHandler.Variable var = vars.get(i);
            if (addedFields.get(var.getVariableName()) != null) continue;
            varName = var.getVariableName();
            FieldMeta fieldMeta = context.getMappingName(varName);
            if (fieldMeta != null) {
                if (fieldMeta.getIgnore() != null && fieldMeta.getIgnore().booleanValue()) continue;
                varName = fieldMeta.getEsFieldName();
            }
            if ((temp = this.jdbcResultSet.getValue(varName)) == null && this.logger.isWarnEnabled()) {
                this.logger.warn("\u672a\u6307\u5b9a\u7ed1\u5b9a\u53d8\u91cf\u7684\u503c\uff1a{}", (Object)var.getVariableName());
            }
            param = new Param();
            param.setVariable(var);
            param.setIndex(var.getPosition() + 1);
            param.setValue(temp);
            param.setName(var.getVariableName());
            record.add(param);
        }
        dbRecord.setParams(record);
        return dbRecord;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute() {
        boolean reachEOFClosed;
        TranErrorWrapper tranErrorWrapper;
        Object lastValue;
        Throwable exception;
        ParallImportCount totalCount;
        ArrayList<Future> tasks;
        ExecutorService service;
        block19: {
            int count = 0;
            service = this.importContext.buildThreadPool();
            tasks = new ArrayList<Future>();
            int taskNo = 0;
            totalCount = new ParallImportCount();
            exception = null;
            Status currentStatus = this.currentStatus;
            Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
            lastValue = null;
            tranErrorWrapper = new TranErrorWrapper(this.importContext);
            int batchsize = this.importContext.getStoreBatchSize();
            reachEOFClosed = false;
            try {
                block18: {
                    TranSQLInfo sqlinfo = this.es2DBContext.getTargetSqlInfo();
                    Object temp = null;
                    Object param = null;
                    ArrayList<DBRecord> records = new ArrayList<DBRecord>();
                    while (true) {
                        Boolean hasNext;
                        if (!tranErrorWrapper.assertCondition()) {
                            tranErrorWrapper.throwError();
                        }
                        if ((hasNext = this.jdbcResultSet.next()) == null) {
                            if (count <= 0) continue;
                            count = 0;
                            Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, records, ++taskNo, totalCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed);
                            records = new ArrayList();
                            tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                            continue;
                        }
                        if (!hasNext.booleanValue()) {
                            if (count > 0) {
                                break;
                            }
                            break block18;
                        }
                        lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                        Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, null);
                        if (!reachEOFClosed) {
                            reachEOFClosed = context.reachEOFClosed();
                        }
                        if (context.removed()) {
                            if (!reachEOFClosed) {
                                ((ImportCount)totalCount).increamentIgnoreTotalCount();
                                continue;
                            }
                            this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                            continue;
                        }
                        context.refactorData();
                        context.afterRefactor();
                        if (context.isDrop()) {
                            ((ImportCount)totalCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        DBRecord record = this.buildRecord(context);
                        records.add(record);
                        if (++count < batchsize) continue;
                        count = 0;
                        Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, records, ++taskNo, totalCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed);
                        records = new ArrayList();
                        tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    }
                    if (!tranErrorWrapper.assertCondition()) {
                        tranErrorWrapper.throwError();
                    }
                    Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, records, ++taskNo, totalCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed);
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    if (this.isPrintTaskLog()) {
                        this.logger.info("Pararrel batchsubmit tasks:" + taskNo);
                    }
                    break block19;
                }
                if (this.isPrintTaskLog()) {
                    this.logger.info("Pararrel batchsubmit tasks:" + taskNo);
                }
            }
            catch (SQLException e) {
                try {
                    exception = e;
                    throw new ElasticSearchException((Throwable)e);
                    catch (ElasticSearchException e2) {
                        exception = e2;
                        throw e2;
                    }
                    catch (Exception e3) {
                        exception = e3;
                        throw new ElasticSearchException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper, null, reachEOFClosed);
                    totalCount.setJobEndTime(new Date());
                    throw throwable;
                }
            }
        }
        this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper, null, reachEOFClosed);
        totalCount.setJobEndTime(new Date());
        return null;
    }

    @Override
    public String batchExecute() {
        int count = 0;
        String ret = null;
        int taskNo = 0;
        Throwable exception = null;
        Status currentStatus = this.currentStatus;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        TranErrorWrapper tranErrorWrapper = new TranErrorWrapper(this.importContext);
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        SerialImportCount importCount = new SerialImportCount();
        int batchsize = this.importContext.getStoreBatchSize();
        boolean reachEOFClosed = false;
        try {
            istart = start;
            ArrayList<DBRecord> records = new ArrayList<DBRecord>();
            while (true) {
                Boolean hasNext;
                if (!tranErrorWrapper.assertCondition()) {
                    this.jdbcResultSet.stop();
                    tranErrorWrapper.throwError();
                }
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    if (count <= 0) continue;
                    Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(importCount, this.importContext, this.targetImportContext, records, ++taskNo, importCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed);
                    int temp = count;
                    count = 0;
                    records = new ArrayList();
                    ret = TaskCall.call(taskCommand);
                    if (this.isPrintTaskLog()) {
                        end = System.currentTimeMillis();
                        this.logger.info("Batch import Force flush datas Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + temp + " records.");
                        istart = end;
                    }
                    totalCount += (long)temp;
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, null);
                if (!reachEOFClosed) {
                    reachEOFClosed = context.reachEOFClosed();
                }
                if (context.removed()) {
                    if (!reachEOFClosed) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                    continue;
                }
                context.refactorData();
                context.afterRefactor();
                if (context.isDrop()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                DBRecord record = this.buildRecord(context);
                records.add(record);
                if (++count < batchsize) continue;
                Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(importCount, this.importContext, this.targetImportContext, records, ++taskNo, importCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed);
                int temp = count;
                count = 0;
                records = new ArrayList();
                ret = TaskCall.call(taskCommand);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + temp + " records.");
                    istart = end;
                }
                totalCount += (long)temp;
            }
            if (count > 0) {
                if (!tranErrorWrapper.assertCondition()) {
                    tranErrorWrapper.throwError();
                }
                Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(importCount, this.importContext, this.targetImportContext, records, ++taskNo, importCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed);
                ret = TaskCall.call(taskCommand);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + count + " records.");
                }
                totalCount += (long)count;
            }
            if (this.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                this.logger.info("Batch import Execute Tasks:" + taskNo + ",All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!tranErrorWrapper.assertCondition((Exception)exception)) {
                if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                    this.stop();
                } else {
                    this.stopTranOnly();
                }
            }
            importCount.setJobEndTime(new Date());
        }
        return ret;
    }

    private void appendFieldValues(List<Param> record, List<VariableHandler.Variable> vars, List<FieldMeta> fieldValueMetas, Map<String, Object> addedFields) {
        if (fieldValueMetas == null || fieldValueMetas.size() == 0) {
            return;
        }
        boolean i = false;
        Param param = null;
        block0: for (VariableHandler.Variable variable : vars) {
            if (addedFields.containsKey(variable.getVariableName())) continue;
            for (FieldMeta fieldMeta : fieldValueMetas) {
                if (!variable.getVariableName().equals(fieldMeta.getEsFieldName())) continue;
                param = new Param();
                param.setVariable(variable);
                param.setIndex(variable.getPosition() + 1);
                param.setValue(fieldMeta.getValue());
                param.setName(variable.getVariableName());
                record.add(param);
                addedFields.put(variable.getVariableName(), dummy);
                continue block0;
            }
        }
    }
}

