/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db.input.db;

import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.DefualtExportResultHandler;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.DBExportBuilder;
import org.frameworkset.tran.db.DBImportConfig;
import org.frameworkset.tran.db.input.db.DB2DBDataTranPlugin;

public class DB2DBExportBuilder
extends DBExportBuilder {
    private DBConfig targetDBConfig;

    public static DB2DBExportBuilder newInstance() {
        return new DB2DBExportBuilder();
    }

    @Override
    public DataTranPlugin buildDataTranPlugin(ImportContext importContext, ImportContext targetImportContext) {
        return new DB2DBDataTranPlugin(importContext, targetImportContext);
    }

    @Override
    protected WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        return new DefualtExportResultHandler(exportResultHandler);
    }

    private void checkTargetDBConfig() {
        if (this.targetDBConfig == null) {
            this.targetDBConfig = new DBConfig();
        }
    }

    @Override
    public DataStream builder() {
        super.builderConfig();
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("DB2DB Import Configs:");
                this.logger.info(this.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DBImportConfig db2DBImportConfig = new DBImportConfig();
        super.buildImportConfig(db2DBImportConfig);
        db2DBImportConfig.setUseJavaName(false);
        db2DBImportConfig.setTargetDBConfig(this.targetDBConfig);
        super.buildDBImportConfig(db2DBImportConfig);
        DataStream dataStream = this.createDataStream();
        dataStream.setImportConfig(db2DBImportConfig);
        dataStream.setImportContext(this.buildImportContext(db2DBImportConfig));
        dataStream.setTargetImportContext(dataStream.getImportContext());
        dataStream.setDataTranPlugin(this.buildDataTranPlugin(dataStream.getImportContext(), dataStream.getTargetImportContext()));
        return dataStream;
    }

    public DB2DBExportBuilder setTargetDbDriver(String targetDbDriver) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbDriver(targetDbDriver);
        return this;
    }

    public DB2DBExportBuilder setTargetDbUrl(String targetDbUrl) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbUrl(targetDbUrl);
        return this;
    }

    public DB2DBExportBuilder setTargetDbUser(String targetDbUser) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbUser(targetDbUser);
        return this;
    }

    public DB2DBExportBuilder setTargetDbPassword(String targetDbPassword) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbPassword(targetDbPassword);
        return this;
    }

    public DB2DBExportBuilder setTargetInitSize(int targetInitSize) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setInitSize(targetInitSize);
        return this;
    }

    public DB2DBExportBuilder setTargetMinIdleSize(int targetMinIdleSize) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setMinIdleSize(targetMinIdleSize);
        return this;
    }

    public DB2DBExportBuilder setTargetMaxSize(int targetMaxSize) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setMaxSize(targetMaxSize);
        return this;
    }

    public DB2DBExportBuilder setTargetDbName(String targetDbName) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbName(targetDbName);
        return this;
    }

    public DB2DBExportBuilder setTargetShowSql(boolean targetShowSql) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setShowSql(targetShowSql);
        return this;
    }

    public DB2DBExportBuilder setTargetUsePool(boolean targetUsePool) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setUsePool(targetUsePool);
        return this;
    }

    public DB2DBExportBuilder setTargetDbtype(String targetDbtype) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbtype(targetDbtype);
        return this;
    }

    public DB2DBExportBuilder setTargetDbAdaptor(String targetDbAdaptor) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbAdaptor(targetDbAdaptor);
        return this;
    }

    public DB2DBExportBuilder setTargetValidateSQL(String validateSQL) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setValidateSQL(validateSQL);
        return this;
    }
}

