/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import com.frameworkset.common.poolman.handle.ValueExchange;
import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import com.frameworkset.util.SimpleStringUtil;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.elasticsearch.template.ESUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.config.ClientOptions;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.JDBCGetVariableValue;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.ParallImportCount;
import org.frameworkset.tran.metrics.SerialImportCount;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskCall;
import org.frameworkset.tran.task.TaskCommandImpl;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;

public class BaseElasticsearchDataTran
extends BaseDataTran {
    private ClientInterface[] clientInterfaces;
    private boolean versionUpper7;
    protected String taskInfo;
    private String elasticsearch;
    public static final Class[] basePrimaryTypes = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, Float.TYPE, Short.TYPE, Double.TYPE, Character.TYPE, Byte.TYPE, BigInteger.class, BigDecimal.class};

    @Override
    public void logTaskStart(Logger logger) {
        logger.info(this.taskInfo);
    }

    private void initClientInterfaces(String elasticsearchs) {
        if (elasticsearchs != null) {
            String[] _elasticsearchs = elasticsearchs.split(",");
            this.clientInterfaces = new ClientInterface[_elasticsearchs.length];
            for (int i = 0; i < _elasticsearchs.length; ++i) {
                this.clientInterfaces[i] = ElasticSearchHelper.getRestClientUtil((String)_elasticsearchs[i]);
            }
        } else {
            this.clientInterfaces = new ClientInterface[1];
            this.clientInterfaces[0] = ElasticSearchHelper.getRestClientUtil((String)"default");
        }
        if (this.clientInterfaces != null && this.clientInterfaces.length > 0) {
            this.versionUpper7 = this.clientInterfaces[0].isVersionUpper7();
        }
    }

    public BaseElasticsearchDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, targetImportContext, currentStatus);
        String elasticsearch = targetImportContext.getTargetElasticsearch();
        if (elasticsearch == null) {
            elasticsearch = "default";
        }
        this.elasticsearch = elasticsearch;
    }

    @Override
    public void init() {
        super.init();
        this.initClientInterfaces(this.elasticsearch);
        if (this.targetImportContext.getEsIndexWrapper() == null) {
            throw new ESDataImportException("Global Elasticsearch index must be setted, please check your import job builder config.");
        }
        this.taskInfo = "import data to elasticsearch[" + this.elasticsearch + "] " + " IndexName[" + this.targetImportContext.getEsIndexWrapper().getIndex() + "] IndexType[" + this.targetImportContext.getEsIndexWrapper().getType() + "] start.";
    }

    public BaseElasticsearchDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, String esCluster, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, targetImportContext, currentStatus);
        this.elasticsearch = esCluster;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute() {
        block26: {
            count = 0;
            builder = new StringBuilder();
            writer = new BBossStringWriter(builder);
            ret = null;
            service = this.importContext.buildThreadPool();
            tasks = new ArrayList<Future>();
            taskNo = 0;
            totalCount = new ParallImportCount();
            exception = null;
            currentStatus = this.currentStatus;
            currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
            lastValue = null;
            tranErrorWrapper = new TranErrorWrapper(this.importContext);
            batchsize = this.importContext.getStoreBatchSize();
            reachEOFClosed = false;
            try {
                block25: {
                    batchContext = new BatchContext();
                    block10: while (true) {
                        if (!tranErrorWrapper.assertCondition()) {
                            this.jdbcResultSet.stop();
                            tranErrorWrapper.throwError();
                        }
                        if ((hasNext = this.jdbcResultSet.next()) == null) {
                            if (count <= 0) continue;
                            writer.flush();
                            datas = builder.toString();
                            builder.setLength(0);
                            writer.close();
                            writer = new BBossStringWriter(builder);
                            _count = count;
                            count = 0;
                            var20_25 = this.clientInterfaces;
                            var21_28 = var20_25.length;
                            var22_31 = 0;
                            while (true) {
                                if (var22_31 >= var21_28) continue block10;
                                clientInterface = var20_25[var22_31];
                                taskCommand = new TaskCommandImpl(totalCount, this.importContext, this.targetImportContext, _count, ++taskNo, totalCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                                taskCommand.setClientInterface(clientInterface);
                                taskCommand.setDatas(datas);
                                tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                                ++var22_31;
                            }
                        }
                        if (!hasNext.booleanValue()) {
                            if (count > 0) {
                                break;
                            }
                            break block25;
                        }
                        lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                        context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, batchContext);
                        if (!reachEOFClosed) {
                            reachEOFClosed = context.reachEOFClosed();
                        }
                        if (context.removed()) {
                            if (!reachEOFClosed) {
                                totalCount.increamentIgnoreTotalCount();
                                continue;
                            }
                            this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                            continue;
                        }
                        context.refactorData();
                        context.afterRefactor();
                        if (context.isDrop()) {
                            totalCount.increamentIgnoreTotalCount();
                            continue;
                        }
                        this.evalBuilk(this.jdbcResultSet, batchContext, (Writer)writer, context, this.versionUpper7);
                        if (++count < batchsize) continue;
                        writer.flush();
                        datas = builder.toString();
                        builder.setLength(0);
                        writer.close();
                        writer = new BBossStringWriter(builder);
                        _count = count;
                        count = 0;
                        var21_29 = this.clientInterfaces;
                        var22_31 = var21_29.length;
                        var23_35 = 0;
                        while (true) {
                            if (var23_35 < var22_31) ** break;
                            continue block10;
                            clientInterface = var21_29[var23_35];
                            taskCommand = new TaskCommandImpl(totalCount, this.importContext, this.targetImportContext, _count, ++taskNo, totalCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                            taskCommand.setClientInterface(clientInterface);
                            taskCommand.setDatas(datas);
                            tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                            ++var23_35;
                        }
                        break;
                    }
                    if (!tranErrorWrapper.assertCondition()) {
                        tranErrorWrapper.throwError();
                    }
                    writer.flush();
                    datas = builder.toString();
                    for (ClientInterface clientInterface : this.clientInterfaces) {
                        taskCommand = new TaskCommandImpl(totalCount, this.importContext, this.targetImportContext, count, ++taskNo, totalCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                        taskCommand.setClientInterface(clientInterface);
                        taskCommand.setDatas(datas);
                        tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    }
                    if (this.isPrintTaskLog()) {
                        this.logger.info("Pararrel batchsubmit tasks:" + taskNo);
                    }
                    break block26;
                }
                if (this.isPrintTaskLog()) {
                    this.logger.info("Pararrel batchsubmit tasks:" + taskNo);
                }
            }
            catch (SQLException e) {
                try {
                    exception = e;
                    throw new ElasticSearchException((Throwable)e);
                    catch (ElasticSearchException e) {
                        exception = e;
                        throw e;
                    }
                    catch (Exception e) {
                        exception = e;
                        throw new ElasticSearchException((Throwable)e);
                    }
                }
                catch (Throwable var26_38) {
                    this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper, null, reachEOFClosed);
                    try {
                        writer.close();
                    }
                    catch (Exception var27_39) {
                        // empty catch block
                    }
                    totalCount.setJobEndTime(new Date());
                    throw var26_38;
                }
            }
        }
        this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper, null, reachEOFClosed);
        try {
            writer.close();
        }
        catch (Exception batchContext) {
            // empty catch block
        }
        totalCount.setJobEndTime(new Date());
        return ret;
    }

    @Override
    public String batchExecute() {
        int count = 0;
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        String ret = null;
        int taskNo = 0;
        Throwable exception = null;
        Status currentStatus = this.currentStatus;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        SerialImportCount importCount = new SerialImportCount();
        int batchsize = this.importContext.getStoreBatchSize();
        boolean reachEOFClosed = false;
        try {
            istart = start;
            BatchContext batchContext = new BatchContext();
            while (true) {
                Boolean hasNext;
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    if (count <= 0) continue;
                    writer.flush();
                    String datas = builder.toString();
                    builder.setLength(0);
                    writer.close();
                    writer = new BBossStringWriter(builder);
                    int _count = count;
                    count = 0;
                    for (ClientInterface clientInterface : this.clientInterfaces) {
                        TaskCommandImpl taskCommand = new TaskCommandImpl(importCount, this.importContext, this.targetImportContext, _count, ++taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                        taskCommand.setClientInterface(clientInterface);
                        taskCommand.setDatas(datas);
                        ret = TaskCall.call(taskCommand);
                    }
                    if (this.isPrintTaskLog()) {
                        end = System.currentTimeMillis();
                        this.logger.info("Batch import Force flush datas Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + _count + " records.");
                        istart = end;
                    }
                    totalCount += (long)_count;
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, batchContext);
                if (!reachEOFClosed) {
                    reachEOFClosed = context.reachEOFClosed();
                }
                if (context.removed()) {
                    if (!reachEOFClosed) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                    continue;
                }
                context.refactorData();
                context.afterRefactor();
                if (context.isDrop()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                this.evalBuilk(this.jdbcResultSet, batchContext, (Writer)writer, context, this.versionUpper7);
                if (++count < batchsize) continue;
                writer.flush();
                String datas = builder.toString();
                builder.setLength(0);
                writer.close();
                writer = new BBossStringWriter(builder);
                int _count = count;
                count = 0;
                for (ClientInterface clientInterface : this.clientInterfaces) {
                    TaskCommandImpl taskCommand = new TaskCommandImpl(importCount, this.importContext, this.targetImportContext, _count, ++taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                    taskCommand.setClientInterface(clientInterface);
                    taskCommand.setDatas(datas);
                    ret = TaskCall.call(taskCommand);
                }
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + batchsize + " records.");
                    istart = end;
                }
                totalCount += (long)count;
            }
            if (count > 0) {
                writer.flush();
                String datas = builder.toString();
                for (ClientInterface clientInterface : this.clientInterfaces) {
                    TaskCommandImpl taskCommand = new TaskCommandImpl(importCount, this.importContext, this.targetImportContext, count, ++taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                    taskCommand.setClientInterface(clientInterface);
                    taskCommand.setDatas(datas);
                    ret = TaskCall.call(taskCommand);
                }
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + count + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                }
                totalCount += (long)count;
            }
            if (this.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                this.logger.info("Batch import Execute Tasks:" + taskNo + ",All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (SQLException e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition((Exception)exception, this.importContext)) {
                if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                    this.stop();
                } else {
                    this.stopTranOnly();
                }
            }
            try {
                writer.close();
            }
            catch (Exception exception2) {}
            importCount.setJobEndTime(new Date());
        }
        return ret;
    }

    @Override
    public String serialExecute() {
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        Object lastValue = null;
        Throwable exception = null;
        long start = System.currentTimeMillis();
        Status currentStatus = this.currentStatus;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        long totalCount = 0L;
        SerialImportCount importCount = new SerialImportCount();
        long ignoreTotalCount = 0L;
        boolean reachEOFClosed = false;
        try {
            BatchContext batchContext = new BatchContext();
            while (true) {
                Boolean hasNext;
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    writer.flush();
                    String ret = null;
                    if (builder.length() > 0) {
                        String _dd = builder.toString();
                        builder.setLength(0);
                        ClientInterface[] clientInterfaceArray = this.clientInterfaces;
                        int n = clientInterfaceArray.length;
                        for (int i = 0; i < n; ++i) {
                            ClientInterface clientInterface = clientInterfaceArray[i];
                            TaskCommandImpl taskCommand = new TaskCommandImpl(importCount, this.importContext, this.targetImportContext, totalCount, 1, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                            taskCommand.setClientInterface(clientInterface);
                            taskCommand.setDatas(_dd);
                            ret = TaskCall.call(taskCommand);
                        }
                    } else {
                        ret = "{\"took\":0,\"errors\":false}";
                    }
                    if (!this.isPrintTaskLog()) continue;
                    long end = System.currentTimeMillis();
                    this.logger.info("Serial import Force flush datas Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                try {
                    lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                    Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, batchContext);
                    if (!reachEOFClosed) {
                        reachEOFClosed = context.reachEOFClosed();
                    }
                    if (context.removed()) {
                        if (!reachEOFClosed) {
                            ((ImportCount)importCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                        continue;
                    }
                    context.refactorData();
                    context.afterRefactor();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    this.evalBuilk(this.jdbcResultSet, batchContext, (Writer)writer, context, this.versionUpper7);
                    ++totalCount;
                }
                catch (Exception e) {
                    throw new ElasticSearchException((Throwable)e);
                }
            }
            writer.flush();
            String ret = null;
            if (builder.length() > 0) {
                String _dd = builder.toString();
                builder.setLength(0);
                for (ClientInterface clientInterface : this.clientInterfaces) {
                    TaskCommandImpl taskCommand = new TaskCommandImpl(importCount, this.importContext, this.targetImportContext, totalCount, 1, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                    taskCommand.setClientInterface(clientInterface);
                    taskCommand.setDatas(_dd);
                    ret = TaskCall.call(taskCommand);
                }
            } else {
                ret = "{\"took\":0,\"errors\":false}";
            }
            if (this.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                this.logger.info("Serial import All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
            String string = ret;
            return string;
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition((Exception)exception, this.importContext)) {
                if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                    this.stop();
                } else {
                    this.stopTranOnly();
                }
            }
            importCount.setJobEndTime(new Date());
        }
    }

    public String tran(String indexName, String indexType) throws ElasticSearchException {
        ESIndexWrapper esIndexWrapper = new ESIndexWrapper(indexName, indexType);
        this.targetImportContext.setEsIndexWrapper(esIndexWrapper);
        return this.tran();
    }

    public static void buildMeta(Context context, Writer writer, boolean upper7) throws Exception {
        String pipeline;
        Object versionType;
        Object version;
        Object id = context.getEsId();
        Object parentId = context.getParentId();
        Object routing = context.getRouting();
        ClientOptions clientOptions = context.getClientOptions();
        Object esRetryOnConflict = clientOptions != null ? clientOptions.getEsRetryOnConflict() : null;
        ESIndexWrapper esIndexWrapper = context.getESIndexWrapper();
        JDBCGetVariableValue jdbcGetVariableValue = new JDBCGetVariableValue(context);
        writer.write("{ \"");
        writer.write(context.getOperation());
        writer.write("\" : { \"_index\" : \"");
        if (esIndexWrapper == null) {
            throw new ESDataImportException(" ESIndex not seted.");
        }
        BuildTool.buildIndiceName((ESIndexWrapper)esIndexWrapper, (Writer)writer, (ESIndexWrapper.GetVariableValue)jdbcGetVariableValue);
        writer.write("\"");
        if (!upper7) {
            writer.write(", \"_type\" : \"");
            if (esIndexWrapper == null) {
                throw new ESDataImportException(" ESIndex type not seted.");
            }
            String indexType = BuildTool.buildIndiceType((ESIndexWrapper)esIndexWrapper, (ESIndexWrapper.GetVariableValue)jdbcGetVariableValue);
            if (indexType == null || indexType.equals("")) {
                throw new ESDataImportException(" ESIndex type not seted.");
            }
            writer.write(indexType);
            writer.write("\"");
        }
        if (id != null) {
            writer.write(", \"_id\" : ");
            BuildTool.buildId((Object)id, (Writer)writer, (boolean)true);
        }
        if (parentId != null) {
            writer.write(", \"parent\" : ");
            BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
        }
        if (routing != null) {
            if (!upper7) {
                writer.write(", \"_routing\" : ");
            } else {
                writer.write(", \"routing\" : ");
            }
            BuildTool.buildId((Object)routing, (Writer)writer, (boolean)true);
        }
        if (esRetryOnConflict != null) {
            if (!upper7) {
                writer.write(",\"_retry_on_conflict\":");
            } else {
                writer.write(",\"retry_on_conflict\":");
            }
            writer.write(String.valueOf(esRetryOnConflict));
        }
        if ((version = context.getVersion()) != null) {
            writer.write(",\"_version\":");
            writer.write(String.valueOf(version));
        }
        Object object = versionType = clientOptions != null ? clientOptions.getVersionType() : null;
        if (versionType != null) {
            writer.write(",\"_version_type\":\"");
            writer.write(String.valueOf(versionType));
            writer.write("\"");
        }
        if (upper7) {
            Long if_primary_term;
            Long if_seq_no;
            Long l = if_seq_no = clientOptions != null ? clientOptions.getIfSeqNo() : null;
            if (if_seq_no != null) {
                writer.write(",\"if_seq_no\":");
                writer.write(String.valueOf(if_seq_no));
            }
            Long l2 = if_primary_term = clientOptions != null ? clientOptions.getIfPrimaryTerm() : null;
            if (if_primary_term != null) {
                writer.write(",\"if_primary_term\":");
                writer.write(String.valueOf(if_primary_term));
            }
        }
        String string = pipeline = clientOptions != null ? clientOptions.getPipeline() : null;
        if (pipeline != null) {
            writer.write(",\"pipeline\":\"");
            writer.write(pipeline);
            writer.write("\"");
        }
        if (context.isInsert()) {
            String op_type;
            String string2 = op_type = clientOptions != null ? clientOptions.getOpType() : null;
            if (op_type != null) {
                writer.write(",\"op_type\":\"");
                writer.write(op_type);
                writer.write("\"");
            }
        }
        writer.write(" } }\n");
    }

    public void evalBuilk(TranResultSet jdbcResultSet, BatchContext batchContext, Writer writer, Context context, boolean upper7) throws Exception {
        String action = context.getOperation();
        if (context.isInsert()) {
            BaseElasticsearchDataTran.buildMeta(context, writer, upper7);
            this.serialResult(writer, context);
            writer.write("\n");
        } else if (context.isUpdate()) {
            List<String> sourceUpdateIncludes;
            List<String> sourceUpdateExcludes;
            Boolean esReturnSource;
            Object detect_noop;
            Object esDocAsUpsert;
            BaseElasticsearchDataTran.buildMeta(context, writer, upper7);
            writer.write("{\"doc\":");
            this.serialResult(writer, context);
            ClientOptions clientOptions = context.getClientOptions();
            Object object = esDocAsUpsert = clientOptions != null ? clientOptions.getDocasupsert() : null;
            if (esDocAsUpsert != null) {
                writer.write(",\"doc_as_upsert\":");
                writer.write(String.valueOf(esDocAsUpsert));
            }
            Object object2 = detect_noop = clientOptions != null ? clientOptions.getDetectNoop() : null;
            if (detect_noop != null) {
                writer.write(",\"detect_noop\":");
                writer.write(detect_noop.toString());
            }
            Boolean bl = esReturnSource = clientOptions != null ? clientOptions.getReturnSource() : null;
            if (esReturnSource != null) {
                writer.write(",\"_source\":");
                writer.write(String.valueOf(esReturnSource));
            }
            List<String> list = sourceUpdateExcludes = clientOptions != null ? clientOptions.getSourceUpdateExcludes() : null;
            if (sourceUpdateExcludes != null && !upper7) {
                writer.write(",\"_source_excludes\":");
                SerialUtil.object2json(sourceUpdateExcludes, (Writer)writer);
            }
            List<String> list2 = sourceUpdateIncludes = clientOptions != null ? clientOptions.getSourceUpdateIncludes() : null;
            if (sourceUpdateIncludes != null && !upper7) {
                writer.write(",\"_source_includes\":");
                SerialUtil.object2json(sourceUpdateIncludes, (Writer)writer);
            }
            writer.write("}\n");
        } else if (context.isDelete()) {
            BaseElasticsearchDataTran.evalDeleteBuilk(writer, context, upper7);
        } else {
            BaseElasticsearchDataTran.buildMeta(context, writer, upper7);
            this.serialResult(writer, context);
            writer.write("\n");
        }
    }

    public static void evalDeleteBuilk(Writer writer, Context context, boolean isUpper7) throws Exception {
        BaseElasticsearchDataTran.buildMeta(context, writer, isUpper7);
    }

    private void serialResult(Writer writer, Context context) throws Exception {
        TranMeta metaData = context.getMetaData();
        int counts = metaData != null ? metaData.getColumnCount() : 0;
        writer.write("{");
        Boolean useJavaName = context.getUseJavaName();
        if (useJavaName == null) {
            useJavaName = true;
        }
        Boolean useLowcase = context.getUseLowcase();
        if (useJavaName == null) {
            useJavaName = false;
        }
        if (useLowcase == null) {
            useLowcase = false;
        }
        boolean hasSeted = false;
        HashMap<String, Object> addedFields = new HashMap<String, Object>();
        List<FieldMeta> fieldValueMetas = context.getFieldValues();
        hasSeted = this.appendFieldValues(writer, context, fieldValueMetas, hasSeted, addedFields);
        fieldValueMetas = context.getESJDBCFieldValues();
        hasSeted = this.appendFieldValues(writer, context, fieldValueMetas, hasSeted, addedFields);
        for (int i = 0; i < counts; ++i) {
            Object value;
            String colName = metaData.getColumnLabelByIndex(i);
            if (colName.equals("_id")) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Field [_id] is a metadata field and cannot be added inside a document. Use the index API request parameters.");
                continue;
            }
            int sqlType = metaData.getColumnTypeByIndex(i);
            String javaName = null;
            FieldMeta fieldMeta = context.getMappingName(colName);
            if (fieldMeta != null) {
                if (fieldMeta.getIgnore() != null && fieldMeta.getIgnore().booleanValue()) continue;
                javaName = fieldMeta.getEsFieldName();
            } else if (useJavaName.booleanValue()) {
                javaName = metaData.getColumnJavaNameByIndex(i);
            } else {
                String string = javaName = useLowcase == false ? colName : metaData.getColumnLabelLowerByIndex(i);
            }
            if (javaName == null) {
                javaName = colName;
            }
            if (addedFields.containsKey(javaName) || (value = context.getValue(i, colName, sqlType)) == null && this.importContext.isIgnoreNullValueField()) continue;
            if (hasSeted) {
                writer.write(",");
            } else {
                hasSeted = true;
            }
            writer.write("\"");
            writer.write(javaName);
            writer.write("\":");
            if (value != null) {
                CharEscapeUtil charEscapeUtil;
                String dataStr;
                if (value instanceof String) {
                    writer.write("\"");
                    CharEscapeUtil charEscapeUtil2 = new CharEscapeUtil(writer);
                    charEscapeUtil2.writeString((String)value, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Date) {
                    DateFormateMeta dateFormateMeta;
                    DateFormat dateFormat = null;
                    if (fieldMeta != null && (dateFormateMeta = fieldMeta.getDateFormateMeta()) != null) {
                        dateFormat = dateFormateMeta.toDateFormat();
                    }
                    if (dateFormat == null) {
                        dateFormat = context.getDateFormat();
                    }
                    String dataStr2 = ESUtil.getDate((Date)((Date)value), (DateFormat)dateFormat);
                    writer.write("\"");
                    writer.write(dataStr2);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Clob) {
                    dataStr = ValueExchange.getStringFromClob((Clob)((Clob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Blob) {
                    dataStr = ValueExchange.getStringFromBlob((Blob)((Blob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                SimpleStringUtil.object2json((Object)value, (Writer)writer);
                continue;
            }
            writer.write("null");
        }
        writer.write("}");
    }

    private boolean appendFieldValues(Writer writer, Context context, List<FieldMeta> fieldValueMetas, boolean hasSeted, Map<String, Object> addedFields) throws IOException {
        if (fieldValueMetas != null && fieldValueMetas.size() > 0) {
            for (int i = 0; i < fieldValueMetas.size(); ++i) {
                FieldMeta fieldMeta = fieldValueMetas.get(i);
                String javaName = fieldMeta.getEsFieldName();
                if (addedFields.containsKey(javaName)) {
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("Ignore adding duplicate field[" + javaName + "] value[" + fieldMeta.getValue() + "].");
                    continue;
                }
                Object value = fieldMeta.getValue();
                if (hasSeted) {
                    writer.write(",");
                } else {
                    hasSeted = true;
                }
                writer.write("\"");
                writer.write(javaName);
                writer.write("\":");
                if (value != null) {
                    if (value instanceof String) {
                        writer.write("\"");
                        CharEscapeUtil charEscapeUtil = new CharEscapeUtil(writer);
                        charEscapeUtil.writeString((String)value, true);
                        writer.write("\"");
                    } else if (value instanceof Date) {
                        DateFormateMeta dateFormateMeta;
                        DateFormat dateFormat = null;
                        if (fieldMeta != null && (dateFormateMeta = fieldMeta.getDateFormateMeta()) != null) {
                            dateFormat = dateFormateMeta.toDateFormat();
                        }
                        if (dateFormat == null) {
                            dateFormat = context.getDateFormat();
                        }
                        String dataStr = ESUtil.getDate((Date)((Date)value), (DateFormat)dateFormat);
                        writer.write("\"");
                        writer.write(dataStr);
                        writer.write("\"");
                    } else if (BaseElasticsearchDataTran.isBasePrimaryType(value.getClass())) {
                        writer.write(String.valueOf(value));
                    } else {
                        SimpleStringUtil.object2json((Object)value, (Writer)writer);
                    }
                } else {
                    writer.write("null");
                }
                addedFields.put(javaName, dummy);
            }
        }
        return hasSeted;
    }

    public static boolean isBasePrimaryType(Class type) {
        if (!type.isArray()) {
            if (type.isEnum()) {
                return true;
            }
            for (Class primaryType : basePrimaryTypes) {
                if (!primaryType.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

