package org.frameworkset.tran.es;
/**
 * Copyright 2008 biaoping.yin
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.HashMap;
import java.util.Map;

/**
 * <p>Description: es数据源配置</p>
 * <p></p>
 * <p>Copyright (c) 2018</p>
 * @Date 2020/1/4 11:48
 * @author biaoping.yin
 * @version 1.0
 */
public class ESConfig implements java.io.Serializable{
	private String name;
	private Map<String,Object> configs;
	public ESConfig(){
		this.configs = new HashMap<String, Object>();
	}
	public Map<String, Object> getConfigs() {
		return configs;
	}

	public String getName() {
		return name;
	}

	public ESConfig setName(String name) {
		this.name = name;
		return this;
	}
	public ESConfig addElasticsearchProperty(String name,String value){
		configs.put(name,value);
		return this;
	}
}
