/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.bulk.BulkActionConfig;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.handler.ESVoidResponseHandler;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCommandImpl
extends BaseTaskCommand<String, String> {
    private ClientInterface clientInterface;
    private String datas;
    private int tryCount;
    private static Logger logger = LoggerFactory.getLogger(TaskCommand.class);

    public TaskCommandImpl(ImportCount importCount, ImportContext importContext, ImportContext targetImportContext, long dataSize, int taskNo, String jobNo, Object lastValue, Status currentStatus, boolean reachEOFClosed) {
        super(importCount, importContext, targetImportContext, dataSize, taskNo, jobNo, lastValue, currentStatus, reachEOFClosed);
    }

    public ClientInterface getClientInterface() {
        return this.clientInterface;
    }

    @Override
    public String getDatas() {
        return this.datas;
    }

    public void setClientInterface(ClientInterface clientInterface) {
        this.clientInterface = clientInterface;
    }

    @Override
    public void setDatas(String datas) {
        this.datas = datas;
    }

    @Override
    public String execute() {
        String data = null;
        if (this.importContext.getMaxRetry() > 0 && this.tryCount >= this.importContext.getMaxRetry()) {
            throw new TaskFailedException("task execute failed:reached max retry times " + this.importContext.getMaxRetry());
        }
        ++this.tryCount;
        if (this.importContext.isDebugResponse()) {
            data = this.clientInterface.executeHttp(BuildTool.buildActionUrl((BulkActionConfig)this.targetImportContext.getClientOptions(), (String)"took,errors,items.*.error"), this.datas, "post");
            this.finishTask();
            if (logger.isInfoEnabled()) {
                logger.info(data);
            }
        } else {
            if (this.importContext.isDiscardBulkResponse() && this.importContext.getExportResultHandler() == null) {
                ESVoidResponseHandler esVoidResponseHandler = new ESVoidResponseHandler();
                this.clientInterface.executeHttp(BuildTool.buildActionUrl((BulkActionConfig)this.targetImportContext.getClientOptions(), (String)"took,errors,items.*.error"), this.datas, "post", (ResponseHandler)esVoidResponseHandler);
                if (esVoidResponseHandler.getElasticSearchException() != null) {
                    throw esVoidResponseHandler.getElasticSearchException();
                }
                this.finishTask();
                return null;
            }
            data = this.clientInterface.executeHttp(BuildTool.buildActionUrl((BulkActionConfig)this.targetImportContext.getClientOptions(), (String)"took,errors,items.*.error"), this.datas, "post");
            this.finishTask();
        }
        return data;
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }
}

