/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.ouput.dummy;

import com.frameworkset.orm.annotation.BatchContext;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.tran.BaseCommonRecordDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.ParallImportCount;
import org.frameworkset.tran.metrics.SerialImportCount;
import org.frameworkset.tran.ouput.dummy.DummyOupputContext;
import org.frameworkset.tran.ouput.dummy.DummyTaskCommandImpl;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskCall;
import org.frameworkset.tran.util.TranUtil;
import org.slf4j.Logger;

public class DummyOutPutDataTran
extends BaseCommonRecordDataTran {
    protected DummyOupputContext dummyOupputContext;
    protected CountDownLatch countDownLatch;
    private String taskInfo;

    @Override
    public void logTaskStart(Logger logger) {
        logger.info(this.taskInfo + " start.");
    }

    @Override
    public void stop() {
        if (this.esTranResultSet != null) {
            this.esTranResultSet.stop();
            this.esTranResultSet = null;
        }
        super.stop();
    }

    @Override
    public void stopTranOnly() {
        if (this.esTranResultSet != null) {
            this.esTranResultSet.stopTranOnly();
            this.esTranResultSet = null;
        }
        super.stopTranOnly();
    }

    @Override
    public void init() {
        super.init();
        this.dummyOupputContext = (DummyOupputContext)((Object)this.targetImportContext);
        this.taskInfo = "import data to dummy";
    }

    @Override
    public String tran() throws ESDataImportException {
        try {
            String ret;
            String string = ret = super.tran();
            return string;
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
    }

    public DummyOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, targetImportContext, currentStatus);
    }

    public DummyOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, CountDownLatch countDownLatch, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, targetImportContext, currentStatus);
        this.countDownLatch = countDownLatch;
    }

    @Override
    public String serialExecute() {
        this.logger.info("serial import data Execute started.");
        StringBuilder builder = null;
        BBossStringWriter writer = null;
        if (this.dummyOupputContext.isPrintRecord()) {
            builder = new StringBuilder();
            writer = new BBossStringWriter(builder);
        }
        Object lastValue = null;
        Exception exception = null;
        long start = System.currentTimeMillis();
        Status currentStatus = this.currentStatus;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        SerialImportCount importCount = new SerialImportCount();
        int taskNo = 0;
        long totalCount = 0L;
        int count = 0;
        long ignoreTotalCount = 0L;
        boolean reachEOFClosed = false;
        try {
            Object temp = null;
            Object param = null;
            while (true) {
                Boolean hasNext;
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    String ret = null;
                    if (count > 0) {
                        String _dd = null;
                        if (this.dummyOupputContext.isPrintRecord()) {
                            _dd = builder.toString();
                            builder.setLength(0);
                        }
                        int _count = count;
                        count = 0;
                        DummyTaskCommandImpl taskCommand = new DummyTaskCommandImpl(importCount, this.importContext, this.targetImportContext, _count, taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                        taskCommand.setDatas(_dd);
                        ret = TaskCall.call(taskCommand);
                        ++taskNo;
                    } else {
                        ret = "{\"took\":0,\"errors\":false}";
                    }
                    if (!this.isPrintTaskLog()) continue;
                    long end = System.currentTimeMillis();
                    this.logger.info("Force flush datas Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                try {
                    lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                    Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, null);
                    if (!reachEOFClosed) {
                        reachEOFClosed = context.reachEOFClosed();
                    }
                    if (context.removed()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    context.refactorData();
                    context.afterRefactor();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    CommonRecord record = this.buildRecord(context);
                    this.dummyOupputContext.generateReocord(context, record, (Writer)writer);
                    if (this.dummyOupputContext.isPrintRecord()) {
                        writer.write(TranUtil.lineSeparator);
                    }
                    ++totalCount;
                    ++count;
                }
                catch (Exception e) {
                    throw new DataImportException(e);
                }
            }
            if (count > 0) {
                DummyTaskCommandImpl taskCommand = new DummyTaskCommandImpl(importCount, this.importContext, this.targetImportContext, count, taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                ++taskNo;
                if (this.dummyOupputContext.isPrintRecord()) {
                    taskCommand.setDatas(builder.toString());
                    builder.setLength(0);
                }
                TaskCall.call(taskCommand);
            }
            if (this.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                this.logger.info("Serial import Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records.");
            }
        }
        catch (DataImportException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new DataImportException(e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition(exception, this.importContext)) {
                if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                    this.stop();
                } else {
                    this.stopTranOnly();
                }
            }
            if (this.importContext.isCurrentStoped()) {
                this.stopTranOnly();
            }
            importCount.setJobEndTime(new Date());
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute() {
        boolean reachEOFClosed;
        TranErrorWrapper tranErrorWrapper;
        Object lastValue;
        Throwable exception;
        ParallImportCount totalCount;
        ArrayList<Future> tasks;
        ExecutorService service;
        String ret;
        BBossStringWriter writer;
        block27: {
            int count = 0;
            StringBuilder builder = null;
            writer = null;
            if (this.dummyOupputContext.isPrintRecord()) {
                builder = new StringBuilder();
                writer = new BBossStringWriter(builder);
            }
            ret = null;
            service = this.importContext.buildThreadPool();
            tasks = new ArrayList<Future>();
            int taskNo = 0;
            totalCount = new ParallImportCount();
            exception = null;
            Status currentStatus = this.currentStatus;
            Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
            lastValue = null;
            tranErrorWrapper = new TranErrorWrapper(this.importContext);
            int batchsize = this.importContext.getStoreBatchSize();
            reachEOFClosed = false;
            try {
                block26: {
                    BatchContext batchContext = new BatchContext();
                    while (true) {
                        Boolean hasNext;
                        if (!tranErrorWrapper.assertCondition()) {
                            this.jdbcResultSet.stop();
                            tranErrorWrapper.throwError();
                        }
                        if ((hasNext = this.jdbcResultSet.next()) == null) {
                            if (count <= 0) continue;
                            String datas = null;
                            if (this.dummyOupputContext.isPrintRecord()) {
                                datas = builder.toString();
                                builder.setLength(0);
                            }
                            int _count = count;
                            count = 0;
                            DummyTaskCommandImpl taskCommand = new DummyTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, _count, taskNo, totalCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                            taskCommand.setDatas(datas);
                            tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                            ++taskNo;
                            continue;
                        }
                        if (!hasNext.booleanValue()) {
                            if (count > 0) {
                                break;
                            }
                            break block26;
                        }
                        lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                        Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, batchContext);
                        if (!reachEOFClosed) {
                            reachEOFClosed = context.reachEOFClosed();
                        }
                        if (context.removed()) {
                            ((ImportCount)totalCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        context.refactorData();
                        context.afterRefactor();
                        if (context.isDrop()) {
                            ((ImportCount)totalCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        CommonRecord record = this.buildRecord(context);
                        this.dummyOupputContext.generateReocord(context, record, (Writer)writer);
                        if (this.dummyOupputContext.isPrintRecord()) {
                            writer.write(TranUtil.lineSeparator);
                        }
                        if (++count < batchsize) continue;
                        String datas = null;
                        if (this.dummyOupputContext.isPrintRecord()) {
                            datas = builder.toString();
                            builder.setLength(0);
                        }
                        int _count = count;
                        count = 0;
                        DummyTaskCommandImpl taskCommand = new DummyTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, _count, taskNo, totalCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                        taskCommand.setDatas(datas);
                        tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                        ++taskNo;
                    }
                    if (!tranErrorWrapper.assertCondition()) {
                        tranErrorWrapper.throwError();
                    }
                    String datas = null;
                    if (this.dummyOupputContext.isPrintRecord()) {
                        datas = builder.toString();
                        builder.setLength(0);
                    }
                    DummyTaskCommandImpl taskCommand = new DummyTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, count, taskNo, totalCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                    taskCommand.setDatas(datas);
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    if (this.isPrintTaskLog()) {
                        this.logger.info("Pararrel batch submit tasks:" + taskNo);
                    }
                    break block27;
                }
                if (this.isPrintTaskLog()) {
                    this.logger.info("Pararrel batch submit tasks:" + taskNo);
                }
            }
            catch (SQLException e) {
                try {
                    exception = e;
                    throw new ElasticSearchException((Throwable)e);
                    catch (ElasticSearchException e2) {
                        exception = e2;
                        throw e2;
                    }
                    catch (Exception e3) {
                        exception = e3;
                        throw new ElasticSearchException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper, null, reachEOFClosed);
                    try {
                        writer.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    totalCount.setJobEndTime(new Date());
                    throw throwable;
                }
            }
        }
        this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper, null, reachEOFClosed);
        try {
            writer.close();
        }
        catch (Exception batchContext) {
            // empty catch block
        }
        totalCount.setJobEndTime(new Date());
        return ret;
    }

    @Override
    public String batchExecute() {
        int count = 0;
        StringBuilder builder = null;
        BBossStringWriter writer = null;
        if (this.dummyOupputContext.isPrintRecord()) {
            builder = new StringBuilder();
            writer = new BBossStringWriter(builder);
        }
        String ret = null;
        int taskNo = 0;
        Throwable exception = null;
        Status currentStatus = this.currentStatus;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        SerialImportCount importCount = new SerialImportCount();
        int batchsize = this.importContext.getStoreBatchSize();
        boolean reachEOFClosed = false;
        try {
            istart = start;
            BatchContext batchContext = new BatchContext();
            while (true) {
                Boolean hasNext;
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    if (count <= 0) continue;
                    String _dd = null;
                    if (this.dummyOupputContext.isPrintRecord()) {
                        _dd = builder.toString();
                        builder.setLength(0);
                    }
                    int _count = count;
                    count = 0;
                    DummyTaskCommandImpl taskCommand = new DummyTaskCommandImpl(importCount, this.importContext, this.targetImportContext, _count, taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                    taskCommand.setDatas(_dd);
                    ret = TaskCall.call(taskCommand);
                    if (this.isPrintTaskLog()) {
                        end = System.currentTimeMillis();
                        this.logger.info("Batch import Force flush datas Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + _count + " records.");
                        istart = end;
                    }
                    ++taskNo;
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, batchContext);
                if (!reachEOFClosed) {
                    reachEOFClosed = context.reachEOFClosed();
                }
                if (context.removed()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                context.refactorData();
                context.afterRefactor();
                if (context.isDrop()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                CommonRecord record = this.buildRecord(context);
                this.dummyOupputContext.generateReocord(context, record, (Writer)writer);
                if (this.dummyOupputContext.isPrintRecord()) {
                    writer.write(TranUtil.lineSeparator);
                }
                ++totalCount;
                if (++count < batchsize) continue;
                String datas = null;
                if (this.dummyOupputContext.isPrintRecord()) {
                    writer.flush();
                    datas = builder.toString();
                    builder.setLength(0);
                    writer.close();
                    writer = new BBossStringWriter(builder);
                }
                int _count = count;
                count = 0;
                DummyTaskCommandImpl taskCommand = new DummyTaskCommandImpl(importCount, this.importContext, this.targetImportContext, _count, taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                taskCommand.setDatas(datas);
                ret = TaskCall.call(taskCommand);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + batchsize + " records.");
                    istart = end;
                }
                ++taskNo;
            }
            if (count > 0) {
                String datas = null;
                if (this.dummyOupputContext.isPrintRecord()) {
                    writer.flush();
                    datas = builder.toString();
                }
                DummyTaskCommandImpl taskCommand = new DummyTaskCommandImpl(importCount, this.importContext, this.targetImportContext, count, taskNo, importCount.getJobNo(), lastValue, currentStatus, reachEOFClosed);
                taskCommand.setDatas(datas);
                TaskCall.call(taskCommand);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + count + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                }
            }
            if (this.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                this.logger.info("Batch import Execute Tasks:" + taskNo + ",All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (SQLException e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition((Exception)exception, this.importContext)) {
                if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                    this.stop();
                } else {
                    this.stopTranOnly();
                }
            }
            try {
                writer.close();
            }
            catch (Exception exception2) {}
            importCount.setJobEndTime(new Date());
        }
        return ret;
    }
}

