/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.util.SimpleStringUtil;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.db.DBImportConfig;

public class DBConfigBuilder {
    private DBConfig targetDBConfig;
    protected String sqlFilepath;
    protected String sqlName;
    protected String sql;
    private String insertSqlName;
    private String insertSql;
    private String updateSqlName;
    private boolean optimize;
    private String updateSql;
    private String deleteSqlName;
    private String deleteSql;
    private BatchHandler batchHandler;

    public BatchHandler getBatchHandler() {
        return this.batchHandler;
    }

    public void setBatchHandler(BatchHandler batchHandler) {
        this.batchHandler = batchHandler;
    }

    private void checkTargetDBConfig() {
        if (this.targetDBConfig == null) {
            this.targetDBConfig = new DBConfig();
        }
    }

    public String getInsertSqlName() {
        return this.insertSqlName;
    }

    public DBConfigBuilder setInsertSqlName(String insertSqlName) {
        this.insertSqlName = insertSqlName;
        return this;
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public DBConfigBuilder setInsertSql(String insertSql) {
        this.insertSql = insertSql;
        return this;
    }

    public DBImportConfig buildDBImportConfig() {
        DBImportConfig dbImportConfig = new DBImportConfig();
        dbImportConfig.setUseJavaName(false);
        dbImportConfig.setTargetDBConfig(this.targetDBConfig);
        dbImportConfig.setSqlFilepath(this.sqlFilepath);
        dbImportConfig.setSqlName(this.sqlName);
        if (SimpleStringUtil.isNotEmpty((String)this.sql)) {
            dbImportConfig.setSql(this.sql);
        }
        dbImportConfig.setInsertSqlName(this.insertSqlName);
        dbImportConfig.setInsertSql(this.insertSql);
        dbImportConfig.setUpdateSql(this.updateSql);
        dbImportConfig.setUpdateSqlName(this.updateSqlName);
        dbImportConfig.setDeleteSql(this.deleteSql);
        dbImportConfig.setDeleteSqlName(this.deleteSqlName);
        dbImportConfig.setOptimize(this.optimize);
        dbImportConfig.setBatchHandler(this.batchHandler);
        return dbImportConfig;
    }

    public String getSql() {
        return this.sql;
    }

    public DBConfigBuilder setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public DBConfigBuilder setSqlName(String sqlName) {
        this.sqlName = sqlName;
        return this;
    }

    public String getSqlFilepath() {
        return this.sqlFilepath;
    }

    public DBConfigBuilder setSqlFilepath(String sqlFilepath) {
        this.sqlFilepath = sqlFilepath;
        return this;
    }

    public String getDeleteSql() {
        return this.deleteSql;
    }

    public DBConfigBuilder setDeleteSql(String deleteSql) {
        this.deleteSql = deleteSql;
        return this;
    }

    public String getDeleteSqlName() {
        return this.deleteSqlName;
    }

    public DBConfigBuilder setDeleteSqlName(String deleteSqlName) {
        this.deleteSqlName = deleteSqlName;
        return this;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    public DBConfigBuilder setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
        return this;
    }

    public String getUpdateSqlName() {
        return this.updateSqlName;
    }

    public DBConfigBuilder setUpdateSqlName(String updateSqlName) {
        this.updateSqlName = updateSqlName;
        return this;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public DBConfigBuilder setOptimize(boolean optimize) {
        this.optimize = optimize;
        return this;
    }

    public DBConfigBuilder setTargetDbDriver(String targetDbDriver) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbDriver(targetDbDriver);
        return this;
    }

    public DBConfigBuilder setTargetDbUrl(String targetDbUrl) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbUrl(targetDbUrl);
        return this;
    }

    public DBConfigBuilder setTargetDbUser(String targetDbUser) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbUser(targetDbUser);
        return this;
    }

    public DBConfigBuilder setTargetDbPassword(String targetDbPassword) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbPassword(targetDbPassword);
        return this;
    }

    public DBConfigBuilder setTargetInitSize(int targetInitSize) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setInitSize(targetInitSize);
        return this;
    }

    public DBConfigBuilder setTargetMinIdleSize(int targetMinIdleSize) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setMinIdleSize(targetMinIdleSize);
        return this;
    }

    public DBConfigBuilder setTargetMaxSize(int targetMaxSize) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setMaxSize(targetMaxSize);
        return this;
    }

    public DBConfigBuilder setTargetDbName(String targetDbName) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbName(targetDbName);
        return this;
    }

    public DBConfigBuilder setTargetShowSql(boolean targetShowSql) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setShowSql(targetShowSql);
        return this;
    }

    public DBConfigBuilder setTargetUsePool(boolean targetUsePool) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setUsePool(targetUsePool);
        return this;
    }

    public DBConfigBuilder setTargetDbtype(String targetDbtype) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbtype(targetDbtype);
        return this;
    }

    public DBConfigBuilder setTargetDbAdaptor(String targetDbAdaptor) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setDbAdaptor(targetDbAdaptor);
        return this;
    }

    public DBConfigBuilder setTargetValidateSQL(String validateSQL) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setValidateSQL(validateSQL);
        return this;
    }

    public DBConfigBuilder setColumnLableUpperCase(boolean columnLableUpperCase) {
        this.checkTargetDBConfig();
        this.targetDBConfig.setColumnLableUpperCase(columnLableUpperCase);
        return this;
    }
}

