/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import org.frameworkset.tran.ESDataImportException;

public class DBConfig {
    private String statusTableDML;
    private Integer jdbcFetchSize;
    private String dbDriver;
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private int initSize = 10;
    private int minIdleSize = 10;
    private int maxSize = 20;
    public static final String mysql_createStatusTableSQL = "CREATE TABLE $statusTableName ( ID bigint(10) NOT NULL, lasttime bigint(10) NOT NULL, lastvalue bigint(10) NOT NULL, lastvaluetype int(1) NOT NULL," + "status int(1) ," + "filePath varchar(500) ," + "fileId varchar(500) ," + "PRIMARY KEY(ID)) ENGINE=InnoDB";
    public static final String oracle_createStatusTableSQL = "CREATE TABLE $statusTableName ( ID NUMBER(10) NOT NULL, lasttime NUMBER(10) NOT NULL, lastvalue NUMBER(10) NOT NULL, lastvaluetype NUMBER(1) NOT NULL," + "status number(1) ," + "filePath varchar(500) ," + "fileId varchar(500) ," + "constraint $statusTableName_PK primary key(ID))";
    public static final String dm_createStatusTableSQL = "CREATE TABLE $statusTableName ( ID NUMBER(10) NOT NULL, lasttime NUMBER(10) NOT NULL, lastvalue NUMBER(10) NOT NULL, lastvaluetype NUMBER(1) NOT NULL," + "status number(1) ," + "filePath varchar(500) ," + "fileId varchar(500) ," + "constraint $statusTableName_PK primary key(ID))";
    public static final String sqlserver_createStatusTableSQL = "CREATE TABLE $statusTableName (ID bigint NOT NULL,lasttime bigint NOT NULL,lastvalue bigint NOT NULL,lastvaluetype INT NOT NULL," + "status INT ," + "filePath varchar(500) ," + "fileId varchar(500) ," + "constraint $statusTableName_PK primary key(ID))";
    public static final String mysql_createHistoryStatusTableSQL = "CREATE TABLE $historyStatusTableName ( ID varchar(100) NOT NULL, lasttime bigint(10) NOT NULL, lastvalue bigint(10) NOT NULL, lastvaluetype int(1) NOT NULL," + "status int(1) ," + "filePath varchar(500) ," + "fileId varchar(500) ," + "statusId number(10) ," + "PRIMARY KEY(ID)) ENGINE=InnoDB";
    public static final String oracle_createHistoryStatusTableSQL = "CREATE TABLE $historyStatusTableName ( ID varchar(100) NOT NULL, lasttime NUMBER(10) NOT NULL, lastvalue NUMBER(10) NOT NULL, lastvaluetype NUMBER(1) NOT NULL," + "status number(1) ," + "filePath varchar(500) ," + "fileId varchar(500) ," + "statusId number(10) ," + "constraint $historyStatusTableName_PK primary key(ID))";
    public static final String dm_createHistoryStatusTableSQL = "CREATE TABLE $historyStatusTableName ( ID varchar(100) NOT NULL, lasttime NUMBER(10) NOT NULL, lastvalue NUMBER(10) NOT NULL, lastvaluetype NUMBER(1) NOT NULL," + "status number(1) ," + "filePath varchar(500) ," + "fileId varchar(500) ," + "statusId number(10) ," + "constraint $historyStatusTableName_PK primary key(ID))";
    public static final String sqlserver_createHistoryStatusTableSQL = "CREATE TABLE $historyStatusTableName (ID varchar(100),lasttime bigint NOT NULL,lastvalue bigint NOT NULL,lastvaluetype INT NOT NULL," + "status INT ," + "filePath varchar(500) ," + "fileId varchar(500) ," + "statusId number(10) ," + "constraint $historyStatusTableName_PK primary key(ID))";
    private boolean showSql;
    private boolean usePool = false;
    private String dbtype;
    private String dbAdaptor;
    private boolean columnLableUpperCase;
    private boolean enableDBTransaction = false;
    private String dbInfoEncryptClass;
    private String validateSQL;
    private String dbName;
    public static final String db_name_key = "db.name";
    public static final String db_user_key = "db.user";
    public static final String db_password_key = "db.password";
    public static final String db_driver_key = "db.driver";
    public static final String db_enableDBTransaction_key = "db.enableDBTransaction";
    public static final String db_url_key = "db.url";
    public static final String db_usePool_key = "db.usePool";
    public static final String db_validateSQL_key = "db.validateSQL";
    public static final String db_dbInfoEncryptClass_key = "db.dbInfoEncryptClass";
    public static final String db_showsql_key = "db.showsql";
    public static final String db_jdbcFetchSize_key = "db.jdbcFetchSize";
    public static final String db_initSize_key = "db.initSize";
    public static final String db_minIdleSize_key = "db.minIdleSize";
    public static final String db_maxSize_key = "db.maxSize";
    public static final String db_statusTableDML_key = "db.statusTableDML";
    public static final String db_dbAdaptor_key = "db.dbAdaptor";
    public static final String db_dbtype_key = "db.dbtype";
    public static final String db_columnLableUpperCase_key = "db.columnLableUpperCase";

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getCreateStatusTableSQL(String dbtype) {
        if (dbtype.equals("mysql")) {
            return mysql_createStatusTableSQL;
        }
        if (dbtype.equals("oracle")) {
            return oracle_createStatusTableSQL;
        }
        if (dbtype.equals("dm")) {
            return dm_createStatusTableSQL;
        }
        if (dbtype.equals("sqlserver")) {
            return sqlserver_createStatusTableSQL;
        }
        throw new ESDataImportException("getCreateStatusTableSQL failed: unsupport dbtype " + dbtype);
    }

    public String getCreateHistoryStatusTableSQL(String dbtype) {
        if (dbtype.equals("mysql")) {
            return mysql_createHistoryStatusTableSQL;
        }
        if (dbtype.equals("oracle")) {
            return oracle_createHistoryStatusTableSQL;
        }
        if (dbtype.equals("dm")) {
            return dm_createHistoryStatusTableSQL;
        }
        if (dbtype.equals("sqlserver")) {
            return sqlserver_createHistoryStatusTableSQL;
        }
        throw new ESDataImportException("getCreateHistoryStatusTableSQL failed: unsupport dbtype " + dbtype);
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getValidateSQL() {
        return this.validateSQL;
    }

    public void setValidateSQL(String validateSQL) {
        this.validateSQL = validateSQL;
    }

    public Integer getJdbcFetchSize() {
        return this.jdbcFetchSize;
    }

    public void setJdbcFetchSize(Integer jdbcFetchSize) {
        this.jdbcFetchSize = jdbcFetchSize;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public boolean isUsePool() {
        return this.usePool;
    }

    public void setUsePool(boolean usePool) {
        this.usePool = usePool;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMinIdleSize() {
        return this.minIdleSize;
    }

    public void setMinIdleSize(int minIdleSize) {
        this.minIdleSize = minIdleSize;
    }

    public int getInitSize() {
        return this.initSize;
    }

    public void setInitSize(int initSize) {
        this.initSize = initSize;
    }

    public String getStatusTableDML() {
        return this.statusTableDML;
    }

    public void setStatusTableDML(String statusTableDML) {
        this.statusTableDML = statusTableDML;
    }

    public String getDbtype() {
        return this.dbtype;
    }

    public void setDbtype(String dbtype) {
        this.dbtype = dbtype;
    }

    public String getDbAdaptor() {
        return this.dbAdaptor;
    }

    public void setDbAdaptor(String dbAdaptor) {
        this.dbAdaptor = dbAdaptor;
    }

    public boolean isEnableDBTransaction() {
        return this.enableDBTransaction;
    }

    public void setEnableDBTransaction(boolean enableDBTransaction) {
        this.enableDBTransaction = enableDBTransaction;
    }

    public boolean isColumnLableUpperCase() {
        return this.columnLableUpperCase;
    }

    public void setColumnLableUpperCase(boolean columnLableUpperCase) {
        this.columnLableUpperCase = columnLableUpperCase;
    }

    public String getDbInfoEncryptClass() {
        return this.dbInfoEncryptClass;
    }

    public void setDbInfoEncryptClass(String dbInfoEncryptClass) {
        this.dbInfoEncryptClass = dbInfoEncryptClass;
    }
}

