/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.scroll.BreakableScrollHandler;
import org.frameworkset.tran.AsynTranResultSet;
import org.frameworkset.tran.Data;
import org.frameworkset.tran.DataTran;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.WaitTasksCompleteCallBack;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataTran
implements DataTran {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static Object dummy = new Object();
    protected ImportContext importContext;
    protected ImportContext targetImportContext;
    protected TranResultSet jdbcResultSet;
    protected AsynTranResultSet esTranResultSet;
    protected TaskContext taskContext;
    protected Status currentStatus;
    protected volatile boolean tranFinished;
    private BreakableScrollHandler breakableScrollHandler;
    public static final Class[] basePrimaryTypes = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, Float.TYPE, Short.TYPE, Double.TYPE, Character.TYPE, Byte.TYPE, BigInteger.class, BigDecimal.class};

    @Override
    public AsynTranResultSet getAsynTranResultSet() {
        return this.esTranResultSet;
    }

    public void appendData(Data data) {
        if (this.esTranResultSet != null) {
            this.esTranResultSet.appendData(data);
        }
    }

    public Status getCurrentStatus() {
        return this.currentStatus;
    }

    @Override
    public BreakableScrollHandler getBreakableScrollHandler() {
        return this.breakableScrollHandler;
    }

    public void setBreakableScrollHandler(BreakableScrollHandler breakableScrollHandler) {
        this.breakableScrollHandler = breakableScrollHandler;
    }

    public BaseDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, Status currentStatus) {
        this.currentStatus = currentStatus;
        this.taskContext = taskContext;
        this.jdbcResultSet = jdbcResultSet;
        if (jdbcResultSet instanceof AsynTranResultSet) {
            this.esTranResultSet = (AsynTranResultSet)jdbcResultSet;
        }
        this.importContext = importContext;
        this.targetImportContext = targetImportContext;
    }

    public void init() {
    }

    public void stop() {
        if (this.breakableScrollHandler != null) {
            this.breakableScrollHandler.setBreaked(true);
        }
        this.importContext.destroy(false);
    }

    public void stopTranOnly() {
        if (this.breakableScrollHandler != null) {
            this.breakableScrollHandler.setBreaked(true);
        }
    }

    public abstract void logTaskStart(Logger var1);

    public String tran() throws ESDataImportException {
        try {
            this.getDataTranPlugin().setHasTran();
            if (this.jdbcResultSet == null) {
                String string = null;
                return string;
            }
            if (this.isPrintTaskLog()) {
                this.logTaskStart(this.logger);
            }
            if (this.importContext.getStoreBatchSize() <= 0) {
                String string = this.serialExecute();
                return string;
            }
            if (this.importContext.getThreadCount() > 0 && this.importContext.isParallel()) {
                String string = this.parallelBatchExecute();
                return string;
            }
            String string = this.batchExecute();
            return string;
        }
        finally {
            this.tranFinished = true;
            this.getDataTranPlugin().setNoTran();
        }
    }

    protected void jobComplete(ExecutorService service, Exception exception, Object lastValue, TranErrorWrapper tranErrorWrapper, Status currentStatus, boolean reachEOFClosed) {
        if (this.importContext.getScheduleService() == null) {
            if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                this.stop();
            } else {
                this.stopTranOnly();
            }
        } else if (!tranErrorWrapper.assertCondition(exception)) {
            if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                this.stop();
            } else {
                this.stopTranOnly();
            }
        }
    }

    protected boolean isPrintTaskLog() {
        return this.importContext.isPrintTaskLog() && this.logger.isInfoEnabled();
    }

    @Override
    public void waitTasksComplete(final List<Future> tasks, final ExecutorService service, Exception exception, Object lastValue, final ImportCount totalCount, final TranErrorWrapper tranErrorWrapper, final WaitTasksCompleteCallBack waitTasksCompleteCallBack, final boolean reachEOFClosed) {
        if (!this.importContext.isAsyn() || this.importContext.getScheduleService() != null) {
            int count = 0;
            for (Future future : tasks) {
                try {
                    future.get();
                    ++count;
                }
                catch (ExecutionException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    if (!this.logger.isErrorEnabled()) continue;
                    if (e.getCause() != null) {
                        this.logger.error("", e.getCause());
                        continue;
                    }
                    this.logger.error("", (Throwable)e);
                }
                catch (Exception e) {
                    if (exception == null) {
                        exception = e;
                    }
                    if (!this.logger.isErrorEnabled()) continue;
                    this.logger.error("", (Throwable)e);
                }
            }
            if (waitTasksCompleteCallBack != null) {
                waitTasksCompleteCallBack.call();
            }
            totalCount.setJobEndTime(new Date());
            if (this.isPrintTaskLog()) {
                this.logger.info("Parallel batch import Complete tasks:" + count + ",Total success import " + totalCount.getSuccessCount() + " records,Ignore Total " + totalCount.getIgnoreTotalCount() + " records,failed total " + totalCount.getFailedCount() + " records.");
            }
            this.jobComplete(service, exception, lastValue, tranErrorWrapper, this.currentStatus, reachEOFClosed);
            totalCount.setJobEndTime(new Date());
        } else {
            Thread completeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int count = 0;
                    for (Future future : tasks) {
                        try {
                            future.get();
                            ++count;
                        }
                        catch (ExecutionException e) {
                            if (!BaseDataTran.this.logger.isErrorEnabled()) continue;
                            if (e.getCause() != null) {
                                BaseDataTran.this.logger.error("", e.getCause());
                                continue;
                            }
                            BaseDataTran.this.logger.error("", (Throwable)e);
                        }
                        catch (Exception e) {
                            if (!BaseDataTran.this.logger.isErrorEnabled()) continue;
                            BaseDataTran.this.logger.error("", (Throwable)e);
                        }
                    }
                    if (waitTasksCompleteCallBack != null) {
                        waitTasksCompleteCallBack.call();
                    }
                    if (BaseDataTran.this.isPrintTaskLog()) {
                        BaseDataTran.this.logger.info("Parallel batch import Complete tasks:" + count + ",Total success import " + totalCount.getSuccessCount() + " records,Ignore Total " + totalCount.getIgnoreTotalCount() + " records,failed total " + totalCount.getFailedCount() + " records.");
                    }
                    BaseDataTran.this.jobComplete(service, null, null, tranErrorWrapper, BaseDataTran.this.currentStatus, reachEOFClosed);
                    totalCount.setJobEndTime(new Date());
                }
            });
            completeThread.start();
        }
    }

    public static boolean isBasePrimaryType(Class type) {
        if (!type.isArray()) {
            if (type.isEnum()) {
                return true;
            }
            for (Class primaryType : basePrimaryTypes) {
                if (!primaryType.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public DataTranPlugin getDataTranPlugin() {
        return this.importContext.getDataTranPlugin();
    }

    public Object getLastValue() throws ESDataImportException {
        if (!this.importContext.useFilePointer()) {
            if (this.importContext.getLastValueColumnName() == null) {
                return null;
            }
            return this.jdbcResultSet.getLastValue(this.importContext.getLastValueColumnName());
        }
        return this.jdbcResultSet.getLastOffsetValue();
    }

    public boolean isTranFinished() {
        return this.tranFinished;
    }
}

