/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;

public abstract class BaseCommonRecordDataTran
extends BaseDataTran {
    public BaseCommonRecordDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, targetImportContext, currentStatus);
    }

    protected void logColumnsInfo() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Export Columns is null,you can set Export Columns in importconfig or not.");
        }
    }

    protected CommonRecord buildRecord(Context context) {
        String[] columns = this.targetImportContext.getExportColumns();
        boolean useResultKeys = false;
        if (columns == null) {
            Object keys = this.jdbcResultSet.getKeys();
            if (keys != null) {
                useResultKeys = true;
                if (keys instanceof Set) {
                    Set _keys = (Set)keys;
                    columns = _keys.toArray(new String[_keys.size()]);
                } else {
                    columns = (String[])keys;
                }
            } else {
                this.logColumnsInfo();
            }
        }
        Object temp = null;
        CommonRecord dbRecord = new CommonRecord();
        HashMap<String, Object> addedFields = new HashMap<String, Object>();
        List<FieldMeta> fieldValueMetas = context.getFieldValues();
        this.appendFieldValues(dbRecord, columns, fieldValueMetas, addedFields, useResultKeys);
        fieldValueMetas = context.getESJDBCFieldValues();
        this.appendFieldValues(dbRecord, columns, fieldValueMetas, addedFields, useResultKeys);
        String varName = null;
        for (int i = 0; columns != null && i < columns.length; ++i) {
            varName = columns[i];
            if (addedFields.get(varName) != null) continue;
            FieldMeta fieldMeta = context.getMappingName(varName);
            if (fieldMeta != null) {
                if (fieldMeta.getIgnore() != null && fieldMeta.getIgnore().booleanValue()) continue;
                varName = fieldMeta.getEsFieldName();
            }
            if ((temp = this.jdbcResultSet.getValue(varName)) == null && this.logger.isWarnEnabled()) {
                this.logger.warn("\u672a\u6307\u5b9a\u7ed1\u5b9a\u53d8\u91cf{}\u7684\u503c\uff01", (Object)varName);
            }
            dbRecord.addData(varName, temp);
        }
        return dbRecord;
    }

    protected void appendFieldValues(CommonRecord record, String[] columns, List<FieldMeta> fieldValueMetas, Map<String, Object> addedFields, boolean useResultKeys) {
        if (fieldValueMetas == null || fieldValueMetas.size() == 0) {
            return;
        }
        if (columns != null && columns.length > 0) {
            for (FieldMeta fieldMeta : fieldValueMetas) {
                String fieldName = fieldMeta.getEsFieldName();
                if (addedFields.containsKey(fieldName)) continue;
                boolean matched = false;
                for (String name : columns) {
                    if (!name.equals(fieldName)) continue;
                    record.addData(name, fieldMeta.getValue());
                    addedFields.put(name, dummy);
                    matched = true;
                    break;
                }
                if (!useResultKeys || matched) continue;
                record.addData(fieldName, fieldMeta.getValue());
                addedFields.put(fieldName, dummy);
            }
        } else {
            for (FieldMeta fieldMeta : fieldValueMetas) {
                String fieldName = fieldMeta.getEsFieldName();
                if (addedFields.containsKey(fieldName)) continue;
                record.addData(fieldName, fieldMeta.getValue());
                addedFields.put(fieldName, dummy);
            }
        }
    }
}

