/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db.output;

import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.StatementInfo;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.tran.Param;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.output.DBOutPutContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.TaskFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base2DBTaskCommandImpl
extends BaseTaskCommand<List<List<Param>>, String> {
    private String sql;
    private DBOutPutContext es2DBContext;
    private List<List<Param>> datas;
    private int tryCount;
    private static Logger logger = LoggerFactory.getLogger(Base2DBTaskCommandImpl.class);

    public Base2DBTaskCommandImpl(String sql, ImportCount importCount, ImportContext importContext, List<List<Param>> datas, int taskNo, String jobNo) {
        super(importCount, importContext, datas.size(), taskNo, jobNo);
        this.sql = sql;
        this.importContext = importContext;
        this.datas = datas;
        this.es2DBContext = (DBOutPutContext)((Object)importContext);
    }

    @Override
    public List<List<Param>> getDatas() {
        return this.datas;
    }

    @Override
    public void setDatas(List<List<Param>> datas) {
        this.datas = datas;
    }

    private void debugDB(String name) {
        DBUtil.debugStatus((String)name);
    }

    @Override
    public String execute() {
        String data = null;
        if (this.importContext.getMaxRetry() > 0 && this.tryCount >= this.importContext.getMaxRetry()) {
            throw new TaskFailedException("task execute failed:reached max retry times " + this.importContext.getMaxRetry());
        }
        ++this.tryCount;
        long start = System.currentTimeMillis();
        StatementInfo stmtInfo = null;
        PreparedStatement statement = null;
        Connection con_ = null;
        int batchsize = this.importContext.getStoreBatchSize();
        try {
            String dbname = this.es2DBContext.getTargetDBConfig().getDbName();
            con_ = DBUtil.getConection((String)dbname);
            stmtInfo = new StatementInfo(dbname, null, false, con_, false);
            stmtInfo.init();
            statement = stmtInfo.prepareStatement(this.sql);
            if (batchsize <= 1) {
                for (List<Param> record : this.datas) {
                    for (int i = 0; i < record.size(); ++i) {
                        Param param = record.get(i);
                        statement.setObject(param.getIndex(), param.getValue());
                    }
                    try {
                        statement.addBatch();
                    }
                    catch (SQLException e) {
                        throw new NestedSQLException(record.toString(), (Throwable)e);
                    }
                }
                statement.executeBatch();
            } else {
                int point = batchsize - 1;
                int count = 0;
                for (List<Param> record : this.datas) {
                    for (int i = 0; i < record.size(); ++i) {
                        Param param = record.get(i);
                        statement.setObject(param.getIndex(), param.getValue());
                    }
                    statement.addBatch();
                    if (count > 0 && count % point == 0) {
                        statement.executeBatch();
                        statement.clearBatch();
                        count = 0;
                        continue;
                    }
                    ++count;
                }
                if (count > 0) {
                    statement.executeBatch();
                }
            }
        }
        catch (BatchUpdateException error) {
            if (stmtInfo != null) {
                try {
                    stmtInfo.errorHandle((Exception)error);
                }
                catch (SQLException ex) {
                    throw new ElasticSearchException(this.sql, (Throwable)error);
                }
            }
            throw new ElasticSearchException(this.sql, (Throwable)error);
        }
        catch (Exception e) {
            if (stmtInfo != null) {
                try {
                    stmtInfo.errorHandle(e);
                }
                catch (SQLException ex) {
                    throw new ElasticSearchException(this.sql, (Throwable)e);
                }
            }
            throw new ElasticSearchException(this.sql, (Throwable)e);
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
            }
            if (con_ != null) {
                try {
                    con_.close();
                }
                catch (Exception exception) {}
            }
            stmtInfo = null;
        }
        return data;
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }
}

