/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import com.frameworkset.util.SimpleStringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataRefactor;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.EsIdGenerator;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.config.ClientOptions;
import org.frameworkset.tran.es.ESConfig;
import org.frameworkset.tran.es.ESField;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.ImportIncreamentConfig;
import org.frameworkset.tran.schedule.ScheduleConfig;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseImportBuilder {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private DBConfig dbConfig;
    private DBConfig statusDbConfig;
    private String statusDbname;
    private String statusTableDML;
    private Integer fetchSize = 5000;
    private long flushInterval;
    private boolean ignoreNullValueField;
    private String targetElasticsearch = "default";
    private String sourceElasticsearch = "default";
    private ESConfig esConfig;
    private ClientOptions clientOptions;
    private Map<String, String> geoipConfig;
    private boolean sortLastValue = true;
    private boolean useBatchContextIndexName = false;
    private boolean discardBulkResponse = true;
    private boolean debugResponse;
    private ScheduleConfig scheduleConfig;
    protected ImportIncreamentConfig importIncreamentConfig;
    private boolean externalTimer;
    private boolean printTaskLog = false;
    private transient List<CallInterceptor> callInterceptors;
    private transient List<String> callInterceptorClasses;
    private String applicationPropertiesFile;
    private boolean freezen;
    private boolean statusFreezen;
    private List<DBConfig> configs;
    private int batchSize = 1000;
    private boolean parallel;
    private int threadCount = 200;
    private int queue = 1000;
    private boolean asyn;
    private boolean continueOnError;
    private long asynResultPollTimeOut = 1000L;
    private Boolean useLowcase;
    private Integer scheduleBatchSize;
    private String index;
    private String indexType;
    private Boolean useJavaName;
    protected transient ExportResultHandler exportResultHandler;
    private String exportResultHandlerClass;
    public static final String DEFAULT_CONFIG_FILE = "application.properties";
    private String geoipDatabase;
    private String geoipAsnDatabase;
    private Integer geoipCachesize;
    private String geoipTaobaoServiceURL;
    private String configString;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private transient EsIdGenerator esIdGenerator = BaseImportConfig.DEFAULT_EsIdGenerator;
    private Map<String, FieldMeta> fieldMetaMap = new HashMap<String, FieldMeta>();
    private String esIdGeneratorClass = "org.frameworkset.tran.DefaultEsIdGenerator";
    private List<FieldMeta> fieldValues = new ArrayList<FieldMeta>();
    private transient DataRefactor dataRefactor;
    private String dataRefactorClass;
    private boolean pagine;
    private int tranDataBufferQueue = 10;

    public boolean isExternalTimer() {
        return this.externalTimer;
    }

    public Map<String, String> getGeoipConfig() {
        return this.geoipConfig;
    }

    public void setStatusTableId(Integer statusTableId) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setStatusTableId(statusTableId);
    }

    public long getAsynResultPollTimeOut() {
        return this.asynResultPollTimeOut;
    }

    public BaseImportBuilder setAsynResultPollTimeOut(long asynResultPollTimeOut) {
        this.asynResultPollTimeOut = asynResultPollTimeOut;
        return this;
    }

    public Boolean getUseLowcase() {
        return this.useLowcase;
    }

    public BaseImportBuilder setUseLowcase(Boolean useLowcase) {
        this.useLowcase = useLowcase;
        return this;
    }

    public String getExportResultHandlerClass() {
        return this.exportResultHandlerClass;
    }

    protected void buildDBConfig() {
        if (!this.freezen) {
            PropertiesContainer propertiesContainer = new PropertiesContainer();
            if (this.applicationPropertiesFile == null) {
                propertiesContainer.addConfigPropertiesFile(DEFAULT_CONFIG_FILE);
            } else {
                propertiesContainer.addConfigPropertiesFile(this.applicationPropertiesFile);
            }
            String dbName = propertiesContainer.getProperty("db.name");
            if (dbName == null || dbName.equals("")) {
                return;
            }
            this.dbConfig = new DBConfig();
            this._buildDBConfig(propertiesContainer, dbName, this.dbConfig, "");
        }
    }

    protected void buildESConfig() {
        if (!this.freezen) {
            // empty if block
        }
    }

    @JsonIgnore
    public ExportResultHandler getExportResultHandler() {
        return this.exportResultHandler;
    }

    public BaseImportBuilder setExportResultHandler(ExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
        if (exportResultHandler != null) {
            this.exportResultHandlerClass = exportResultHandler.getClass().getName();
        }
        return this;
    }

    protected void buildGeoipConfig() {
        if (this.geoipDatabase != null) {
            if (this.geoipConfig == null) {
                this.geoipConfig = new HashMap<String, String>();
            }
            this.geoipConfig.put("ip.database", this.geoipDatabase);
            if (this.geoipAsnDatabase != null) {
                this.geoipConfig.put("ip.asnDatabase", this.geoipAsnDatabase);
            }
            if (this.geoipCachesize != null) {
                this.geoipConfig.put("ip.cachesize", this.geoipCachesize + "");
            } else {
                this.geoipConfig.put("ip.cachesize", "10000");
            }
            if (this.geoipTaobaoServiceURL != null) {
                this.geoipConfig.put("ip.serviceUrl", this.geoipTaobaoServiceURL);
            }
        }
    }

    public BaseImportBuilder setEsIdGenerator(EsIdGenerator esIdGenerator) {
        if (esIdGenerator != null) {
            this.esIdGenerator = esIdGenerator;
            this.esIdGeneratorClass = esIdGenerator.getClass().getName();
        }
        return this;
    }

    protected void buildStatusDBConfig() {
        if (!this.statusFreezen) {
            if (this.statusDbname == null) {
                PropertiesContainer propertiesContainer = new PropertiesContainer();
                String prefix = "config.";
                if (this.applicationPropertiesFile == null) {
                    propertiesContainer.addConfigPropertiesFile(DEFAULT_CONFIG_FILE);
                } else {
                    propertiesContainer.addConfigPropertiesFile(this.applicationPropertiesFile);
                }
                String dbName = propertiesContainer.getProperty(prefix + "db.name");
                if (dbName == null || dbName.equals("")) {
                    return;
                }
                this.statusDbConfig = new DBConfig();
                this._buildDBConfig(propertiesContainer, dbName, this.statusDbConfig, "config.");
            } else {
                this.statusDbConfig = new DBConfig();
                this.statusDbConfig.setDbName(this.statusDbname);
                if (this.statusTableDML != null && !this.statusTableDML.equals("")) {
                    this.statusDbConfig.setStatusTableDML(this.statusTableDML);
                }
            }
        }
    }

    protected void builderConfig() {
        this.buildGeoipConfig();
        this.buildESConfig();
        this.buildDBConfig();
        this.buildStatusDBConfig();
        this.buildOtherDBConfigs();
    }

    protected void buildOtherDBConfigs() {
        PropertiesContainer propertiesContainer = new PropertiesContainer();
        if (this.applicationPropertiesFile == null) {
            propertiesContainer.addConfigPropertiesFile(DEFAULT_CONFIG_FILE);
        } else {
            propertiesContainer.addConfigPropertiesFile(this.applicationPropertiesFile);
        }
        String thirdDatasources = propertiesContainer.getProperty("thirdDatasources");
        if (thirdDatasources == null || thirdDatasources.equals("")) {
            return;
        }
        String[] names = thirdDatasources.split(",");
        ArrayList<DBConfig> dbConfigs = new ArrayList<DBConfig>();
        for (int i = 0; i < names.length; ++i) {
            String prefix = names[i].trim();
            if (prefix.equals("")) continue;
            DBConfig dbConfig = new DBConfig();
            this._buildDBConfig(propertiesContainer, prefix, dbConfig, prefix + ".");
            dbConfigs.add(dbConfig);
        }
        this.configs = dbConfigs;
    }

    protected void _buildDBConfig(PropertiesContainer propertiesContainer, String dbName, DBConfig dbConfig, String prefix) {
        String _maxSize;
        String _minIdleSize;
        String _initSize;
        String _jdbcFetchSize;
        dbConfig.setDbName(dbName);
        String dbUser = propertiesContainer.getProperty(prefix + "db.user");
        dbConfig.setDbUser(dbUser);
        String dbPassword = propertiesContainer.getProperty(prefix + "db.password");
        dbConfig.setDbPassword(dbPassword);
        String dbDriver = propertiesContainer.getProperty(prefix + "db.driver");
        dbConfig.setDbDriver(dbDriver);
        boolean enableDBTransaction = propertiesContainer.getBooleanProperty(prefix + "db.enableDBTransaction", false);
        dbConfig.setEnableDBTransaction(enableDBTransaction);
        String dbUrl = propertiesContainer.getProperty(prefix + "db.url");
        dbConfig.setDbUrl(dbUrl);
        String _usePool = propertiesContainer.getProperty(prefix + "db.usePool");
        if (_usePool != null && !_usePool.equals("")) {
            boolean usePool = Boolean.parseBoolean(_usePool);
            dbConfig.setUsePool(usePool);
        }
        String validateSQL = propertiesContainer.getProperty(prefix + "db.validateSQL");
        dbConfig.setValidateSQL(validateSQL);
        String _showSql = propertiesContainer.getProperty(prefix + "db.showsql");
        if (_showSql != null && !_showSql.equals("")) {
            boolean showSql = Boolean.parseBoolean(_showSql);
            dbConfig.setShowSql(showSql);
        }
        if ((_jdbcFetchSize = propertiesContainer.getProperty(prefix + "db.jdbcFetchSize")) != null && !_jdbcFetchSize.equals("")) {
            int jdbcFetchSize = Integer.parseInt(_jdbcFetchSize);
            dbConfig.setJdbcFetchSize(jdbcFetchSize);
        }
        if ((_initSize = propertiesContainer.getProperty(prefix + "db.initSize")) != null && !_initSize.equals("")) {
            int initSize = Integer.parseInt(_initSize);
            dbConfig.setInitSize(initSize);
        }
        if ((_minIdleSize = propertiesContainer.getProperty(prefix + "db.minIdleSize")) != null && !_minIdleSize.equals("")) {
            int minIdleSize = Integer.parseInt(_minIdleSize);
            dbConfig.setMinIdleSize(minIdleSize);
        }
        if ((_maxSize = propertiesContainer.getProperty(prefix + "db.maxSize")) != null && !_maxSize.equals("")) {
            int maxSize = Integer.parseInt(_maxSize);
            dbConfig.setMaxSize(maxSize);
        }
        String statusTableDML = propertiesContainer.getProperty(prefix + "db.statusTableDML");
        dbConfig.setStatusTableDML(statusTableDML);
        String dbAdaptor = propertiesContainer.getProperty(prefix + "db.dbAdaptor");
        dbConfig.setDbAdaptor(dbAdaptor);
        String dbtype = propertiesContainer.getProperty(prefix + "db.dbtype");
        dbConfig.setDbtype(dbtype);
    }

    protected void _setJdbcFetchSize(Integer jdbcFetchSize) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setJdbcFetchSize(jdbcFetchSize);
    }

    public void _setDbPassword(String dbPassword) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbPassword(dbPassword);
    }

    public BaseImportBuilder setDbName(String dbName) {
        this._setDbName(dbName);
        return this;
    }

    public BaseImportBuilder setDbDriver(String dbDriver) {
        this._setDbDriver(dbDriver);
        return this;
    }

    public BaseImportBuilder setEnableDBTransaction(boolean enableDBTransaction) {
        this._setEnableDBTransaction(enableDBTransaction);
        return this;
    }

    public BaseImportBuilder setDbUrl(String dbUrl) {
        this._setDbUrl(dbUrl);
        return this;
    }

    public BaseImportBuilder setDbAdaptor(String dbAdaptor) {
        this._setDbAdaptor(dbAdaptor);
        return this;
    }

    public BaseImportBuilder setDbtype(String dbtype) {
        this._setDbtype(dbtype);
        return this;
    }

    public BaseImportBuilder setDbUser(String dbUser) {
        this._setDbUser(dbUser);
        return this;
    }

    public BaseImportBuilder setDbPassword(String dbPassword) {
        this._setDbPassword(dbPassword);
        return this;
    }

    public BaseImportBuilder setValidateSQL(String validateSQL) {
        this._setValidateSQL(validateSQL);
        return this;
    }

    public BaseImportBuilder setUsePool(boolean usePool) {
        this._setUsePool(usePool);
        return this;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public BaseImportBuilder setParallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public BaseImportBuilder setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public int getQueue() {
        return this.queue;
    }

    public BaseImportBuilder setQueue(int queue) {
        this.queue = queue;
        return this;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public BaseImportBuilder setAsyn(boolean asyn) {
        this.asyn = asyn;
        return this;
    }

    public BaseImportBuilder setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
        return this;
    }

    public BaseImportBuilder setEsParentIdValue(String esParentIdValue) {
        this.checkclientOptions();
        this.clientOptions.setEsParentIdValue(esParentIdValue);
        return this;
    }

    public BaseImportBuilder setEsVersionValue(Object esVersionValue) {
        this.checkclientOptions();
        this.clientOptions.setVersion(esVersionValue);
        return this;
    }

    public boolean isDiscardBulkResponse() {
        return this.discardBulkResponse;
    }

    public BaseImportBuilder setDiscardBulkResponse(boolean discardBulkResponse) {
        this.discardBulkResponse = discardBulkResponse;
        return this;
    }

    public boolean isDebugResponse() {
        return this.debugResponse;
    }

    public BaseImportBuilder setDebugResponse(boolean debugResponse) {
        this.debugResponse = debugResponse;
        return this;
    }

    public BaseImportBuilder setPeriod(Long period) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setPeriod(period);
        return this;
    }

    public BaseImportBuilder setDeyLay(Long deyLay) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setDeyLay(deyLay);
        return this;
    }

    public BaseImportBuilder setScheduleDate(Date scheduleDate) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setScheduleDate(scheduleDate);
        return this;
    }

    public BaseImportBuilder setFixedRate(Boolean fixedRate) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setFixedRate(fixedRate);
        return this;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public ImportIncreamentConfig getImportIncreamentConfig() {
        return this.importIncreamentConfig;
    }

    @Deprecated
    public BaseImportBuilder setDateLastValueColumn(String dateLastValueColumn) {
        return this.setLastValueColumn(dateLastValueColumn);
    }

    public BaseImportBuilder setLastValueColumn(String numberLastValueColumn) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueColumn(numberLastValueColumn);
        return this;
    }

    @Deprecated
    public BaseImportBuilder setNumberLastValueColumn(String numberLastValueColumn) {
        return this.setLastValueColumn(numberLastValueColumn);
    }

    public BaseImportBuilder setLastValueStorePath(String lastValueStorePath) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueStorePath(lastValueStorePath);
        return this;
    }

    public BaseImportBuilder setLastValueStoreTableName(String lastValueStoreTableName) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueStoreTableName(lastValueStoreTableName);
        return this;
    }

    public BaseImportBuilder setFromFirst(boolean fromFirst) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setFromFirst(fromFirst);
        return this;
    }

    public BaseImportBuilder setLastValue(Object lastValue) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValue(lastValue);
        return this;
    }

    public BaseImportBuilder setLastValueType(int lastValueType) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueType(lastValueType);
        return this;
    }

    public BaseImportBuilder setJdbcFetchSize(Integer jdbcFetchSize) {
        this._setJdbcFetchSize(jdbcFetchSize);
        return this;
    }

    public Integer getScheduleBatchSize() {
        return this.scheduleBatchSize;
    }

    public BaseImportBuilder setScheduleBatchSize(Integer scheduleBatchSize) {
        this.scheduleBatchSize = scheduleBatchSize;
        return this;
    }

    public BaseImportBuilder addCallInterceptor(CallInterceptor interceptor) {
        if (this.callInterceptors == null) {
            this.callInterceptors = new ArrayList<CallInterceptor>();
            this.callInterceptorClasses = new ArrayList<String>();
        }
        this.callInterceptors.add(interceptor);
        this.callInterceptorClasses.add(interceptor.getClass().getName());
        return this;
    }

    public boolean isPrintTaskLog() {
        return this.printTaskLog;
    }

    public BaseImportBuilder setPrintTaskLog(boolean printTaskLog) {
        this.printTaskLog = printTaskLog;
        return this;
    }

    public String toString() {
        if (this.configString != null) {
            return this.configString;
        }
        try {
            StringBuilder ret = new StringBuilder();
            ret.append(SimpleStringUtil.object2json((Object)this));
            this.configString = ret.toString();
            return this.configString;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.configString = "";
            return this.configString;
        }
    }

    public void _setShowSql(boolean showSql) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setShowSql(showSql);
    }

    public void _setDbName(String dbName) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbName(dbName);
    }

    public void _setDbDriver(String dbDriver) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbDriver(dbDriver);
    }

    public void _setEnableDBTransaction(boolean enableDBTransaction) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setEnableDBTransaction(enableDBTransaction);
    }

    public void _setDbAdaptor(String dbAdaptor) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbAdaptor(dbAdaptor);
    }

    public void _setDbtype(String dbtype) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbtype(dbtype);
    }

    public void _setDbUrl(String dbUrl) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbUrl(dbUrl);
    }

    public void _setDbUser(String dbUser) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbUser(dbUser);
    }

    public void _setValidateSQL(String validateSQL) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setValidateSQL(validateSQL);
    }

    public void _setUsePool(boolean usePool) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setUsePool(usePool);
    }

    public List<DBConfig> getConfigs() {
        return this.configs;
    }

    public static void addFieldValue(List<FieldMeta> fieldValues, String fieldName, Object value) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setEsFieldName(fieldName);
        fieldMeta.setValue(value);
        fieldValues.add(fieldMeta);
    }

    public static void addFieldValue(List<FieldMeta> fieldValues, String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setEsFieldName(fieldName);
        fieldMeta.setValue(value);
        fieldMeta.setDateFormateMeta(BaseImportBuilder.buildDateFormateMeta(dateFormat, locale, timeZone));
        fieldValues.add(fieldMeta);
    }

    public BaseImportBuilder setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public BaseImportBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public BaseImportBuilder setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public DateFormateMeta buildDateFormateMeta(String dateFormat) {
        return dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)this.locale, (String)this.timeZone);
    }

    public static DateFormateMeta buildDateFormateMeta(String dateFormat, String locale, String timeZone) {
        return dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone);
    }

    private FieldMeta buildFieldMeta(String dbColumnName, String esFieldName, String dateFormat) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setEsFieldName(esFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)this.locale, (String)this.timeZone));
        return fieldMeta;
    }

    private static FieldMeta buildIgnoreFieldMeta(String dbColumnName) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setIgnore(true);
        return fieldMeta;
    }

    private FieldMeta buildFieldMeta(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setEsFieldName(esFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone));
        return fieldMeta;
    }

    public BaseImportBuilder addFieldMapping(String dbColumnName, String esFieldName) {
        this.fieldMetaMap.put(dbColumnName.toLowerCase(), this.buildFieldMeta(dbColumnName, esFieldName, null));
        return this;
    }

    public BaseImportBuilder addIgnoreFieldMapping(String dbColumnName) {
        BaseImportBuilder.addIgnoreFieldMapping(this.fieldMetaMap, dbColumnName);
        return this;
    }

    public static void addIgnoreFieldMapping(Map<String, FieldMeta> fieldMetaMap, String dbColumnName) {
        fieldMetaMap.put(dbColumnName.toLowerCase(), BaseImportBuilder.buildIgnoreFieldMeta(dbColumnName));
    }

    public BaseImportBuilder addFieldMapping(String dbColumnName, String esFieldName, String dateFormat) {
        this.fieldMetaMap.put(dbColumnName.toLowerCase(), this.buildFieldMeta(dbColumnName, esFieldName, dateFormat));
        return this;
    }

    public BaseImportBuilder addFieldMapping(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        this.fieldMetaMap.put(dbColumnName.toLowerCase(), this.buildFieldMeta(dbColumnName, esFieldName, dateFormat, locale, timeZone));
        return this;
    }

    public BaseImportBuilder addFieldValue(String fieldName, Object value) {
        BaseImportBuilder.addFieldValue(this.fieldValues, fieldName, value);
        return this;
    }

    public BaseImportBuilder addFieldValue(String fieldName, String dateFormat, Object value) {
        BaseImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, this.locale, this.timeZone);
        return this;
    }

    public BaseImportBuilder addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        BaseImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, locale, timeZone);
        return this;
    }

    public String getDataRefactorClass() {
        return this.dataRefactorClass;
    }

    public BaseImportBuilder setDataRefactor(DataRefactor dataRefactor) {
        this.dataRefactor = dataRefactor;
        this.dataRefactorClass = dataRefactor.getClass().getName();
        return this;
    }

    public BaseImportBuilder setExternalTimer(boolean externalTimer) {
        this.externalTimer = externalTimer;
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setExternalTimer(externalTimer);
        return this;
    }

    public boolean isPagine() {
        return this.pagine;
    }

    public BaseImportBuilder setPagine(boolean pagine) {
        this.pagine = pagine;
        return this;
    }

    public DBConfig getDbConfig() {
        return this.dbConfig;
    }

    @JsonIgnore
    public String getDbName() {
        if (this.dbConfig != null) {
            return this.dbConfig.getDbName();
        }
        throw new ESDataImportException("dbconfig is null.");
    }

    public static void main(String[] args) {
        System.out.println("meta:_id".substring(5));
    }

    protected void buildImportConfig(BaseImportConfig baseImportConfig) {
        if (this.getTargetElasticsearch() != null && !this.getTargetElasticsearch().equals("")) {
            baseImportConfig.setTargetElasticsearch(this.getTargetElasticsearch());
        }
        if (this.getSourceElasticsearch() != null && !this.getSourceElasticsearch().equals("")) {
            baseImportConfig.setSourceElasticsearch(this.getSourceElasticsearch());
        }
        if (this.esConfig != null) {
            baseImportConfig.setEsConfig(this.esConfig);
        }
        if (this.geoipConfig != null && this.geoipConfig.size() > 0) {
            baseImportConfig.setGeoipConfig(this.geoipConfig);
        }
        baseImportConfig.setDateFormat(this.dateFormat);
        baseImportConfig.setLocale(this.locale);
        baseImportConfig.setTimeZone(this.timeZone);
        baseImportConfig.setFetchSize(this.fetchSize);
        baseImportConfig.setClientOptions(this.clientOptions);
        baseImportConfig.setUseJavaName(this.useJavaName);
        baseImportConfig.setFieldMetaMap(this.fieldMetaMap);
        baseImportConfig.setFieldValues(this.fieldValues);
        baseImportConfig.setDataRefactor(this.dataRefactor);
        baseImportConfig.setSortLastValue(this.sortLastValue);
        baseImportConfig.setDbConfig(this.dbConfig);
        baseImportConfig.setStatusDbConfig(this.statusDbConfig);
        baseImportConfig.setConfigs(this.configs);
        baseImportConfig.setBatchSize(this.batchSize);
        if (this.index != null) {
            ESIndexWrapper esIndexWrapper = new ESIndexWrapper(this.index, this.indexType);
            baseImportConfig.setEsIndexWrapper(esIndexWrapper);
        }
        baseImportConfig.setApplicationPropertiesFile(this.applicationPropertiesFile);
        baseImportConfig.setParallel(this.parallel);
        baseImportConfig.setThreadCount(this.threadCount);
        baseImportConfig.setQueue(this.queue);
        baseImportConfig.setAsyn(this.asyn);
        baseImportConfig.setContinueOnError(this.continueOnError);
        baseImportConfig.setAsynResultPollTimeOut(this.asynResultPollTimeOut);
        baseImportConfig.setDiscardBulkResponse(this.discardBulkResponse);
        baseImportConfig.setDebugResponse(this.debugResponse);
        baseImportConfig.setScheduleConfig(this.scheduleConfig);
        baseImportConfig.setImportIncreamentConfig(this.importIncreamentConfig);
        if (this.scheduleBatchSize != null) {
            baseImportConfig.setScheduleBatchSize(this.scheduleBatchSize);
        } else {
            baseImportConfig.setScheduleBatchSize(this.batchSize);
        }
        baseImportConfig.setCallInterceptors(this.callInterceptors);
        baseImportConfig.setUseLowcase(this.useLowcase);
        baseImportConfig.setPrintTaskLog(this.printTaskLog);
        baseImportConfig.setEsIdGenerator(this.esIdGenerator);
        if (this.exportResultHandler != null) {
            baseImportConfig.setExportResultHandler(this.buildExportResultHandler(this.exportResultHandler));
        }
        baseImportConfig.setPagine(this.pagine);
        baseImportConfig.setTranDataBufferQueue(this.tranDataBufferQueue);
        baseImportConfig.setFlushInterval(this.flushInterval);
        baseImportConfig.setIgnoreNullValueField(this.ignoreNullValueField);
    }

    public BaseImportBuilder setTimeout(String timeout) {
        this.checkclientOptions();
        this.clientOptions.setTimeout(timeout);
        return this;
    }

    public BaseImportBuilder setMasterTimeout(String masterTimeout) {
        this.checkclientOptions();
        this.clientOptions.setMasterTimeout(masterTimeout);
        return this;
    }

    public BaseImportBuilder setWaitForActiveShards(Integer waitForActiveShards) {
        this.checkclientOptions();
        this.clientOptions.setWaitForActiveShards(waitForActiveShards);
        return this;
    }

    public BaseImportBuilder setSourceUpdateExcludes(List<String> sourceUpdateExcludes) {
        this.checkclientOptions();
        this.clientOptions.setSourceUpdateExcludes(sourceUpdateExcludes);
        return this;
    }

    public BaseImportBuilder setSourceUpdateIncludes(List<String> sourceUpdateIncludes) {
        this.checkclientOptions();
        this.clientOptions.setSourceUpdateIncludes(sourceUpdateIncludes);
        return this;
    }

    protected abstract WrapedExportResultHandler buildExportResultHandler(ExportResultHandler var1);

    public BaseImportBuilder setIndexType(String indexType) {
        this.indexType = indexType;
        return this;
    }

    public BaseImportBuilder setIndex(String index) {
        this.index = index;
        return this;
    }

    public BaseImportBuilder setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public BaseImportBuilder setRefreshOption(String refreshOption) {
        this.checkclientOptions();
        this.clientOptions.setRefreshOption(refreshOption);
        return this;
    }

    public boolean isFreezen() {
        return this.freezen;
    }

    public void setFreezen(boolean freezen) {
        this.freezen = freezen;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getIndex() {
        return this.index;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public Boolean getUseJavaName() {
        return this.useJavaName;
    }

    public BaseImportBuilder setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
        return this;
    }

    public BaseImportBuilder setEsVersionType(String esVersionType) {
        this.checkclientOptions();
        this.clientOptions.setVersionType(esVersionType);
        return this;
    }

    public BaseImportBuilder setEsVersionField(String esVersionField) {
        this.checkclientOptions();
        if (!esVersionField.startsWith("meta:")) {
            this.clientOptions.setVersionField(new ESField(false, esVersionField));
        } else {
            this.clientOptions.setVersionField(new ESField(true, esVersionField.substring(5)));
        }
        return this;
    }

    public BaseImportBuilder setEsReturnSource(Boolean esReturnSource) {
        this.checkclientOptions();
        this.clientOptions.setReturnSource(esReturnSource);
        return this;
    }

    public BaseImportBuilder setEsRetryOnConflict(Integer esRetryOnConflict) {
        this.checkclientOptions();
        this.clientOptions.setEsRetryOnConflict(esRetryOnConflict);
        return this;
    }

    public BaseImportBuilder setEsDocAsUpsert(Boolean esDocAsUpsert) {
        this.checkclientOptions();
        this.clientOptions.setDocasupsert(esDocAsUpsert);
        return this;
    }

    public BaseImportBuilder setRoutingValue(String routingValue) {
        this.checkclientOptions();
        this.clientOptions.setRouting(routingValue);
        return this;
    }

    public BaseImportBuilder setRoutingField(String routingField) {
        this.checkclientOptions();
        if (!routingField.startsWith("meta:")) {
            this.clientOptions.setRoutingField(new ESField(false, routingField));
        } else {
            this.clientOptions.setRoutingField(new ESField(true, routingField.substring(5)));
        }
        return this;
    }

    public BaseImportBuilder setEsParentIdField(String esParentIdField) {
        this.checkclientOptions();
        if (!esParentIdField.startsWith("meta:")) {
            this.clientOptions.setParentIdField(new ESField(false, esParentIdField));
        } else {
            this.clientOptions.setParentIdField(new ESField(true, esParentIdField.substring(5)));
        }
        return this;
    }

    public BaseImportBuilder setEsIdField(String esIdField) {
        this.checkclientOptions();
        if (!esIdField.startsWith("meta:")) {
            this.clientOptions.setIdField(new ESField(false, esIdField));
        } else {
            this.clientOptions.setIdField(new ESField(true, esIdField.substring(5)));
        }
        return this;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public BaseImportBuilder setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public abstract DataStream builder();

    public BaseImportBuilder setTranDataBufferQueue(int tranDataBufferQueue) {
        this.tranDataBufferQueue = tranDataBufferQueue;
        return this;
    }

    public String getEsIdGeneratorClass() {
        return this.esIdGeneratorClass;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public BaseImportBuilder setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    public boolean isIgnoreNullValueField() {
        return this.ignoreNullValueField;
    }

    public BaseImportBuilder setIgnoreNullValueField(boolean ignoreNullValueField) {
        this.ignoreNullValueField = ignoreNullValueField;
        return this;
    }

    public BaseImportBuilder setEsDetectNoop(Object esDetectNoop) {
        this.checkclientOptions();
        this.clientOptions.setDetectNoop(esDetectNoop);
        return this;
    }

    public boolean isSortLastValue() {
        return this.sortLastValue;
    }

    private void checkclientOptions() {
        if (this.clientOptions == null) {
            this.clientOptions = new ClientOptions();
        }
    }

    public BaseImportBuilder setSortLastValue(boolean sortLastValue) {
        this.sortLastValue = sortLastValue;
        return this;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    private void copy(ClientOptions oldClientOptions, ClientOptions newClientOptions) {
        if (oldClientOptions.getIdField() != null) {
            newClientOptions.setIdField(oldClientOptions.getIdField());
        }
        if (oldClientOptions.getRefreshOption() != null) {
            newClientOptions.setRefreshOption(oldClientOptions.getRefreshOption());
        }
    }

    public BaseImportBuilder setClientOptions(ClientOptions clientOptions) {
        if (this.clientOptions != null) {
            this.copy(this.clientOptions, clientOptions);
        }
        this.clientOptions = clientOptions;
        return this;
    }

    public String getTargetElasticsearch() {
        return this.targetElasticsearch;
    }

    public BaseImportBuilder setTargetElasticsearch(String targetElasticsearch) {
        this.targetElasticsearch = targetElasticsearch;
        return this;
    }

    public String getSourceElasticsearch() {
        return this.sourceElasticsearch;
    }

    public BaseImportBuilder setSourceElasticsearch(String sourceElasticsearch) {
        this.sourceElasticsearch = sourceElasticsearch;
        return this;
    }

    public BaseImportBuilder addElasticsearchProperty(String name, String value) {
        if (this.esConfig == null) {
            this.esConfig = new ESConfig();
        }
        this.esConfig.addElasticsearchProperty(name, value);
        return this;
    }

    public boolean isUseBatchContextIndexName() {
        return this.useBatchContextIndexName;
    }

    public BaseImportBuilder setUseBatchContextIndexName(boolean useBatchContextIndexName) {
        this.useBatchContextIndexName = useBatchContextIndexName;
        return this;
    }

    public BaseImportBuilder setGeoipDatabase(String geoipDatabase) {
        this.geoipDatabase = geoipDatabase;
        return this;
    }

    public BaseImportBuilder setGeoipAsnDatabase(String geoipAsnDatabase) {
        this.geoipAsnDatabase = geoipAsnDatabase;
        return this;
    }

    public BaseImportBuilder setGeoipCachesize(int geoipCachesize) {
        this.geoipCachesize = geoipCachesize;
        return this;
    }

    public BaseImportBuilder setGeoipTaobaoServiceURL(String geoipTaobaoServiceURL) {
        this.geoipTaobaoServiceURL = geoipTaobaoServiceURL;
        return this;
    }

    public String getStatusDbname() {
        return this.statusDbname;
    }

    public BaseImportBuilder setStatusDbname(String statusDbname) {
        this.statusDbname = statusDbname;
        return this;
    }

    public String getStatusTableDML() {
        return this.statusTableDML;
    }

    public BaseImportBuilder setStatusTableDML(String statusTableDML) {
        this.statusTableDML = statusTableDML;
        return this;
    }
}

