/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.es.input.db;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.common.poolman.SQLExecutor;
import java.util.List;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.scroll.HandlerInfo;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.es.BaseESExporterScrollHandler;
import org.frameworkset.tran.es.input.db.ES2DBContext;

public class ESDirectExporterScrollHandler<T>
extends BaseESExporterScrollHandler<T> {
    protected ConfigSQLExecutor configSQLExecutor;
    protected ES2DBContext es2DBContext;

    public ESDirectExporterScrollHandler(ImportContext importContext, ConfigSQLExecutor configSQLExecutor) {
        super(importContext);
        this.configSQLExecutor = configSQLExecutor;
        this.es2DBContext = (ES2DBContext)((Object)importContext);
    }

    @Override
    public void handle(ESDatas<T> response, HandlerInfo handlerInfo) throws Exception {
        long totalSize = response.getTotalSize();
        List datas = response.getDatas();
        int batchNo = this.importContext.getExportCount().increamentCount();
        if (totalSize == 0L || datas == null || datas.size() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Igonre Execute export task {}:zero or null datas.", (Object)batchNo);
            }
            return;
        }
        int batchSize = this.importContext.getStoreBatchSize();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Execute task {} start.", (Object)batchNo);
        }
        if (this.es2DBContext.getSql() == null) {
            this.configSQLExecutor.executeBatch(this.importContext.getDbConfig().getDbName(), this.es2DBContext.getSqlName(), datas, batchSize, this.es2DBContext.getBatchHandler());
        } else {
            SQLExecutor.executeBatch((String)this.importContext.getDbConfig().getDbName(), (String)this.es2DBContext.getSql(), (List)datas, (int)batchSize, (BatchHandler)this.es2DBContext.getBatchHandler());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Execute task {} complete and export data {} record.", (Object)batchNo, (Object)datas.size());
        }
    }
}

