/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db.output;

import com.frameworkset.util.VariableHandler;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.Param;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ContextImpl;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.output.Base2DBTaskCommandImpl;
import org.frameworkset.tran.db.output.DBOutPutContext;
import org.frameworkset.tran.db.output.TranSQLInfo;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.ParallImportCount;
import org.frameworkset.tran.metrics.SerialImportCount;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.task.TaskCall;
import org.slf4j.Logger;

public abstract class DBOutPutDataTran<T>
extends BaseDataTran {
    protected DBOutPutContext es2DBContext;

    @Override
    public void logTaskStart(Logger logger) {
        logger.info("import data to db[" + this.importContext.getDbConfig().getDbUrl() + "] dbuser[" + this.importContext.getDbConfig().getDbUser() + " sql[" + this.es2DBContext.getSqlInfo().getOriginSQL() + "] start.");
    }

    @Override
    protected void init() {
        this.es2DBContext = (DBOutPutContext)((Object)this.importContext);
    }

    public DBOutPutDataTran(TranResultSet jdbcResultSet, ImportContext importContext) {
        super(jdbcResultSet, importContext);
    }

    @Override
    public String serialExecute() {
        Object lastValue = null;
        Throwable exception = null;
        long start = System.currentTimeMillis();
        Status currentStatus = this.importContext.getCurrentStatus();
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        SerialImportCount importCount = new SerialImportCount();
        int taskNo = 0;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        try {
            TranSQLInfo sqlinfo = this.es2DBContext.getSqlInfo();
            Object temp = null;
            Object param = null;
            ArrayList<List<Param>> records = new ArrayList<List<Param>>();
            while (true) {
                Boolean hasNext;
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    if (records.size() <= 0) continue;
                    Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(sqlinfo.getSql(), importCount, this.importContext, records, ++taskNo, importCount.getJobNo());
                    TaskCall.call(taskCommand);
                    this.importContext.flushLastValue(lastValue);
                    records.clear();
                    if (!this.isPrintTaskLog()) continue;
                    long end = System.currentTimeMillis();
                    this.logger.info("Force flush records Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records.");
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                try {
                    lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                    ContextImpl context = new ContextImpl(this.importContext, this.jdbcResultSet, null);
                    context.refactorData();
                    context.afterRefactor();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    List<Param> record = this.buildRecord(context, sqlinfo.getVars());
                    records.add(record);
                    ++totalCount;
                }
                catch (Exception e) {
                    throw new ElasticSearchException((Throwable)e);
                }
            }
            if (records.size() > 0) {
                Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(sqlinfo.getSql(), importCount, this.importContext, records, ++taskNo, importCount.getJobNo());
                TaskCall.call(taskCommand);
                this.importContext.flushLastValue(lastValue);
            }
            if (this.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                this.logger.info("All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records.");
            }
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition((Exception)exception, this.importContext)) {
                this.stop();
            }
            if (this.importContext.isCurrentStoped()) {
                this.stop();
            }
            importCount.setJobEndTime(new Date());
        }
        return null;
    }

    private List<Param> buildRecord(Context context, List<VariableHandler.Variable> vars) {
        Object temp = null;
        Param param = null;
        ArrayList<Param> record = new ArrayList<Param>();
        HashMap<String, Object> addedFields = new HashMap<String, Object>();
        List<FieldMeta> fieldValueMetas = context.getFieldValues();
        this.appendFieldValues(record, vars, fieldValueMetas, addedFields);
        fieldValueMetas = context.getESJDBCFieldValues();
        this.appendFieldValues(record, vars, fieldValueMetas, addedFields);
        for (int i = 0; i < vars.size(); ++i) {
            VariableHandler.Variable var = vars.get(i);
            if (addedFields.get(var.getVariableName()) != null) continue;
            temp = this.jdbcResultSet.getValue(var.getVariableName());
            if (temp == null) {
                this.logger.warn("\u672a\u6307\u5b9a\u7ed1\u5b9a\u53d8\u91cf\u7684\u503c\uff1a{}", (Object)var.getVariableName());
            }
            param = new Param();
            param.setVariable(var);
            param.setIndex(var.getPosition() + 1);
            param.setValue(temp);
            param.setName(var.getVariableName());
            record.add(param);
        }
        return record;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute() {
        TranErrorWrapper tranErrorWrapper;
        Object lastValue;
        Throwable exception;
        ParallImportCount totalCount;
        ArrayList<Future> tasks;
        ExecutorService service;
        block16: {
            int count = 0;
            service = this.importContext.buildThreadPool();
            tasks = new ArrayList<Future>();
            int taskNo = 0;
            totalCount = new ParallImportCount();
            exception = null;
            Status currentStatus = this.importContext.getCurrentStatus();
            Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
            lastValue = null;
            tranErrorWrapper = new TranErrorWrapper(this.importContext);
            int batchsize = this.importContext.getStoreBatchSize();
            try {
                block15: {
                    TranSQLInfo sqlinfo = this.es2DBContext.getSqlInfo();
                    Object temp = null;
                    Object param = null;
                    ArrayList<List<Param>> records = new ArrayList<List<Param>>();
                    while (true) {
                        Boolean hasNext;
                        if (!tranErrorWrapper.assertCondition()) {
                            tranErrorWrapper.throwError();
                        }
                        if ((hasNext = this.jdbcResultSet.next()) == null) {
                            if (count <= 0) continue;
                            count = 0;
                            Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(sqlinfo.getSql(), totalCount, this.importContext, records, ++taskNo, totalCount.getJobNo());
                            records = new ArrayList();
                            tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                            continue;
                        }
                        if (!hasNext.booleanValue()) {
                            if (count > 0) {
                                break;
                            }
                            break block15;
                        }
                        lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                        ContextImpl context = new ContextImpl(this.importContext, this.jdbcResultSet, null);
                        context.refactorData();
                        context.afterRefactor();
                        if (context.isDrop()) {
                            ((ImportCount)totalCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        List<Param> record = this.buildRecord(context, sqlinfo.getVars());
                        records.add(record);
                        if (++count < batchsize) continue;
                        count = 0;
                        Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(sqlinfo.getSql(), totalCount, this.importContext, records, ++taskNo, totalCount.getJobNo());
                        records = new ArrayList();
                        tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    }
                    if (!tranErrorWrapper.assertCondition()) {
                        tranErrorWrapper.throwError();
                    }
                    Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(sqlinfo.getSql(), totalCount, this.importContext, records, ++taskNo, totalCount.getJobNo());
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    if (this.isPrintTaskLog()) {
                        this.logger.info("submit tasks:" + taskNo);
                    }
                    break block16;
                }
                if (this.isPrintTaskLog()) {
                    this.logger.info("submit tasks:" + taskNo);
                }
            }
            catch (SQLException e) {
                try {
                    exception = e;
                    throw new ElasticSearchException((Throwable)e);
                    catch (ElasticSearchException e2) {
                        exception = e2;
                        throw e2;
                    }
                    catch (Exception e3) {
                        exception = e3;
                        throw new ElasticSearchException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper);
                    totalCount.setJobEndTime(new Date());
                    throw throwable;
                }
            }
        }
        this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper);
        totalCount.setJobEndTime(new Date());
        return null;
    }

    @Override
    public String batchExecute() {
        int count = 0;
        String ret = null;
        int taskNo = 0;
        Throwable exception = null;
        Status currentStatus = this.importContext.getCurrentStatus();
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        TranErrorWrapper tranErrorWrapper = new TranErrorWrapper(this.importContext);
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        SerialImportCount importCount = new SerialImportCount();
        int batchsize = this.importContext.getStoreBatchSize();
        try {
            istart = start;
            TranSQLInfo sqlinfo = this.es2DBContext.getSqlInfo();
            ArrayList<List<Param>> records = new ArrayList<List<Param>>();
            while (true) {
                Boolean hasNext;
                if (!tranErrorWrapper.assertCondition()) {
                    this.jdbcResultSet.stop();
                    tranErrorWrapper.throwError();
                }
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    if (count <= 0) continue;
                    Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(sqlinfo.getSql(), importCount, this.importContext, records, ++taskNo, importCount.getJobNo());
                    int temp = count;
                    count = 0;
                    records = new ArrayList();
                    ret = TaskCall.call(taskCommand);
                    this.importContext.flushLastValue(lastValue);
                    if (this.isPrintTaskLog()) {
                        end = System.currentTimeMillis();
                        this.logger.info("Force flush datas Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + temp + " records.");
                        istart = end;
                    }
                    totalCount += (long)temp;
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                ContextImpl context = new ContextImpl(this.importContext, this.jdbcResultSet, null);
                context.refactorData();
                context.afterRefactor();
                if (context.isDrop()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                List<Param> record = this.buildRecord(context, sqlinfo.getVars());
                records.add(record);
                if (++count < batchsize) continue;
                Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(sqlinfo.getSql(), importCount, this.importContext, records, ++taskNo, importCount.getJobNo());
                int temp = count;
                count = 0;
                records = new ArrayList();
                ret = TaskCall.call(taskCommand);
                this.importContext.flushLastValue(lastValue);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + temp + " records.");
                    istart = end;
                }
                totalCount += (long)temp;
            }
            if (count > 0) {
                if (!tranErrorWrapper.assertCondition()) {
                    tranErrorWrapper.throwError();
                }
                Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(sqlinfo.getSql(), importCount, this.importContext, records, ++taskNo, importCount.getJobNo());
                ret = TaskCall.call(taskCommand);
                this.importContext.flushLastValue(lastValue);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + count + " records.");
                }
                totalCount += (long)count;
            }
            if (this.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                this.logger.info("Execute Tasks:" + taskNo + ",All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!tranErrorWrapper.assertCondition((Exception)exception)) {
                this.stop();
            }
            importCount.setJobEndTime(new Date());
        }
        return ret;
    }

    private void appendFieldValues(List<Param> record, List<VariableHandler.Variable> vars, List<FieldMeta> fieldValueMetas, Map<String, Object> addedFields) {
        if (fieldValueMetas == null || fieldValueMetas.size() == 0) {
            return;
        }
        boolean i = false;
        Param param = null;
        block0: for (VariableHandler.Variable variable : vars) {
            if (addedFields.containsKey(variable.getVariableName())) continue;
            for (FieldMeta fieldMeta : fieldValueMetas) {
                if (!variable.getVariableName().equals(fieldMeta.getEsFieldName())) continue;
                param = new Param();
                param.setVariable(variable);
                param.setIndex(variable.getPosition() + 1);
                param.setValue(fieldMeta.getValue());
                param.setName(variable.getVariableName());
                record.add(param);
                addedFields.put(variable.getVariableName(), dummy);
                continue block0;
            }
        }
    }
}

